/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "to" locale.
 */
public class LocalizedNamesImpl_to extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AI",
        "AG",
        "FR",
        "PH",
        "FI",
        "FJ",
        "HT",
        "WS",
        "AS",
        "NL",
        "HK",
        "HN",
        "HU",
        "YE",
        "BQ",
        "GR",
        "CM",
        "GM",
        "KH",
        "GH",
        "CA",
        "GA",
        "KZ",
        "QA",
        "GD",
        "KE",
        "KG",
        "KI",
        "GN",
        "GW",
        "CU",
        "KP",
        "KR",
        "CO",
        "VA",
        "KM",
        "CD",
        "CG",
        "CR",
        "XK",
        "GU",
        "GP",
        "GT",
        "KW",
        "GG",
        "GY",
        "GF",
        "CW",
        "GL",
        "HR",
        "LR",
        "LU",
        "LV",
        "LA",
        "LB",
        "DO",
        "CF",
        "LS",
        "RE",
        "LI",
        "LY",
        "LT",
        "RO",
        "RW",
        "RU",
        "YT",
        "MO",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MK",
        "CI",
        "MG",
        "MQ",
        "MR",
        "MU",
        "MX",
        "MM",
        "FM",
        "MA",
        "MD",
        "MC",
        "MN",
        "ME",
        "MZ",
        "CP",
        "CX",
        "IM",
        "NF",
        "BV",
        "AC",
        "MS",
        "CV",
        "NG",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NU",
        "NC",
        "NO",
        "NZ",
        "BS",
        "PK",
        "PY",
        "BR",
        "PW",
        "BH",
        "PA",
        "BB",
        "PG",
        "BF",
        "BY",
        "BE",
        "BZ",
        "PE",
        "BM",
        "BD",
        "BJ",
        "GB",
        "PL",
        "PF",
        "BO",
        "BA",
        "BW",
        "IO",
        "TF",
        "PT",
        "PS",
        "PR",
        "US",
        "BG",
        "BN",
        "BI",
        "BT",
        "EH",
        "SH",
        "CY",
        "KN",
        "LC",
        "JM",
        "SM",
        "MF",
        "SX",
        "ST",
        "BL",
        "PM",
        "TD",
        "SA",
        "VC",
        "CZ",
        "JE",
        "ZM",
        "SN",
        "GE",
        "RS",
        "CN",
        "DE",
        "JP",
        "SL",
        "LK",
        "CL",
        "SY",
        "SK",
        "SI",
        "ZW",
        "SG",
        "GI",
        "ES",
        "DJ",
        "EA",
        "SJ",
        "JO",
        "SO",
        "SZ",
        "SE",
        "CH",
        "SR",
        "SS",
        "SD",
        "TH",
        "TW",
        "TJ",
        "DK",
        "TZ",
        "DG",
        "TT",
        "TL",
        "TR",
        "TK",
        "TG",
        "DM",
        "TO",
        "TM",
        "TA",
        "TN",
        "TV",
        "VU",
        "VE",
        "VN",
        "XA",
        "XB",
        "IE",
        "AF",
        "ZA",
        "IS",
        "AE",
        "AL",
        "DZ",
        "AW",
        "AM",
        "AO",
        "AQ",
        "AD",
        "AU",
        "AT",
        "AZ",
        "AR",
        "GQ",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "EZ",
        "IQ",
        "IR",
        "IN",
        "ID",
        "IL",
        "EG",
        "IT",
        "ET",
        "UG",
        "OM",
        "QO",
        "FO",
        "FK",
        "HM",
        "IC",
        "KY",
        "CC",
        "CK",
        "MP",
        "MH",
        "PN",
        "SC",
        "GS",
        "UM",
        "SB",
        "TC",
        "VG",
        "VI",
        "AX",
        "UN",
        "UA",
        "UY",
        "UZ",
        "WF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Māmani");
    namesMap.put("002", "ʻAfilika");
    namesMap.put("003", "ʻAmelika tokelau");
    namesMap.put("005", "ʻAmelika tonga");
    namesMap.put("009", "ʻOsēnia");
    namesMap.put("011", "ʻAfilika fakahihifo");
    namesMap.put("013", "ʻAmelika lotoloto");
    namesMap.put("014", "ʻAfilika fakahahake");
    namesMap.put("015", "ʻAfilika fakatokelau");
    namesMap.put("017", "ʻAfilika lotoloto");
    namesMap.put("018", "ʻAfilika fakatonga");
    namesMap.put("019", "Ongo ʻAmelika");
    namesMap.put("021", "ʻAmelika fakatokelau");
    namesMap.put("029", "Kalipiane");
    namesMap.put("030", "ʻĒsia fakahahake");
    namesMap.put("034", "ʻĒsia fakatonga");
    namesMap.put("035", "ʻĒsia fakatongahahake");
    namesMap.put("039", "ʻEulope fakatonga");
    namesMap.put("053", "ʻAositelēlēsia");
    namesMap.put("054", "Melanīsia");
    namesMap.put("057", "Potu fonua Mikolonīsia");
    namesMap.put("061", "Polinīsia");
    namesMap.put("142", "ʻĒsia");
    namesMap.put("143", "ʻĒsia lotoloto");
    namesMap.put("145", "ʻĒsia fakahihifo");
    namesMap.put("150", "ʻEulope");
    namesMap.put("151", "ʻEulope fakahahake");
    namesMap.put("154", "ʻEulope fakatokelau");
    namesMap.put("155", "ʻEulope fakahihifo");
    namesMap.put("419", "ʻAmelika fakalatina");
    namesMap.put("AC", "Motu ʻAsenisini");
    namesMap.put("AD", "ʻAnitola");
    namesMap.put("AE", "ʻAlepea Fakatahataha");
    namesMap.put("AF", "ʻAfikānisitani");
    namesMap.put("AG", "Anitikua mo Palaputa");
    namesMap.put("AI", "Anikuila");
    namesMap.put("AL", "ʻAlipania");
    namesMap.put("AM", "ʻĀmenia");
    namesMap.put("AO", "ʻAngikola");
    namesMap.put("AQ", "ʻAnitātika");
    namesMap.put("AR", "ʻAsenitina");
    namesMap.put("AS", "Haʻamoa ʻAmelika");
    namesMap.put("AT", "ʻAositulia");
    namesMap.put("AU", "ʻAositelēlia");
    namesMap.put("AW", "ʻAlupa");
    namesMap.put("AX", "ʻOtumotu ʻAlani");
    namesMap.put("AZ", "ʻAsapaisani");
    namesMap.put("BA", "Posinia mo Hesikōvina");
    namesMap.put("BB", "Pāpeitosi");
    namesMap.put("BD", "Pengilātesi");
    namesMap.put("BE", "Pelesiume");
    namesMap.put("BF", "Pekano Faso");
    namesMap.put("BG", "Pulukalia");
    namesMap.put("BH", "Paleini");
    namesMap.put("BI", "Puluniti");
    namesMap.put("BJ", "Penini");
    namesMap.put("BL", "Sā Patēlemi");
    namesMap.put("BM", "Pēmuta");
    namesMap.put("BN", "Pulunei");
    namesMap.put("BO", "Polīvia");
    namesMap.put("BQ", "Kalipiane fakahōlani");
    namesMap.put("BR", "Palāsili");
    namesMap.put("BS", "Pahama");
    namesMap.put("BT", "Pūtani");
    namesMap.put("BV", "Motu Puveti");
    namesMap.put("BW", "Potisiuana");
    namesMap.put("BY", "Pelalusi");
    namesMap.put("BZ", "Pelise");
    namesMap.put("CA", "Kānata");
    namesMap.put("CC", "ʻOtumotu Koko");
    namesMap.put("CD", "Kongo - Kinisasa");
    namesMap.put("CF", "Lepupelika ʻAfilika Lotoloto");
    namesMap.put("CG", "Kongo - Palasavila");
    namesMap.put("CH", "Suisilani");
    namesMap.put("CI", "Matafonua ʻAivolī");
    namesMap.put("CK", "ʻOtumotu Kuki");
    namesMap.put("CL", "Sili");
    namesMap.put("CM", "Kameluni");
    namesMap.put("CN", "Siaina");
    namesMap.put("CO", "Kolomipia");
    namesMap.put("CP", "Motu Kilipatoni");
    namesMap.put("CR", "Kosita Lika");
    namesMap.put("CU", "Kiupa");
    namesMap.put("CV", "Muiʻi Vēte");
    namesMap.put("CW", "Kulasao");
    namesMap.put("CX", "Motu Kilisimasi");
    namesMap.put("CY", "Saipalesi");
    namesMap.put("CZ", "Sēkia");
    namesMap.put("DE", "Siamane");
    namesMap.put("DG", "Tieko Kāsia");
    namesMap.put("DJ", "Siputi");
    namesMap.put("DK", "Tenimaʻake");
    namesMap.put("DM", "Tominika");
    namesMap.put("DO", "Lepupelika Tominika");
    namesMap.put("DZ", "ʻAlisilia");
    namesMap.put("EA", "Siuta mo Melila");
    namesMap.put("EC", "ʻEkuetoa");
    namesMap.put("EE", "ʻEsitōnia");
    namesMap.put("EG", "ʻIsipite");
    namesMap.put("EH", "Sahala fakahihifo");
    namesMap.put("ER", "ʻElitulia");
    namesMap.put("ES", "Sipeini");
    namesMap.put("ET", "ʻĪtiōpia");
    namesMap.put("EU", "ʻEulope fakatahataha");
    namesMap.put("EZ", "ʻEulope fekauʻaki-paʻanga");
    namesMap.put("FI", "Finilani");
    namesMap.put("FJ", "Fisi");
    namesMap.put("FK", "ʻOtumotu Fokulani");
    namesMap.put("FM", "Mikolonīsia");
    namesMap.put("FO", "ʻOtumotu Faloe");
    namesMap.put("FR", "Falanisē");
    namesMap.put("GA", "Kaponi");
    namesMap.put("GB", "Pilitānia");
    namesMap.put("GD", "Kelenatā");
    namesMap.put("GE", "Seōsia");
    namesMap.put("GF", "Kuiana fakafalanisē");
    namesMap.put("GG", "Kuenisī");
    namesMap.put("GH", "Kana");
    namesMap.put("GI", "Sipalālitā");
    namesMap.put("GL", "Kulinilani");
    namesMap.put("GM", "Kamipia");
    namesMap.put("GN", "Kini");
    namesMap.put("GP", "Kuatalupe");
    namesMap.put("GQ", "ʻEkueta Kini");
    namesMap.put("GR", "Kalisi");
    namesMap.put("GS", "ʻOtumotu Seōsia-tonga mo Saniuisi-tonga");
    namesMap.put("GT", "Kuatamala");
    namesMap.put("GU", "Kuamu");
    namesMap.put("GW", "Kini-Pisau");
    namesMap.put("GY", "Kuiana");
    namesMap.put("HK", "Hongi Kongi SAR Siaina");
    namesMap.put("HM", "ʻOtumotu Heati mo Makitonali");
    namesMap.put("HN", "Honitulasi");
    namesMap.put("HR", "Kuloisia");
    namesMap.put("HU", "Hungakalia");
    namesMap.put("IC", "ʻOtumotu Kaneli");
    namesMap.put("ID", "ʻInitonēsia");
    namesMap.put("IE", "ʻAealani");
    namesMap.put("IL", "ʻIsileli");
    namesMap.put("IM", "Motu Mani");
    namesMap.put("IN", "ʻInitia");
    namesMap.put("IO", "Potu fonua moana ʻInitia fakapilitānia");
    namesMap.put("IQ", "ʻIlaaki");
    namesMap.put("IR", "ʻIlaani");
    namesMap.put("IS", "ʻAisilani");
    namesMap.put("IT", "ʻĪtali");
    namesMap.put("JE", "Selusī");
    namesMap.put("JM", "Samaika");
    namesMap.put("JO", "Soatane");
    namesMap.put("JP", "Siapani");
    namesMap.put("KE", "Keniā");
    namesMap.put("KG", "Kīkisitani");
    namesMap.put("KH", "Kamipōtia");
    namesMap.put("KI", "Kilipasi");
    namesMap.put("KM", "Komolosi");
    namesMap.put("KN", "Sā Kitisi mo Nevisi");
    namesMap.put("KP", "Kōlea tokelau");
    namesMap.put("KR", "Kōlea tonga");
    namesMap.put("KW", "Kueiti");
    namesMap.put("KY", "ʻOtumotu Keimeni");
    namesMap.put("KZ", "Kasakitani");
    namesMap.put("LA", "Lau");
    namesMap.put("LB", "Lepanoni");
    namesMap.put("LC", "Sā Lūsia");
    namesMap.put("LI", "Likitenisiteini");
    namesMap.put("LK", "Sīlangikā");
    namesMap.put("LR", "Laipelia");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Lakisimipeki");
    namesMap.put("LV", "Lativia");
    namesMap.put("LY", "Līpia");
    namesMap.put("MA", "Moloko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Molotova");
    namesMap.put("ME", "Monitenikalo");
    namesMap.put("MF", "Sā Mātini (fakafalanisē)");
    namesMap.put("MG", "Matakasika");
    namesMap.put("MH", "ʻOtumotu Māsolo");
    namesMap.put("MK", "Masetōnia");
    namesMap.put("ML", "Māli");
    namesMap.put("MM", "Mianimā (Pema)");
    namesMap.put("MN", "Mongokōlia");
    namesMap.put("MO", "Makau SAR Siaina");
    namesMap.put("MP", "ʻOtumotu Maliana tokelau");
    namesMap.put("MQ", "Mātiniki");
    namesMap.put("MR", "Maulitenia");
    namesMap.put("MS", "Moʻungaselati");
    namesMap.put("MT", "Malita");
    namesMap.put("MU", "Maulitiusi");
    namesMap.put("MV", "Malativisi");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "Mekisikou");
    namesMap.put("MY", "Malēsia");
    namesMap.put("MZ", "Mosēmipiki");
    namesMap.put("NA", "Namipia");
    namesMap.put("NC", "Niu Kaletōnia");
    namesMap.put("NE", "Nisia");
    namesMap.put("NF", "Motu Nōfoliki");
    namesMap.put("NG", "Naisilia");
    namesMap.put("NI", "Nikalakua");
    namesMap.put("NL", "Hōlani");
    namesMap.put("NO", "Noauē");
    namesMap.put("NP", "Nepali");
    namesMap.put("NR", "Naulu");
    namesMap.put("NU", "Niuē");
    namesMap.put("NZ", "Nuʻusila");
    namesMap.put("OM", "ʻOmani");
    namesMap.put("PA", "Panamā");
    namesMap.put("PE", "Pelū");
    namesMap.put("PF", "Polinisia fakafalanisē");
    namesMap.put("PG", "Papuaniukini");
    namesMap.put("PH", "Filipaini");
    namesMap.put("PK", "Pākisitani");
    namesMap.put("PL", "Polani");
    namesMap.put("PM", "Sā Piea mo Mikeloni");
    namesMap.put("PN", "ʻOtumotu Pitikeni");
    namesMap.put("PR", "Puēto Liko");
    namesMap.put("PS", "Potu Palesitaine");
    namesMap.put("PT", "Potukali");
    namesMap.put("PY", "Palakuai");
    namesMap.put("QA", "Katā");
    namesMap.put("QO", "ʻOsēnia mamaʻo");
    namesMap.put("RE", "Lēunioni");
    namesMap.put("RO", "Lomēnia");
    namesMap.put("RS", "Sēpia");
    namesMap.put("RU", "Lūsia");
    namesMap.put("RW", "Luanitā");
    namesMap.put("SA", "Saute ʻAlepea");
    namesMap.put("SB", "ʻOtumotu Solomone");
    namesMap.put("SC", "ʻOtumotu Seiseli");
    namesMap.put("SD", "Sūteni");
    namesMap.put("SE", "Suēteni");
    namesMap.put("SG", "Singapoa");
    namesMap.put("SH", "Sā Helena");
    namesMap.put("SI", "Silōvenia");
    namesMap.put("SJ", "Sivolopāti mo Sani Maieni");
    namesMap.put("SK", "Silōvakia");
    namesMap.put("SL", "Siela Leone");
    namesMap.put("SM", "Sā Malino");
    namesMap.put("SN", "Senekalo");
    namesMap.put("SO", "Sōmalia");
    namesMap.put("SR", "Suliname");
    namesMap.put("SS", "Sūtani fakatonga");
    namesMap.put("ST", "Sao Tomē mo Pilinisipe");
    namesMap.put("SV", "ʻEle Salavatoa");
    namesMap.put("SX", "Sā Mātini (fakahōlani)");
    namesMap.put("SY", "Sīlia");
    namesMap.put("SZ", "Suasilani");
    namesMap.put("TA", "Tulisitani ta Kunuha");
    namesMap.put("TC", "ʻOtumotu Tuki mo Kaikosi");
    namesMap.put("TD", "Sāti");
    namesMap.put("TF", "Potu fonua tonga fakafalanisē");
    namesMap.put("TG", "Toko");
    namesMap.put("TH", "Tailani");
    namesMap.put("TJ", "Tasikitani");
    namesMap.put("TL", "Timoa hahake");
    namesMap.put("TM", "Tūkimenisitani");
    namesMap.put("TN", "Tunīsia");
    namesMap.put("TR", "Toake");
    namesMap.put("TT", "Tilinitati mo Topako");
    namesMap.put("TV", "Tūvalu");
    namesMap.put("TW", "Taiuani");
    namesMap.put("TZ", "Tenisānia");
    namesMap.put("UA", "ʻŪkalaʻine");
    namesMap.put("UG", "ʻIukanitā");
    namesMap.put("UM", "ʻOtumotu siʻi ʻo ʻAmelika");
    namesMap.put("UN", "ʻŪ fonua fakatahataha");
    namesMap.put("US", "Puleʻanga fakatahataha ʻAmelika");
    namesMap.put("UY", "ʻUlukuai");
    namesMap.put("UZ", "ʻUsipekitani");
    namesMap.put("VA", "Kolo Vatikani");
    namesMap.put("VC", "Sā Viniseni mo Kulenatini");
    namesMap.put("VE", "Venesuela");
    namesMap.put("VG", "ʻOtumotu Vilikini fakapilitānia");
    namesMap.put("VI", "ʻOtumotu Vilikini fakaʻamelika");
    namesMap.put("VN", "Vietinami");
    namesMap.put("WF", "ʻUvea mo Futuna");
    namesMap.put("WS", "Haʻamoa");
    namesMap.put("XK", "Kōsovo");
    namesMap.put("YE", "Iemeni");
    namesMap.put("YT", "Maiote");
    namesMap.put("ZA", "ʻAfilika tonga");
    namesMap.put("ZM", "Semipia");
    namesMap.put("ZW", "Simipapuei");
    namesMap.put("ZZ", "Potu fonua taʻeʻiloa pe hala");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Māmani",
        "002": "ʻAfilika",
        "003": "ʻAmelika tokelau",
        "005": "ʻAmelika tonga",
        "009": "ʻOsēnia",
        "011": "ʻAfilika fakahihifo",
        "013": "ʻAmelika lotoloto",
        "014": "ʻAfilika fakahahake",
        "015": "ʻAfilika fakatokelau",
        "017": "ʻAfilika lotoloto",
        "018": "ʻAfilika fakatonga",
        "019": "Ongo ʻAmelika",
        "021": "ʻAmelika fakatokelau",
        "029": "Kalipiane",
        "030": "ʻĒsia fakahahake",
        "034": "ʻĒsia fakatonga",
        "035": "ʻĒsia fakatongahahake",
        "039": "ʻEulope fakatonga",
        "053": "ʻAositelēlēsia",
        "054": "Melanīsia",
        "057": "Potu fonua Mikolonīsia",
        "061": "Polinīsia",
        "142": "ʻĒsia",
        "143": "ʻĒsia lotoloto",
        "145": "ʻĒsia fakahihifo",
        "150": "ʻEulope",
        "151": "ʻEulope fakahahake",
        "154": "ʻEulope fakatokelau",
        "155": "ʻEulope fakahihifo",
        "419": "ʻAmelika fakalatina",
        "AC": "Motu ʻAsenisini",
        "AD": "ʻAnitola",
        "AE": "ʻAlepea Fakatahataha",
        "AF": "ʻAfikānisitani",
        "AG": "Anitikua mo Palaputa",
        "AI": "Anikuila",
        "AL": "ʻAlipania",
        "AM": "ʻĀmenia",
        "AO": "ʻAngikola",
        "AQ": "ʻAnitātika",
        "AR": "ʻAsenitina",
        "AS": "Haʻamoa ʻAmelika",
        "AT": "ʻAositulia",
        "AU": "ʻAositelēlia",
        "AW": "ʻAlupa",
        "AX": "ʻOtumotu ʻAlani",
        "AZ": "ʻAsapaisani",
        "BA": "Posinia mo Hesikōvina",
        "BB": "Pāpeitosi",
        "BD": "Pengilātesi",
        "BE": "Pelesiume",
        "BF": "Pekano Faso",
        "BG": "Pulukalia",
        "BH": "Paleini",
        "BI": "Puluniti",
        "BJ": "Penini",
        "BL": "Sā Patēlemi",
        "BM": "Pēmuta",
        "BN": "Pulunei",
        "BO": "Polīvia",
        "BQ": "Kalipiane fakahōlani",
        "BR": "Palāsili",
        "BS": "Pahama",
        "BT": "Pūtani",
        "BV": "Motu Puveti",
        "BW": "Potisiuana",
        "BY": "Pelalusi",
        "BZ": "Pelise",
        "CA": "Kānata",
        "CC": "ʻOtumotu Koko",
        "CD": "Kongo - Kinisasa",
        "CF": "Lepupelika ʻAfilika Lotoloto",
        "CG": "Kongo - Palasavila",
        "CH": "Suisilani",
        "CI": "Matafonua ʻAivolī",
        "CK": "ʻOtumotu Kuki",
        "CL": "Sili",
        "CM": "Kameluni",
        "CN": "Siaina",
        "CO": "Kolomipia",
        "CP": "Motu Kilipatoni",
        "CR": "Kosita Lika",
        "CU": "Kiupa",
        "CV": "Muiʻi Vēte",
        "CW": "Kulasao",
        "CX": "Motu Kilisimasi",
        "CY": "Saipalesi",
        "CZ": "Sēkia",
        "DE": "Siamane",
        "DG": "Tieko Kāsia",
        "DJ": "Siputi",
        "DK": "Tenimaʻake",
        "DM": "Tominika",
        "DO": "Lepupelika Tominika",
        "DZ": "ʻAlisilia",
        "EA": "Siuta mo Melila",
        "EC": "ʻEkuetoa",
        "EE": "ʻEsitōnia",
        "EG": "ʻIsipite",
        "EH": "Sahala fakahihifo",
        "ER": "ʻElitulia",
        "ES": "Sipeini",
        "ET": "ʻĪtiōpia",
        "EU": "ʻEulope fakatahataha",
        "EZ": "ʻEulope fekauʻaki-paʻanga",
        "FI": "Finilani",
        "FJ": "Fisi",
        "FK": "ʻOtumotu Fokulani",
        "FM": "Mikolonīsia",
        "FO": "ʻOtumotu Faloe",
        "FR": "Falanisē",
        "GA": "Kaponi",
        "GB": "Pilitānia",
        "GD": "Kelenatā",
        "GE": "Seōsia",
        "GF": "Kuiana fakafalanisē",
        "GG": "Kuenisī",
        "GH": "Kana",
        "GI": "Sipalālitā",
        "GL": "Kulinilani",
        "GM": "Kamipia",
        "GN": "Kini",
        "GP": "Kuatalupe",
        "GQ": "ʻEkueta Kini",
        "GR": "Kalisi",
        "GS": "ʻOtumotu Seōsia-tonga mo Saniuisi-tonga",
        "GT": "Kuatamala",
        "GU": "Kuamu",
        "GW": "Kini-Pisau",
        "GY": "Kuiana",
        "HK": "Hongi Kongi SAR Siaina",
        "HM": "ʻOtumotu Heati mo Makitonali",
        "HN": "Honitulasi",
        "HR": "Kuloisia",
        "HU": "Hungakalia",
        "IC": "ʻOtumotu Kaneli",
        "ID": "ʻInitonēsia",
        "IE": "ʻAealani",
        "IL": "ʻIsileli",
        "IM": "Motu Mani",
        "IN": "ʻInitia",
        "IO": "Potu fonua moana ʻInitia fakapilitānia",
        "IQ": "ʻIlaaki",
        "IR": "ʻIlaani",
        "IS": "ʻAisilani",
        "IT": "ʻĪtali",
        "JE": "Selusī",
        "JM": "Samaika",
        "JO": "Soatane",
        "JP": "Siapani",
        "KE": "Keniā",
        "KG": "Kīkisitani",
        "KH": "Kamipōtia",
        "KI": "Kilipasi",
        "KM": "Komolosi",
        "KN": "Sā Kitisi mo Nevisi",
        "KP": "Kōlea tokelau",
        "KR": "Kōlea tonga",
        "KW": "Kueiti",
        "KY": "ʻOtumotu Keimeni",
        "KZ": "Kasakitani",
        "LA": "Lau",
        "LB": "Lepanoni",
        "LC": "Sā Lūsia",
        "LI": "Likitenisiteini",
        "LK": "Sīlangikā",
        "LR": "Laipelia",
        "LS": "Lesoto",
        "LT": "Lituania",
        "LU": "Lakisimipeki",
        "LV": "Lativia",
        "LY": "Līpia",
        "MA": "Moloko",
        "MC": "Monako",
        "MD": "Molotova",
        "ME": "Monitenikalo",
        "MF": "Sā Mātini (fakafalanisē)",
        "MG": "Matakasika",
        "MH": "ʻOtumotu Māsolo",
        "MK": "Masetōnia",
        "ML": "Māli",
        "MM": "Mianimā (Pema)",
        "MN": "Mongokōlia",
        "MO": "Makau SAR Siaina",
        "MP": "ʻOtumotu Maliana tokelau",
        "MQ": "Mātiniki",
        "MR": "Maulitenia",
        "MS": "Moʻungaselati",
        "MT": "Malita",
        "MU": "Maulitiusi",
        "MV": "Malativisi",
        "MW": "Malaui",
        "MX": "Mekisikou",
        "MY": "Malēsia",
        "MZ": "Mosēmipiki",
        "NA": "Namipia",
        "NC": "Niu Kaletōnia",
        "NE": "Nisia",
        "NF": "Motu Nōfoliki",
        "NG": "Naisilia",
        "NI": "Nikalakua",
        "NL": "Hōlani",
        "NO": "Noauē",
        "NP": "Nepali",
        "NR": "Naulu",
        "NU": "Niuē",
        "NZ": "Nuʻusila",
        "OM": "ʻOmani",
        "PA": "Panamā",
        "PE": "Pelū",
        "PF": "Polinisia fakafalanisē",
        "PG": "Papuaniukini",
        "PH": "Filipaini",
        "PK": "Pākisitani",
        "PL": "Polani",
        "PM": "Sā Piea mo Mikeloni",
        "PN": "ʻOtumotu Pitikeni",
        "PR": "Puēto Liko",
        "PS": "Potu Palesitaine",
        "PT": "Potukali",
        "PY": "Palakuai",
        "QA": "Katā",
        "QO": "ʻOsēnia mamaʻo",
        "RE": "Lēunioni",
        "RO": "Lomēnia",
        "RS": "Sēpia",
        "RU": "Lūsia",
        "RW": "Luanitā",
        "SA": "Saute ʻAlepea",
        "SB": "ʻOtumotu Solomone",
        "SC": "ʻOtumotu Seiseli",
        "SD": "Sūteni",
        "SE": "Suēteni",
        "SG": "Singapoa",
        "SH": "Sā Helena",
        "SI": "Silōvenia",
        "SJ": "Sivolopāti mo Sani Maieni",
        "SK": "Silōvakia",
        "SL": "Siela Leone",
        "SM": "Sā Malino",
        "SN": "Senekalo",
        "SO": "Sōmalia",
        "SR": "Suliname",
        "SS": "Sūtani fakatonga",
        "ST": "Sao Tomē mo Pilinisipe",
        "SV": "ʻEle Salavatoa",
        "SX": "Sā Mātini (fakahōlani)",
        "SY": "Sīlia",
        "SZ": "Suasilani",
        "TA": "Tulisitani ta Kunuha",
        "TC": "ʻOtumotu Tuki mo Kaikosi",
        "TD": "Sāti",
        "TF": "Potu fonua tonga fakafalanisē",
        "TG": "Toko",
        "TH": "Tailani",
        "TJ": "Tasikitani",
        "TL": "Timoa hahake",
        "TM": "Tūkimenisitani",
        "TN": "Tunīsia",
        "TR": "Toake",
        "TT": "Tilinitati mo Topako",
        "TV": "Tūvalu",
        "TW": "Taiuani",
        "TZ": "Tenisānia",
        "UA": "ʻŪkalaʻine",
        "UG": "ʻIukanitā",
        "UM": "ʻOtumotu siʻi ʻo ʻAmelika",
        "UN": "ʻŪ fonua fakatahataha",
        "US": "Puleʻanga fakatahataha ʻAmelika",
        "UY": "ʻUlukuai",
        "UZ": "ʻUsipekitani",
        "VA": "Kolo Vatikani",
        "VC": "Sā Viniseni mo Kulenatini",
        "VE": "Venesuela",
        "VG": "ʻOtumotu Vilikini fakapilitānia",
        "VI": "ʻOtumotu Vilikini fakaʻamelika",
        "VN": "Vietinami",
        "WF": "ʻUvea mo Futuna",
        "WS": "Haʻamoa",
        "XK": "Kōsovo",
        "YE": "Iemeni",
        "YT": "Maiote",
        "ZA": "ʻAfilika tonga",
        "ZM": "Semipia",
        "ZW": "Simipapuei",
        "ZZ": "Potu fonua taʻeʻiloa pe hala"
    };
  }-*/;
}
