/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "jv" locale.
 */
public class LocalizedNamesImpl_jv extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ID",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "CZ",
        "TD",
        "CL",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "ER",
        "IS",
        "EE",
        "ET",
        "FM",
        "FJ",
        "FI",
        "GA",
        "GM",
        "GE",
        "GS",
        "GH",
        "GI",
        "GN",
        "GW",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HU",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "JM",
        "JP",
        "DE",
        "JE",
        "DJ",
        "NC",
        "KH",
        "CM",
        "CA",
        "UM",
        "AX",
        "CC",
        "CK",
        "FK",
        "FO",
        "HM",
        "IC",
        "KY",
        "MP",
        "MH",
        "PN",
        "SB",
        "VI",
        "VG",
        "GB",
        "BQ",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "KR",
        "KP",
        "XK",
        "CR",
        "HR",
        "CU",
        "CW",
        "VA",
        "KW",
        "HK",
        "MO",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MK",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "EG",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NZ",
        "NO",
        "OM",
        "QO",
        "AT",
        "AU",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "UN",
        "CI",
        "PE",
        "PH",
        "PL",
        "PF",
        "CV",
        "PT",
        "FR",
        "PR",
        "AC",
        "BV",
        "CP",
        "IM",
        "CX",
        "NF",
        "CF",
        "DO",
        "IE",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "BL",
        "SH",
        "KN",
        "PM",
        "VC",
        "ZM",
        "WS",
        "AS",
        "SM",
        "LC",
        "MF",
        "ST",
        "SN",
        "ES",
        "RS",
        "SC",
        "EA",
        "SL",
        "ZW",
        "SG",
        "SX",
        "CY",
        "SI",
        "SK",
        "SO",
        "LK",
        "SD",
        "SS",
        "SY",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "TW",
        "TJ",
        "TH",
        "TZ",
        "TL",
        "PS",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "CN",
        "UG",
        "UA",
        "AE",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "NL",
        "WF",
        "IO",
        "TF",
        "XA",
        "XB",
        "YE",
        "JO",
        "EZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Donya");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amérika Lèr");
    namesMap.put("005", "Amérika Kidul");
    namesMap.put("009", "Oséania");
    namesMap.put("011", "Afrika Kulon");
    namesMap.put("013", "Amérika Tengah");
    namesMap.put("014", "Afrika Wétan");
    namesMap.put("015", "Afrika Lèr");
    namesMap.put("017", "Afrika Sisih Tengah");
    namesMap.put("018", "Afrika Sisih Kidul");
    namesMap.put("019", "Amérika");
    namesMap.put("021", "Amérika Sisih Lor");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "Asia Wétan");
    namesMap.put("034", "Asia Kidul");
    namesMap.put("035", "Asia Kidul-wétan");
    namesMap.put("039", "Éropah Kidul");
    namesMap.put("057", "Daerah Mikronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Tengah");
    namesMap.put("145", "Asia Kulon");
    namesMap.put("150", "Éropah");
    namesMap.put("151", "Éropah Wétan");
    namesMap.put("154", "Éropah Lèr");
    namesMap.put("155", "Éropah Kulon");
    namesMap.put("202", "Afrika Kidule Sahara");
    namesMap.put("419", "Amérika Latin");
    namesMap.put("AC", "Pulo Ascension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Uni Émirat Arab");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua lan Barbuda");
    namesMap.put("AL", "Albani");
    namesMap.put("AM", "Arménia");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AR", "Argèntina");
    namesMap.put("AS", "Samoa Amerika");
    namesMap.put("AT", "Ostenrik");
    namesMap.put("AU", "Ostrali");
    namesMap.put("AX", "Kapuloan Alan");
    namesMap.put("BA", "Bosnia lan Hèrségovina");
    namesMap.put("BB", "Barbadhos");
    namesMap.put("BD", "Banggaladésa");
    namesMap.put("BE", "Bèlgi");
    namesMap.put("BG", "Bulgari");
    namesMap.put("BJ", "Bénin");
    namesMap.put("BL", "Saint Barthélémi");
    namesMap.put("BN", "Brunéi");
    namesMap.put("BQ", "Karibia Walanda");
    namesMap.put("BR", "Brasil");
    namesMap.put("BV", "Pulo Bovèt");
    namesMap.put("BY", "Bélarus");
    namesMap.put("BZ", "Bélisé");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kapuloan Cocos (Keeling)");
    namesMap.put("CD", "Kongo - Kinshasa");
    namesMap.put("CF", "Républik Afrika Tengah");
    namesMap.put("CG", "Kongo - Brassaville");
    namesMap.put("CH", "Switserlan");
    namesMap.put("CI", "Pasisir Gadhing");
    namesMap.put("CK", "Kapuloan Cook");
    namesMap.put("CL", "Cilé");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Tyongkok");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Pulo Clipperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Pongol Verdé");
    namesMap.put("CW", "Kurasao");
    namesMap.put("CX", "Pulo Natal");
    namesMap.put("CY", "Siprus");
    namesMap.put("CZ", "Céko");
    namesMap.put("DE", "Jérman");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Dhènemarken");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Républik Dominika");
    namesMap.put("DZ", "Aljasair");
    namesMap.put("EA", "Séuta lan Melila");
    namesMap.put("EC", "Ékuadhor");
    namesMap.put("EE", "Éstonia");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Kulon");
    namesMap.put("ER", "Éritréa");
    namesMap.put("ES", "Sepanyol");
    namesMap.put("ET", "Étiopia");
    namesMap.put("EU", "Uni Éropah");
    namesMap.put("EZ", "Zona Éuro");
    namesMap.put("FI", "Finlan");
    namesMap.put("FK", "Kapuloan Falkland");
    namesMap.put("FM", "Féderasi Mikronésia");
    namesMap.put("FO", "Kapuloan Faro");
    namesMap.put("FR", "Prancis");
    namesMap.put("GB", "Karajan Manunggal");
    namesMap.put("GD", "Grénada");
    namesMap.put("GE", "Géorgia");
    namesMap.put("GF", "Guyana Prancis");
    namesMap.put("GG", "Guernsei");
    namesMap.put("GL", "Grinland");
    namesMap.put("GN", "Gini");
    namesMap.put("GP", "Guadélup");
    namesMap.put("GQ", "Guinéa Katulistiwa");
    namesMap.put("GR", "Grikenlan");
    namesMap.put("GS", "Georgia Kidul lan Kapuloan Sandwich Kidul");
    namesMap.put("GT", "Guatémala");
    namesMap.put("GW", "Gini-Bisau");
    namesMap.put("HK", "Laladan Administratif Astamiwa Hong Kong");
    namesMap.put("HM", "Kapuloan Heard lan McDonald");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HU", "Honggari");
    namesMap.put("IC", "Kapuloan Kanari");
    namesMap.put("ID", "Indonésia");
    namesMap.put("IE", "Républik Irlan");
    namesMap.put("IL", "Israèl");
    namesMap.put("IM", "Pulo Man");
    namesMap.put("IN", "Indhi");
    namesMap.put("IO", "Wilayah Inggris nang Segoro Hindia");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Èslan");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yordania");
    namesMap.put("JP", "Jepang");
    namesMap.put("KE", "Kénya");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kamboja");
    namesMap.put("KM", "Komoro");
    namesMap.put("KN", "Saint Kits lan Nèvis");
    namesMap.put("KP", "Koréa Lèr");
    namesMap.put("KR", "Koréa Kidul");
    namesMap.put("KY", "Kapuloan Kéman");
    namesMap.put("KZ", "Kasakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Santa Lusia");
    namesMap.put("LI", "Liktenstén");
    namesMap.put("LR", "Libèria");
    namesMap.put("LS", "Lésotho");
    namesMap.put("LT", "Litowen");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("ME", "Montenégro");
    namesMap.put("MF", "Santa Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kapuloan Marshall");
    namesMap.put("MK", "Makédonia");
    namesMap.put("MO", "Laladan Administratif Astamiwa Makau");
    namesMap.put("MP", "Kapuloan Mariana Lor");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MS", "Monsérat");
    namesMap.put("MV", "Maladéwa");
    namesMap.put("MX", "Mèksiko");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Kalédonia Anyar");
    namesMap.put("NE", "Nigér");
    namesMap.put("NF", "Pulo Norfolk");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Walanda");
    namesMap.put("NO", "Nurwègen");
    namesMap.put("NP", "Népal");
    namesMap.put("NZ", "Niu Sélan");
    namesMap.put("PF", "Polinesia Prancis");
    namesMap.put("PG", "Papua Nugini");
    namesMap.put("PH", "Pilipina");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "Saint Pièr lan Mikuélon");
    namesMap.put("PN", "Kapuloan Pitcairn");
    namesMap.put("PR", "Puèrto Riko");
    namesMap.put("PS", "Tlatah Palèstina");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Oseania Paling Njaba");
    namesMap.put("RO", "Ruméni");
    namesMap.put("RS", "Sèrbi");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kapuloan Suleman");
    namesMap.put("SC", "Sésèl");
    namesMap.put("SE", "Swèdhen");
    namesMap.put("SG", "Singapura");
    namesMap.put("SH", "Saint Héléna");
    namesMap.put("SI", "Slovénia");
    namesMap.put("SJ", "Svalbard lan Jan Mayen");
    namesMap.put("SK", "Slowak");
    namesMap.put("SL", "Siéra Léoné");
    namesMap.put("SN", "Sénégal");
    namesMap.put("SS", "Sudan Kidul");
    namesMap.put("ST", "Sao Tomé lan Principé");
    namesMap.put("SV", "Èl Salvador");
    namesMap.put("SX", "Sint Martén");
    namesMap.put("SY", "Suriah");
    namesMap.put("SZ", "Swasiland");
    namesMap.put("TC", "Turks lan Kapuloan Kaikos");
    namesMap.put("TF", "Wilayah Prancis nang Kutub Kidul");
    namesMap.put("TH", "Tanah Thai");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Turkménistan");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad lan Tobago");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UA", "Ukrania");
    namesMap.put("UM", "Kapuloan A.S. Paling Njobo");
    namesMap.put("UN", "Pasarékatan Bangsa-Bangsa");
    namesMap.put("US", "Amérika Sarékat");
    namesMap.put("UZ", "Usbèkistan");
    namesMap.put("VA", "Kutho Vatikan");
    namesMap.put("VC", "Saint Vinsen lan Grénadin");
    namesMap.put("VE", "Vénésuéla");
    namesMap.put("VG", "Kapuloan Virgin Britania");
    namesMap.put("VI", "Kapuloan Virgin Amérika");
    namesMap.put("VN", "Viètnam");
    namesMap.put("WF", "Wallis lan Futuna");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Kidul");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Daerah Ora Dikenali");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Donya",
        "002": "Afrika",
        "003": "Amérika Lèr",
        "005": "Amérika Kidul",
        "009": "Oséania",
        "011": "Afrika Kulon",
        "013": "Amérika Tengah",
        "014": "Afrika Wétan",
        "015": "Afrika Lèr",
        "017": "Afrika Sisih Tengah",
        "018": "Afrika Sisih Kidul",
        "019": "Amérika",
        "021": "Amérika Sisih Lor",
        "029": "Karibia",
        "030": "Asia Wétan",
        "034": "Asia Kidul",
        "035": "Asia Kidul-wétan",
        "039": "Éropah Kidul",
        "057": "Daerah Mikronesia",
        "061": "Polinesia",
        "143": "Asia Tengah",
        "145": "Asia Kulon",
        "150": "Éropah",
        "151": "Éropah Wétan",
        "154": "Éropah Lèr",
        "155": "Éropah Kulon",
        "202": "Afrika Kidule Sahara",
        "419": "Amérika Latin",
        "AC": "Pulo Ascension",
        "AD": "Andora",
        "AE": "Uni Émirat Arab",
        "AF": "Afganistan",
        "AG": "Antigua lan Barbuda",
        "AL": "Albani",
        "AM": "Arménia",
        "AQ": "Antartika",
        "AR": "Argèntina",
        "AS": "Samoa Amerika",
        "AT": "Ostenrik",
        "AU": "Ostrali",
        "AX": "Kapuloan Alan",
        "BA": "Bosnia lan Hèrségovina",
        "BB": "Barbadhos",
        "BD": "Banggaladésa",
        "BE": "Bèlgi",
        "BG": "Bulgari",
        "BJ": "Bénin",
        "BL": "Saint Barthélémi",
        "BN": "Brunéi",
        "BQ": "Karibia Walanda",
        "BR": "Brasil",
        "BV": "Pulo Bovèt",
        "BY": "Bélarus",
        "BZ": "Bélisé",
        "CA": "Kanada",
        "CC": "Kapuloan Cocos (Keeling)",
        "CD": "Kongo - Kinshasa",
        "CF": "Républik Afrika Tengah",
        "CG": "Kongo - Brassaville",
        "CH": "Switserlan",
        "CI": "Pasisir Gadhing",
        "CK": "Kapuloan Cook",
        "CL": "Cilé",
        "CM": "Kamerun",
        "CN": "Tyongkok",
        "CO": "Kolombia",
        "CP": "Pulo Clipperton",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Pongol Verdé",
        "CW": "Kurasao",
        "CX": "Pulo Natal",
        "CY": "Siprus",
        "CZ": "Céko",
        "DE": "Jérman",
        "DJ": "Jibuti",
        "DK": "Dhènemarken",
        "DM": "Dominika",
        "DO": "Républik Dominika",
        "DZ": "Aljasair",
        "EA": "Séuta lan Melila",
        "EC": "Ékuadhor",
        "EE": "Éstonia",
        "EG": "Mesir",
        "EH": "Sahara Kulon",
        "ER": "Éritréa",
        "ES": "Sepanyol",
        "ET": "Étiopia",
        "EU": "Uni Éropah",
        "EZ": "Zona Éuro",
        "FI": "Finlan",
        "FK": "Kapuloan Falkland",
        "FM": "Féderasi Mikronésia",
        "FO": "Kapuloan Faro",
        "FR": "Prancis",
        "GB": "Karajan Manunggal",
        "GD": "Grénada",
        "GE": "Géorgia",
        "GF": "Guyana Prancis",
        "GG": "Guernsei",
        "GL": "Grinland",
        "GN": "Gini",
        "GP": "Guadélup",
        "GQ": "Guinéa Katulistiwa",
        "GR": "Grikenlan",
        "GS": "Georgia Kidul lan Kapuloan Sandwich Kidul",
        "GT": "Guatémala",
        "GW": "Gini-Bisau",
        "HK": "Laladan Administratif Astamiwa Hong Kong",
        "HM": "Kapuloan Heard lan McDonald",
        "HR": "Kroasia",
        "HU": "Honggari",
        "IC": "Kapuloan Kanari",
        "ID": "Indonésia",
        "IE": "Républik Irlan",
        "IL": "Israèl",
        "IM": "Pulo Man",
        "IN": "Indhi",
        "IO": "Wilayah Inggris nang Segoro Hindia",
        "IQ": "Irak",
        "IS": "Èslan",
        "IT": "Itali",
        "JM": "Jamaika",
        "JO": "Yordania",
        "JP": "Jepang",
        "KE": "Kénya",
        "KG": "Kirgistan",
        "KH": "Kamboja",
        "KM": "Komoro",
        "KN": "Saint Kits lan Nèvis",
        "KP": "Koréa Lèr",
        "KR": "Koréa Kidul",
        "KY": "Kapuloan Kéman",
        "KZ": "Kasakstan",
        "LB": "Libanon",
        "LC": "Santa Lusia",
        "LI": "Liktenstén",
        "LR": "Libèria",
        "LS": "Lésotho",
        "LT": "Litowen",
        "LU": "Luksemburg",
        "MA": "Maroko",
        "MC": "Monako",
        "ME": "Montenégro",
        "MF": "Santa Martin",
        "MG": "Madagaskar",
        "MH": "Kapuloan Marshall",
        "MK": "Makédonia",
        "MO": "Laladan Administratif Astamiwa Makau",
        "MP": "Kapuloan Mariana Lor",
        "MQ": "Martinik",
        "MS": "Monsérat",
        "MV": "Maladéwa",
        "MX": "Mèksiko",
        "MZ": "Mosambik",
        "NC": "Kalédonia Anyar",
        "NE": "Nigér",
        "NF": "Pulo Norfolk",
        "NG": "Nigéria",
        "NI": "Nikaragua",
        "NL": "Walanda",
        "NO": "Nurwègen",
        "NP": "Népal",
        "NZ": "Niu Sélan",
        "PF": "Polinesia Prancis",
        "PG": "Papua Nugini",
        "PH": "Pilipina",
        "PL": "Polen",
        "PM": "Saint Pièr lan Mikuélon",
        "PN": "Kapuloan Pitcairn",
        "PR": "Puèrto Riko",
        "PS": "Tlatah Palèstina",
        "QA": "Katar",
        "QO": "Oseania Paling Njaba",
        "RO": "Ruméni",
        "RS": "Sèrbi",
        "RU": "Rusia",
        "SA": "Arab Saudi",
        "SB": "Kapuloan Suleman",
        "SC": "Sésèl",
        "SE": "Swèdhen",
        "SG": "Singapura",
        "SH": "Saint Héléna",
        "SI": "Slovénia",
        "SJ": "Svalbard lan Jan Mayen",
        "SK": "Slowak",
        "SL": "Siéra Léoné",
        "SN": "Sénégal",
        "SS": "Sudan Kidul",
        "ST": "Sao Tomé lan Principé",
        "SV": "Èl Salvador",
        "SX": "Sint Martén",
        "SY": "Suriah",
        "SZ": "Swasiland",
        "TC": "Turks lan Kapuloan Kaikos",
        "TF": "Wilayah Prancis nang Kutub Kidul",
        "TH": "Tanah Thai",
        "TL": "Timor Leste",
        "TM": "Turkménistan",
        "TR": "Turki",
        "TT": "Trinidad lan Tobago",
        "TZ": "Tansania",
        "UA": "Ukrania",
        "UM": "Kapuloan A.S. Paling Njobo",
        "UN": "Pasarékatan Bangsa-Bangsa",
        "US": "Amérika Sarékat",
        "UZ": "Usbèkistan",
        "VA": "Kutho Vatikan",
        "VC": "Saint Vinsen lan Grénadin",
        "VE": "Vénésuéla",
        "VG": "Kapuloan Virgin Britania",
        "VI": "Kapuloan Virgin Amérika",
        "VN": "Viètnam",
        "WF": "Wallis lan Futuna",
        "YE": "Yaman",
        "ZA": "Afrika Kidul",
        "ZM": "Sambia",
        "ZW": "Simbabwe",
        "ZZ": "Daerah Ora Dikenali"
    };
  }-*/;
}
