/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "hy" locale.
 */
public class LocalizedNamesImpl_hy extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "VI",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AU",
        "AT",
        "AE",
        "AR",
        "AW",
        "QO",
        "UM",
        "EH",
        "AF",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BW",
        "BO",
        "BA",
        "BT",
        "BG",
        "BV",
        "BF",
        "BI",
        "BR",
        "VG",
        "IO",
        "BN",
        "GA",
        "GM",
        "GY",
        "GH",
        "DE",
        "GG",
        "GU",
        "GP",
        "GT",
        "GN",
        "GW",
        "GD",
        "GL",
        "DK",
        "DG",
        "DM",
        "DO",
        "EG",
        "ET",
        "YE",
        "EZ",
        "EU",
        "ZM",
        "ZW",
        "EC",
        "EE",
        "ER",
        "TH",
        "TW",
        "TC",
        "TL",
        "TN",
        "TR",
        "TM",
        "ID",
        "IE",
        "IS",
        "ES",
        "IL",
        "IT",
        "IR",
        "IQ",
        "LA",
        "LV",
        "PL",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "HR",
        "CV",
        "KH",
        "CM",
        "KY",
        "CA",
        "IC",
        "QA",
        "BQ",
        "CF",
        "CY",
        "KI",
        "CW",
        "CO",
        "CC",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "CK",
        "AC",
        "AM",
        "HT",
        "GQ",
        "KR",
        "GS",
        "SS",
        "ZA",
        "HM",
        "KP",
        "MP",
        "IN",
        "HN",
        "HK",
        "JO",
        "GR",
        "HU",
        "KZ",
        "KG",
        "JM",
        "JP",
        "MG",
        "MY",
        "MW",
        "MV",
        "MT",
        "ML",
        "MK",
        "YT",
        "MU",
        "MR",
        "MH",
        "MA",
        "MQ",
        "IM",
        "MX",
        "UN",
        "GB",
        "US",
        "FM",
        "MM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NC",
        "NO",
        "NF",
        "SE",
        "CH",
        "LK",
        "UG",
        "UZ",
        "UA",
        "WF",
        "UY",
        "TD",
        "CZ",
        "ME",
        "CL",
        "CN",
        "MO",
        "PW",
        "PK",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PT",
        "PR",
        "JE",
        "DJ",
        "GI",
        "RE",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SC",
        "MF",
        "PM",
        "SN",
        "LC",
        "VC",
        "KN",
        "EA",
        "RS",
        "SL",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "BL",
        "CX",
        "SH",
        "SR",
        "SZ",
        "SJ",
        "VU",
        "VA",
        "VE",
        "VN",
        "GE",
        "TZ",
        "TJ",
        "TG",
        "TK",
        "TO",
        "TV",
        "TT",
        "TA",
        "KE",
        "CP",
        "KW",
        "OM",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FK",
        "FR",
        "GF",
        "TF",
        "PF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Աշխարհ");
    namesMap.put("002", "Աֆրիկա");
    namesMap.put("003", "Հյուսիսային Ամերիկա");
    namesMap.put("005", "Հարավային Ամերիկա");
    namesMap.put("009", "Օվկիանիա");
    namesMap.put("011", "Արևմտյան Աֆրիկա");
    namesMap.put("013", "Կենտրոնական Ամերիկա");
    namesMap.put("014", "Արևելյան Աֆրիկա");
    namesMap.put("015", "Հյուսիսային Աֆրիկա");
    namesMap.put("017", "Կենտրոնական Աֆրիկա");
    namesMap.put("018", "Հարավային Աֆրիկա");
    namesMap.put("019", "Ամերիկա");
    namesMap.put("021", "Հյուսիսային Ամերիկա - ԱՄՆ և Կանադա");
    namesMap.put("029", "Կարիբներ");
    namesMap.put("030", "Արևելյան Ասիա");
    namesMap.put("034", "Հարավային Ասիա");
    namesMap.put("035", "Հարավարևելյան Ասիա");
    namesMap.put("039", "Հարավային Եվրոպա");
    namesMap.put("053", "Ավստրալասիա");
    namesMap.put("054", "Մելանեզիա");
    namesMap.put("057", "Միկրոնեզյան տարածաշրջան");
    namesMap.put("061", "Պոլինեզիա");
    namesMap.put("142", "Ասիա");
    namesMap.put("143", "Կենտրոնական Ասիա");
    namesMap.put("145", "Արևմտյան Ասիա");
    namesMap.put("150", "Եվրոպա");
    namesMap.put("151", "Արևելյան Եվրոպա");
    namesMap.put("154", "Հյուսիսային Եվրոպա");
    namesMap.put("155", "Արևմտյան Եվրոպա");
    namesMap.put("202", "Արևադարձային Աֆրիկա");
    namesMap.put("419", "Լատինական Ամերիկա");
    namesMap.put("AC", "Համբարձման կղզի");
    namesMap.put("AD", "Անդորրա");
    namesMap.put("AE", "Արաբական Միացյալ Էմիրություններ");
    namesMap.put("AF", "Աֆղանստան");
    namesMap.put("AG", "Անտիգուա և Բարբուդա");
    namesMap.put("AI", "Անգուիլա");
    namesMap.put("AL", "Ալբանիա");
    namesMap.put("AM", "Հայաստան");
    namesMap.put("AO", "Անգոլա");
    namesMap.put("AQ", "Անտարկտիդա");
    namesMap.put("AR", "Արգենտինա");
    namesMap.put("AS", "Ամերիկյան Սամոա");
    namesMap.put("AT", "Ավստրիա");
    namesMap.put("AU", "Ավստրալիա");
    namesMap.put("AW", "Արուբա");
    namesMap.put("AX", "Ալանդյան կղզիներ");
    namesMap.put("AZ", "Ադրբեջան");
    namesMap.put("BA", "Բոսնիա և Հերցեգովինա");
    namesMap.put("BB", "Բարբադոս");
    namesMap.put("BD", "Բանգլադեշ");
    namesMap.put("BE", "Բելգիա");
    namesMap.put("BF", "Բուրկինա Ֆասո");
    namesMap.put("BG", "Բուլղարիա");
    namesMap.put("BH", "Բահրեյն");
    namesMap.put("BI", "Բուրունդի");
    namesMap.put("BJ", "Բենին");
    namesMap.put("BL", "Սուրբ Բարդուղիմեոս");
    namesMap.put("BM", "Բերմուդներ");
    namesMap.put("BN", "Բրունեյ");
    namesMap.put("BO", "Բոլիվիա");
    namesMap.put("BQ", "Կարիբյան Նիդեռլանդներ");
    namesMap.put("BR", "Բրազիլիա");
    namesMap.put("BS", "Բահամյան կղզիներ");
    namesMap.put("BT", "Բութան");
    namesMap.put("BV", "Բուվե կղզի");
    namesMap.put("BW", "Բոթսվանա");
    namesMap.put("BY", "Բելառուս");
    namesMap.put("BZ", "Բելիզ");
    namesMap.put("CA", "Կանադա");
    namesMap.put("CC", "Կոկոսյան (Քիլինգ) կղզիներ");
    namesMap.put("CD", "Կոնգո - Կինշասա");
    namesMap.put("CF", "Կենտրոնական Աֆրիկյան Հանրապետություն");
    namesMap.put("CG", "Կոնգո - Բրազավիլ");
    namesMap.put("CH", "Շվեյցարիա");
    namesMap.put("CI", "Կոտ դ’Իվուար");
    namesMap.put("CK", "Կուկի կղզիներ");
    namesMap.put("CL", "Չիլի");
    namesMap.put("CM", "Կամերուն");
    namesMap.put("CN", "Չինաստան");
    namesMap.put("CO", "Կոլումբիա");
    namesMap.put("CP", "Քլիփերթոն կղզի");
    namesMap.put("CR", "Կոստա Ռիկա");
    namesMap.put("CU", "Կուբա");
    namesMap.put("CV", "Կաբո Վերդե");
    namesMap.put("CW", "Կյուրասաո");
    namesMap.put("CX", "Սուրբ Ծննդյան կղզի");
    namesMap.put("CY", "Կիպրոս");
    namesMap.put("CZ", "Չեխիա");
    namesMap.put("DE", "Գերմանիա");
    namesMap.put("DG", "Դիեգո Գարսիա");
    namesMap.put("DJ", "Ջիբութի");
    namesMap.put("DK", "Դանիա");
    namesMap.put("DM", "Դոմինիկա");
    namesMap.put("DO", "Դոմինիկյան Հանրապետություն");
    namesMap.put("DZ", "Ալժիր");
    namesMap.put("EA", "Սեուտա և Մելիլյա");
    namesMap.put("EC", "Էկվադոր");
    namesMap.put("EE", "Էստոնիա");
    namesMap.put("EG", "Եգիպտոս");
    namesMap.put("EH", "Արևմտյան Սահարա");
    namesMap.put("ER", "Էրիթրեա");
    namesMap.put("ES", "Իսպանիա");
    namesMap.put("ET", "Եթովպիա");
    namesMap.put("EU", "Եվրոպական Միություն");
    namesMap.put("EZ", "Եվրագոտի");
    namesMap.put("FI", "Ֆինլանդիա");
    namesMap.put("FJ", "Ֆիջի");
    namesMap.put("FK", "Ֆոլքլենդյան կղզիներ");
    namesMap.put("FM", "Միկրոնեզիա");
    namesMap.put("FO", "Ֆարերյան կղզիներ");
    namesMap.put("FR", "Ֆրանսիա");
    namesMap.put("GA", "Գաբոն");
    namesMap.put("GB", "Միացյալ Թագավորություն");
    namesMap.put("GD", "Գրենադա");
    namesMap.put("GE", "Վրաստան");
    namesMap.put("GF", "Ֆրանսիական Գվիանա");
    namesMap.put("GG", "Գերնսի");
    namesMap.put("GH", "Գանա");
    namesMap.put("GI", "Ջիբրալթար");
    namesMap.put("GL", "Գրենլանդիա");
    namesMap.put("GM", "Գամբիա");
    namesMap.put("GN", "Գվինեա");
    namesMap.put("GP", "Գվադելուպա");
    namesMap.put("GQ", "Հասարակածային Գվինեա");
    namesMap.put("GR", "Հունաստան");
    namesMap.put("GS", "Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ");
    namesMap.put("GT", "Գվատեմալա");
    namesMap.put("GU", "Գուամ");
    namesMap.put("GW", "Գվինեա-Բիսաու");
    namesMap.put("GY", "Գայանա");
    namesMap.put("HK", "Հոնկոնգի ՀՎՇ");
    namesMap.put("HM", "Հերդ կղզի և ՄակԴոնալդի կղզիներ");
    namesMap.put("HN", "Հոնդուրաս");
    namesMap.put("HR", "Խորվաթիա");
    namesMap.put("HT", "Հայիթի");
    namesMap.put("HU", "Հունգարիա");
    namesMap.put("IC", "Կանարյան կղզիներ");
    namesMap.put("ID", "Ինդոնեզիա");
    namesMap.put("IE", "Իռլանդիա");
    namesMap.put("IL", "Իսրայել");
    namesMap.put("IM", "Մեն կղզի");
    namesMap.put("IN", "Հնդկաստան");
    namesMap.put("IO", "Բրիտանական Տարածք Հնդկական Օվկիանոսում");
    namesMap.put("IQ", "Իրաք");
    namesMap.put("IR", "Իրան");
    namesMap.put("IS", "Իսլանդիա");
    namesMap.put("IT", "Իտալիա");
    namesMap.put("JE", "Ջերսի");
    namesMap.put("JM", "Ճամայկա");
    namesMap.put("JO", "Հորդանան");
    namesMap.put("JP", "Ճապոնիա");
    namesMap.put("KE", "Քենիա");
    namesMap.put("KG", "Ղրղզստան");
    namesMap.put("KH", "Կամբոջա");
    namesMap.put("KI", "Կիրիբատի");
    namesMap.put("KM", "Կոմորյան կղզիներ");
    namesMap.put("KN", "Սենթ Քիտս և Նևիս");
    namesMap.put("KP", "Հյուսիսային Կորեա");
    namesMap.put("KR", "Հարավային Կորեա");
    namesMap.put("KW", "Քուվեյթ");
    namesMap.put("KY", "Կայմանյան կղզիներ");
    namesMap.put("KZ", "Ղազախստան");
    namesMap.put("LA", "Լաոս");
    namesMap.put("LB", "Լիբանան");
    namesMap.put("LC", "Սենթ Լյուսիա");
    namesMap.put("LI", "Լիխտենշտեյն");
    namesMap.put("LK", "Շրի Լանկա");
    namesMap.put("LR", "Լիբերիա");
    namesMap.put("LS", "Լեսոտո");
    namesMap.put("LT", "Լիտվա");
    namesMap.put("LU", "Լյուքսեմբուրգ");
    namesMap.put("LV", "Լատվիա");
    namesMap.put("LY", "Լիբիա");
    namesMap.put("MA", "Մարոկկո");
    namesMap.put("MC", "Մոնակո");
    namesMap.put("MD", "Մոլդովա");
    namesMap.put("ME", "Չեռնոգորիա");
    namesMap.put("MF", "Սեն Մարտեն");
    namesMap.put("MG", "Մադագասկար");
    namesMap.put("MH", "Մարշալյան կղզիներ");
    namesMap.put("MK", "Մակեդոնիա");
    namesMap.put("ML", "Մալի");
    namesMap.put("MM", "Մյանմա (Բիրմա)");
    namesMap.put("MN", "Մոնղոլիա");
    namesMap.put("MO", "Չինաստանի Մակաո ՀՎՇ");
    namesMap.put("MP", "Հյուսիսային Մարիանյան կղզիներ");
    namesMap.put("MQ", "Մարտինիկա");
    namesMap.put("MR", "Մավրիտանիա");
    namesMap.put("MS", "Մոնսեռատ");
    namesMap.put("MT", "Մալթա");
    namesMap.put("MU", "Մավրիկիոս");
    namesMap.put("MV", "Մալդիվներ");
    namesMap.put("MW", "Մալավի");
    namesMap.put("MX", "Մեքսիկա");
    namesMap.put("MY", "Մալայզիա");
    namesMap.put("MZ", "Մոզամբիկ");
    namesMap.put("NA", "Նամիբիա");
    namesMap.put("NC", "Նոր Կալեդոնիա");
    namesMap.put("NE", "Նիգեր");
    namesMap.put("NF", "Նորֆոլկ կղզի");
    namesMap.put("NG", "Նիգերիա");
    namesMap.put("NI", "Նիկարագուա");
    namesMap.put("NL", "Նիդեռլանդներ");
    namesMap.put("NO", "Նորվեգիա");
    namesMap.put("NP", "Նեպալ");
    namesMap.put("NR", "Նաուրու");
    namesMap.put("NU", "Նիուե");
    namesMap.put("NZ", "Նոր Զելանդիա");
    namesMap.put("OM", "Օման");
    namesMap.put("PA", "Պանամա");
    namesMap.put("PE", "Պերու");
    namesMap.put("PF", "Ֆրանսիական Պոլինեզիա");
    namesMap.put("PG", "Պապուա Նոր Գվինեա");
    namesMap.put("PH", "Ֆիլիպիններ");
    namesMap.put("PK", "Պակիստան");
    namesMap.put("PL", "Լեհաստան");
    namesMap.put("PM", "Սեն Պիեռ և Միքելոն");
    namesMap.put("PN", "Պիտկեռն կղզիներ");
    namesMap.put("PR", "Պուերտո Ռիկո");
    namesMap.put("PS", "Պաղեստինյան տարածքներ");
    namesMap.put("PT", "Պորտուգալիա");
    namesMap.put("PW", "Պալաու");
    namesMap.put("PY", "Պարագվայ");
    namesMap.put("QA", "Կատար");
    namesMap.put("QO", "Արտաքին Օվկիանիա");
    namesMap.put("RE", "Ռեյունիոն");
    namesMap.put("RO", "Ռումինիա");
    namesMap.put("RS", "Սերբիա");
    namesMap.put("RU", "Ռուսաստան");
    namesMap.put("RW", "Ռուանդա");
    namesMap.put("SA", "Սաուդյան Արաբիա");
    namesMap.put("SB", "Սողոմոնյան կղզիներ");
    namesMap.put("SC", "Սեյշելներ");
    namesMap.put("SD", "Սուդան");
    namesMap.put("SE", "Շվեդիա");
    namesMap.put("SG", "Սինգապուր");
    namesMap.put("SH", "Սուրբ Հեղինեի կղզի");
    namesMap.put("SI", "Սլովենիա");
    namesMap.put("SJ", "Սվալբարդ և Յան Մայեն");
    namesMap.put("SK", "Սլովակիա");
    namesMap.put("SL", "Սիեռա Լեոնե");
    namesMap.put("SM", "Սան Մարինո");
    namesMap.put("SN", "Սենեգալ");
    namesMap.put("SO", "Սոմալի");
    namesMap.put("SR", "Սուրինամ");
    namesMap.put("SS", "Հարավային Սուդան");
    namesMap.put("ST", "Սան Տոմե և Փրինսիպի");
    namesMap.put("SV", "Սալվադոր");
    namesMap.put("SX", "Սինտ Մարտեն");
    namesMap.put("SY", "Սիրիա");
    namesMap.put("SZ", "Սվազիլենդ");
    namesMap.put("TA", "Տրիստան դա Կունյա");
    namesMap.put("TC", "Թըրքս և Կայկոս կղզիներ");
    namesMap.put("TD", "Չադ");
    namesMap.put("TF", "Ֆրանսիական Հարավային Տարածքներ");
    namesMap.put("TG", "Տոգո");
    namesMap.put("TH", "Թայլանդ");
    namesMap.put("TJ", "Տաջիկստան");
    namesMap.put("TK", "Տոկելաու");
    namesMap.put("TL", "Թիմոր Լեշտի");
    namesMap.put("TM", "Թուրքմենստան");
    namesMap.put("TN", "Թունիս");
    namesMap.put("TO", "Տոնգա");
    namesMap.put("TR", "Թուրքիա");
    namesMap.put("TT", "Տրինիդադ և Տոբագո");
    namesMap.put("TV", "Տուվալու");
    namesMap.put("TW", "Թայվան");
    namesMap.put("TZ", "Տանզանիա");
    namesMap.put("UA", "Ուկրաինա");
    namesMap.put("UG", "Ուգանդա");
    namesMap.put("UM", "Արտաքին կղզիներ (ԱՄՆ)");
    namesMap.put("UN", "Միավորված ազգերի կազմակերպություն");
    namesMap.put("US", "Միացյալ Նահանգներ");
    namesMap.put("UY", "Ուրուգվայ");
    namesMap.put("UZ", "Ուզբեկստան");
    namesMap.put("VA", "Վատիկան");
    namesMap.put("VC", "Սենթ Վինսենթ և Գրենադիններ");
    namesMap.put("VE", "Վենեսուելա");
    namesMap.put("VG", "Բրիտանական Վիրջինյան կղզիներ");
    namesMap.put("VI", "ԱՄՆ Վիրջինյան կղզիներ");
    namesMap.put("VN", "Վիետնամ");
    namesMap.put("VU", "Վանուատու");
    namesMap.put("WF", "Ուոլիս և Ֆուտունա");
    namesMap.put("WS", "Սամոա");
    namesMap.put("XK", "Կոսովո");
    namesMap.put("YE", "Եմեն");
    namesMap.put("YT", "Մայոտ");
    namesMap.put("ZA", "Հարավաֆրիկյան Հանրապետություն");
    namesMap.put("ZM", "Զամբիա");
    namesMap.put("ZW", "Զիմբաբվե");
    namesMap.put("ZZ", "Անհայտ տարածաշրջան");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Աշխարհ",
        "002": "Աֆրիկա",
        "003": "Հյուսիսային Ամերիկա",
        "005": "Հարավային Ամերիկա",
        "009": "Օվկիանիա",
        "011": "Արևմտյան Աֆրիկա",
        "013": "Կենտրոնական Ամերիկա",
        "014": "Արևելյան Աֆրիկա",
        "015": "Հյուսիսային Աֆրիկա",
        "017": "Կենտրոնական Աֆրիկա",
        "018": "Հարավային Աֆրիկա",
        "019": "Ամերիկա",
        "021": "Հյուսիսային Ամերիկա - ԱՄՆ և Կանադա",
        "029": "Կարիբներ",
        "030": "Արևելյան Ասիա",
        "034": "Հարավային Ասիա",
        "035": "Հարավարևելյան Ասիա",
        "039": "Հարավային Եվրոպա",
        "053": "Ավստրալասիա",
        "054": "Մելանեզիա",
        "057": "Միկրոնեզյան տարածաշրջան",
        "061": "Պոլինեզիա",
        "142": "Ասիա",
        "143": "Կենտրոնական Ասիա",
        "145": "Արևմտյան Ասիա",
        "150": "Եվրոպա",
        "151": "Արևելյան Եվրոպա",
        "154": "Հյուսիսային Եվրոպա",
        "155": "Արևմտյան Եվրոպա",
        "202": "Արևադարձային Աֆրիկա",
        "419": "Լատինական Ամերիկա",
        "AC": "Համբարձման կղզի",
        "AD": "Անդորրա",
        "AE": "Արաբական Միացյալ Էմիրություններ",
        "AF": "Աֆղանստան",
        "AG": "Անտիգուա և Բարբուդա",
        "AI": "Անգուիլա",
        "AL": "Ալբանիա",
        "AM": "Հայաստան",
        "AO": "Անգոլա",
        "AQ": "Անտարկտիդա",
        "AR": "Արգենտինա",
        "AS": "Ամերիկյան Սամոա",
        "AT": "Ավստրիա",
        "AU": "Ավստրալիա",
        "AW": "Արուբա",
        "AX": "Ալանդյան կղզիներ",
        "AZ": "Ադրբեջան",
        "BA": "Բոսնիա և Հերցեգովինա",
        "BB": "Բարբադոս",
        "BD": "Բանգլադեշ",
        "BE": "Բելգիա",
        "BF": "Բուրկինա Ֆասո",
        "BG": "Բուլղարիա",
        "BH": "Բահրեյն",
        "BI": "Բուրունդի",
        "BJ": "Բենին",
        "BL": "Սուրբ Բարդուղիմեոս",
        "BM": "Բերմուդներ",
        "BN": "Բրունեյ",
        "BO": "Բոլիվիա",
        "BQ": "Կարիբյան Նիդեռլանդներ",
        "BR": "Բրազիլիա",
        "BS": "Բահամյան կղզիներ",
        "BT": "Բութան",
        "BV": "Բուվե կղզի",
        "BW": "Բոթսվանա",
        "BY": "Բելառուս",
        "BZ": "Բելիզ",
        "CA": "Կանադա",
        "CC": "Կոկոսյան (Քիլինգ) կղզիներ",
        "CD": "Կոնգո - Կինշասա",
        "CF": "Կենտրոնական Աֆրիկյան Հանրապետություն",
        "CG": "Կոնգո - Բրազավիլ",
        "CH": "Շվեյցարիա",
        "CI": "Կոտ դ’Իվուար",
        "CK": "Կուկի կղզիներ",
        "CL": "Չիլի",
        "CM": "Կամերուն",
        "CN": "Չինաստան",
        "CO": "Կոլումբիա",
        "CP": "Քլիփերթոն կղզի",
        "CR": "Կոստա Ռիկա",
        "CU": "Կուբա",
        "CV": "Կաբո Վերդե",
        "CW": "Կյուրասաո",
        "CX": "Սուրբ Ծննդյան կղզի",
        "CY": "Կիպրոս",
        "CZ": "Չեխիա",
        "DE": "Գերմանիա",
        "DG": "Դիեգո Գարսիա",
        "DJ": "Ջիբութի",
        "DK": "Դանիա",
        "DM": "Դոմինիկա",
        "DO": "Դոմինիկյան Հանրապետություն",
        "DZ": "Ալժիր",
        "EA": "Սեուտա և Մելիլյա",
        "EC": "Էկվադոր",
        "EE": "Էստոնիա",
        "EG": "Եգիպտոս",
        "EH": "Արևմտյան Սահարա",
        "ER": "Էրիթրեա",
        "ES": "Իսպանիա",
        "ET": "Եթովպիա",
        "EU": "Եվրոպական Միություն",
        "EZ": "Եվրագոտի",
        "FI": "Ֆինլանդիա",
        "FJ": "Ֆիջի",
        "FK": "Ֆոլքլենդյան կղզիներ",
        "FM": "Միկրոնեզիա",
        "FO": "Ֆարերյան կղզիներ",
        "FR": "Ֆրանսիա",
        "GA": "Գաբոն",
        "GB": "Միացյալ Թագավորություն",
        "GD": "Գրենադա",
        "GE": "Վրաստան",
        "GF": "Ֆրանսիական Գվիանա",
        "GG": "Գերնսի",
        "GH": "Գանա",
        "GI": "Ջիբրալթար",
        "GL": "Գրենլանդիա",
        "GM": "Գամբիա",
        "GN": "Գվինեա",
        "GP": "Գվադելուպա",
        "GQ": "Հասարակածային Գվինեա",
        "GR": "Հունաստան",
        "GS": "Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ",
        "GT": "Գվատեմալա",
        "GU": "Գուամ",
        "GW": "Գվինեա-Բիսաու",
        "GY": "Գայանա",
        "HK": "Հոնկոնգի ՀՎՇ",
        "HM": "Հերդ կղզի և ՄակԴոնալդի կղզիներ",
        "HN": "Հոնդուրաս",
        "HR": "Խորվաթիա",
        "HT": "Հայիթի",
        "HU": "Հունգարիա",
        "IC": "Կանարյան կղզիներ",
        "ID": "Ինդոնեզիա",
        "IE": "Իռլանդիա",
        "IL": "Իսրայել",
        "IM": "Մեն կղզի",
        "IN": "Հնդկաստան",
        "IO": "Բրիտանական Տարածք Հնդկական Օվկիանոսում",
        "IQ": "Իրաք",
        "IR": "Իրան",
        "IS": "Իսլանդիա",
        "IT": "Իտալիա",
        "JE": "Ջերսի",
        "JM": "Ճամայկա",
        "JO": "Հորդանան",
        "JP": "Ճապոնիա",
        "KE": "Քենիա",
        "KG": "Ղրղզստան",
        "KH": "Կամբոջա",
        "KI": "Կիրիբատի",
        "KM": "Կոմորյան կղզիներ",
        "KN": "Սենթ Քիտս և Նևիս",
        "KP": "Հյուսիսային Կորեա",
        "KR": "Հարավային Կորեա",
        "KW": "Քուվեյթ",
        "KY": "Կայմանյան կղզիներ",
        "KZ": "Ղազախստան",
        "LA": "Լաոս",
        "LB": "Լիբանան",
        "LC": "Սենթ Լյուսիա",
        "LI": "Լիխտենշտեյն",
        "LK": "Շրի Լանկա",
        "LR": "Լիբերիա",
        "LS": "Լեսոտո",
        "LT": "Լիտվա",
        "LU": "Լյուքսեմբուրգ",
        "LV": "Լատվիա",
        "LY": "Լիբիա",
        "MA": "Մարոկկո",
        "MC": "Մոնակո",
        "MD": "Մոլդովա",
        "ME": "Չեռնոգորիա",
        "MF": "Սեն Մարտեն",
        "MG": "Մադագասկար",
        "MH": "Մարշալյան կղզիներ",
        "MK": "Մակեդոնիա",
        "ML": "Մալի",
        "MM": "Մյանմա (Բիրմա)",
        "MN": "Մոնղոլիա",
        "MO": "Չինաստանի Մակաո ՀՎՇ",
        "MP": "Հյուսիսային Մարիանյան կղզիներ",
        "MQ": "Մարտինիկա",
        "MR": "Մավրիտանիա",
        "MS": "Մոնսեռատ",
        "MT": "Մալթա",
        "MU": "Մավրիկիոս",
        "MV": "Մալդիվներ",
        "MW": "Մալավի",
        "MX": "Մեքսիկա",
        "MY": "Մալայզիա",
        "MZ": "Մոզամբիկ",
        "NA": "Նամիբիա",
        "NC": "Նոր Կալեդոնիա",
        "NE": "Նիգեր",
        "NF": "Նորֆոլկ կղզի",
        "NG": "Նիգերիա",
        "NI": "Նիկարագուա",
        "NL": "Նիդեռլանդներ",
        "NO": "Նորվեգիա",
        "NP": "Նեպալ",
        "NR": "Նաուրու",
        "NU": "Նիուե",
        "NZ": "Նոր Զելանդիա",
        "OM": "Օման",
        "PA": "Պանամա",
        "PE": "Պերու",
        "PF": "Ֆրանսիական Պոլինեզիա",
        "PG": "Պապուա Նոր Գվինեա",
        "PH": "Ֆիլիպիններ",
        "PK": "Պակիստան",
        "PL": "Լեհաստան",
        "PM": "Սեն Պիեռ և Միքելոն",
        "PN": "Պիտկեռն կղզիներ",
        "PR": "Պուերտո Ռիկո",
        "PS": "Պաղեստինյան տարածքներ",
        "PT": "Պորտուգալիա",
        "PW": "Պալաու",
        "PY": "Պարագվայ",
        "QA": "Կատար",
        "QO": "Արտաքին Օվկիանիա",
        "RE": "Ռեյունիոն",
        "RO": "Ռումինիա",
        "RS": "Սերբիա",
        "RU": "Ռուսաստան",
        "RW": "Ռուանդա",
        "SA": "Սաուդյան Արաբիա",
        "SB": "Սողոմոնյան կղզիներ",
        "SC": "Սեյշելներ",
        "SD": "Սուդան",
        "SE": "Շվեդիա",
        "SG": "Սինգապուր",
        "SH": "Սուրբ Հեղինեի կղզի",
        "SI": "Սլովենիա",
        "SJ": "Սվալբարդ և Յան Մայեն",
        "SK": "Սլովակիա",
        "SL": "Սիեռա Լեոնե",
        "SM": "Սան Մարինո",
        "SN": "Սենեգալ",
        "SO": "Սոմալի",
        "SR": "Սուրինամ",
        "SS": "Հարավային Սուդան",
        "ST": "Սան Տոմե և Փրինսիպի",
        "SV": "Սալվադոր",
        "SX": "Սինտ Մարտեն",
        "SY": "Սիրիա",
        "SZ": "Սվազիլենդ",
        "TA": "Տրիստան դա Կունյա",
        "TC": "Թըրքս և Կայկոս կղզիներ",
        "TD": "Չադ",
        "TF": "Ֆրանսիական Հարավային Տարածքներ",
        "TG": "Տոգո",
        "TH": "Թայլանդ",
        "TJ": "Տաջիկստան",
        "TK": "Տոկելաու",
        "TL": "Թիմոր Լեշտի",
        "TM": "Թուրքմենստան",
        "TN": "Թունիս",
        "TO": "Տոնգա",
        "TR": "Թուրքիա",
        "TT": "Տրինիդադ և Տոբագո",
        "TV": "Տուվալու",
        "TW": "Թայվան",
        "TZ": "Տանզանիա",
        "UA": "Ուկրաինա",
        "UG": "Ուգանդա",
        "UM": "Արտաքին կղզիներ (ԱՄՆ)",
        "UN": "Միավորված ազգերի կազմակերպություն",
        "US": "Միացյալ Նահանգներ",
        "UY": "Ուրուգվայ",
        "UZ": "Ուզբեկստան",
        "VA": "Վատիկան",
        "VC": "Սենթ Վինսենթ և Գրենադիններ",
        "VE": "Վենեսուելա",
        "VG": "Բրիտանական Վիրջինյան կղզիներ",
        "VI": "ԱՄՆ Վիրջինյան կղզիներ",
        "VN": "Վիետնամ",
        "VU": "Վանուատու",
        "WF": "Ուոլիս և Ֆուտունա",
        "WS": "Սամոա",
        "XK": "Կոսովո",
        "YE": "Եմեն",
        "YT": "Մայոտ",
        "ZA": "Հարավաֆրիկյան Հանրապետություն",
        "ZM": "Զամբիա",
        "ZW": "Զիմբաբվե",
        "ZZ": "Անհայտ տարածաշրջան"
    };
  }-*/;
}
