/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "be" locale.
 */
public class DateTimeFormatInfoImpl_be extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM y 'г'.";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y 'г'.";
  }

  @Override
  public String dateFormatMedium() {
    return "d.MM.y";
  }

  @Override
  public String dateFormatShort() {
    return "d.MM.yy";
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " 'у' " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " 'у' " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "да нараджэння Хрыстова",
        "ад нараджэння Хрыстова"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "да н.э.",
        "н.э."
    };
  }

  @Override
  public String formatMinuteSecond() {
    return "mm.ss";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d.M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "LLL y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "LLLL y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y 'г'.";
  }

  @Override
  public String formatYearMonthNum() {
    return "M.y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d.M.y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "студзеня",
        "лютага",
        "сакавіка",
        "красавіка",
        "мая",
        "чэрвеня",
        "ліпеня",
        "жніўня",
        "верасня",
        "кастрычніка",
        "лістапада",
        "снежня"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "студзень",
        "люты",
        "сакавік",
        "красавік",
        "май",
        "чэрвень",
        "ліпень",
        "жнівень",
        "верасень",
        "кастрычнік",
        "лістапад",
        "снежань"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "с",
        "л",
        "с",
        "к",
        "м",
        "ч",
        "л",
        "ж",
        "в",
        "к",
        "л",
        "с"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "сту",
        "лют",
        "сак",
        "кра",
        "мая",
        "чэр",
        "ліп",
        "жні",
        "вер",
        "кас",
        "ліс",
        "сне"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "сту",
        "лют",
        "сак",
        "кра",
        "май",
        "чэр",
        "ліп",
        "жні",
        "вер",
        "кас",
        "ліс",
        "сне"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1-шы квартал",
        "2-гі квартал",
        "3-ці квартал",
        "4-ты квартал"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1-шы кв.",
        "2-гі кв.",
        "3-ці кв.",
        "4-ты кв."
    };
  }

  @Override
  public String timeFormatFull() {
    return "HH:mm:ss, zzzz";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "нядзеля",
        "панядзелак",
        "аўторак",
        "серада",
        "чацвер",
        "пятніца",
        "субота"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "н",
        "п",
        "а",
        "с",
        "ч",
        "п",
        "с"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "нд",
        "пн",
        "аў",
        "ср",
        "чц",
        "пт",
        "сб"
    };
  }
}
