/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPrivateKey
implements ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    private String algorithm = "EC";
    private BigInteger d;
    private Object ecSpec;
    private boolean withCompression;
    private Hashtable pkcs12Attributes = new Hashtable();
    private Vector pkcs12Ordering = new Vector();

    protected JCEECPrivateKey() {
    }

    JCEECPrivateKey(ECPrivateKey eCPrivateKey) {
        this.d = eCPrivateKey.getD();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParameters();
    }

    JCEECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getD();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    JCEECPrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    JCEECPrivateKey(PrivateKeyInfo privateKeyInfo) {
        ASN1Encodable aSN1Encodable;
        X962Parameters x962Parameters = new X962Parameters((DERObject)privateKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
            X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid((DERObjectIdentifier)aSN1Encodable);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((DERObjectIdentifier)aSN1Encodable), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
        }
        if (privateKeyInfo.getPrivateKey() instanceof DERInteger) {
            aSN1Encodable = (DERInteger)privateKeyInfo.getPrivateKey();
            this.d = ((DERInteger)aSN1Encodable).getValue();
        } else {
            aSN1Encodable = new ECPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            this.d = ((ECPrivateKeyStructure)aSN1Encodable).getKey();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            object = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            x962Parameters = new X962Parameters((DERObjectIdentifier)object);
        } else {
            ECPoint eCPoint;
            object = (ECParameterSpec)this.ecSpec;
            ECCurve eCCurve = ((ECParameterSpec)object).getG().getCurve();
            if (eCCurve instanceof ECCurve.Fp) {
                eCPoint = new ECPoint.Fp(eCCurve, ((ECParameterSpec)object).getG().getX(), ((ECParameterSpec)object).getG().getY(), this.withCompression);
            } else if (eCCurve instanceof ECCurve.F2m) {
                eCPoint = new ECPoint.F2m(eCCurve, ((ECParameterSpec)object).getG().getX(), ((ECParameterSpec)object).getG().getY(), this.withCompression);
            } else {
                throw new UnsupportedOperationException("Subclass of ECPoint " + eCCurve.getClass().toString() + "not supported");
            }
            X9ECParameters x9ECParameters = new X9ECParameters(((ECParameterSpec)object).getCurve(), eCPoint, ((ECParameterSpec)object).getN(), ((ECParameterSpec)object).getH(), ((ECParameterSpec)object).getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        object = this.algorithm.equals("ECGOST3410") ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, x962Parameters.getDERObject()), new ECPrivateKeyStructure(this.getD()).getDERObject()) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), new ECPrivateKeyStructure(this.getD()).getDERObject());
        try {
            dEROutputStream.writeObject(object);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC private key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ECParameterSpec getParams() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return (ECParameterSpec)this.ecSpec;
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setBagAttribute(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.pkcs12Attributes.put(dERObjectIdentifier, dEREncodable);
        this.pkcs12Ordering.addElement(dERObjectIdentifier);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier dERObjectIdentifier) {
        return (DEREncodable)this.pkcs12Attributes.get(dERObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.pkcs12Ordering.elements();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }
}

