/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["940"],{29487:function(e){e.exports="---\ntitle: Presto\n---\n\n# Presto\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\nFill out the fields for that database, and click **Save changes** at the bottom.\n\n## Edit connection details\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., esc.mydatabase.com).\n\n### Port\n\nThe database port. E.g., 8080.\n\n### Catalog\n\nPresto catalogs contain schemas and reference data sources via a connector.\n\n### Schema (optional)\n\nOnly add tables to Metabase that come from a specific schema.\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use a secure connection (SSL)\n\nMetabase automatically tries to connect to databases with SSL first, then without if that doesn't work. If it's possible to connect to your database with an SSL connection, Metabase will make that the default setting for your database. If you prefer to connect without this layer of security, you can always change this setting later, but we recommend keeping SSL turned on to keep your data secure.\n\n### Use SSL certificate?\n\nMetabase supports both keystores and truststores.\n\n#### Keystore\n\nYou can specify a local file path, or upload a keystore. You'll also need to input your keystore password.\n\n#### Truststore\n\nYou can specify a local file path, or upload a truststore. You'll also need to input your truststore password.\n\n### Authenticate with Kerberos\n\nKerberos settings include:\n\n- Kerberos principal (e.g., `service/instance@REALM`)\n- Kerberos coordinator service (e.g., `presto`)\n- You can use a canonical hostname.\n- Kerberos credential cache file (e.g., `/tmp/kerbo-credential-cache`)\n- Kerberos keytab file (e.g., `/path/to/kerberos.keytab`)\n- Kerberos configuration file (e.g., `/etc/krb5.conf`)\n- Presto coordinator Kerberos service principal pattern (e.g., `${SERVICE}@${HOST}.${SERVICE}`\n\n### Additional JDBC connection string options\n\nYou can append options to the connection string that Metabase uses to connect to your database.\n\n### Re-run queries for simple explorations\n\nTurn this option **OFF** if people want to click **Run** (the play button) before applying any [Summarize](../../questions/query-builder/summarizing-and-grouping.md) or filter selections.\n\nBy default, Metabase will execute a query as soon as you choose an grouping option from the **Summarize** menu or a filter condition from the [drill-through menu](https://www.metabase.com/learn/metabase-basics/querying-and-dashboards/questions/drill-through). If your database is slow, you may want to disable re-running to avoid loading data on each click.\n\n### Choose when syncs and scans happen\n\nSee [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n\n### Periodically refingerprint tables\n\n> Periodic refingerprinting will increase the load on your database.\n\nTurn this option **ON** to scan a sample of values every time Metabase runs a [sync](../sync-scan.md#how-database-syncs-work).\n\nA fingerprinting query examines the first 10,000 rows from each column and uses that data to guesstimate how many unique values each column has, what the minimum and maximum values are for numeric and timestamp columns, and so on. If you leave this option **OFF**, Metabase will only fingerprint your columns once during setup.\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database (data catalog), and the question will run its query against a different data catalog with the same schema depending on who is viewing the question.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);