/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.Token;

public class DocumentEnd
extends TokenRule {
    public static final String OPTION_PRESENT = "present";

    public DocumentEnd() {
        this.registerOption(OPTION_PRESENT, true);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (((Boolean)conf.get(OPTION_PRESENT)).booleanValue()) {
            if (token instanceof StreamEndToken && !(prev instanceof DocumentEndToken) && !(prev instanceof StreamStartToken)) {
                problems.add(new LintProblem(token.getStartMark().getLine(), 1, "missing document end \"...\""));
            } else if (token instanceof DocumentStartToken && !(prev instanceof DocumentEndToken) && !(prev instanceof StreamStartToken) && !(prev instanceof DirectiveToken)) {
                problems.add(new LintProblem(token.getStartMark().getLine() + 1, 1, "missing document end \"...\""));
            }
        } else if (token instanceof DocumentEndToken) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, "found forbidden document end \"...\""));
        }
        return problems;
    }
}

