/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api;

import java.util.Locale;

public enum JReleaserCommand {
    CONFIG(true),
    DOWNLOAD(false),
    ASSEMBLE(false),
    CHANGELOG(true),
    CHECKSUM(false),
    CATALOG(false),
    SIGN(false),
    DEPLOY(false),
    UPLOAD(false),
    RELEASE(true),
    PREPARE(false),
    PACKAGE(false),
    PUBLISH(false),
    ANNOUNCE(true),
    FULL_RELEASE(true);

    private final boolean git;

    private JReleaserCommand(boolean git) {
        this.git = git;
    }

    public boolean requiresGit() {
        return this.git;
    }

    public String toStep() {
        return this.name().toLowerCase(Locale.ENGLISH).replace("_", "-");
    }

    public static boolean supportsAssemble(JReleaserCommand command) {
        return ASSEMBLE == command;
    }

    public static boolean supportsChangelog(JReleaserCommand command) {
        return CHANGELOG == command || RELEASE == command || ANNOUNCE == command || FULL_RELEASE == command;
    }

    public static boolean supportsChecksum(JReleaserCommand command) {
        return CHECKSUM == command || CATALOG == command || SIGN == command || UPLOAD == command || RELEASE == command || PREPARE == command || PACKAGE == command || PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsSign(JReleaserCommand command) {
        return SIGN == command || UPLOAD == command || RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsDeploy(JReleaserCommand command) {
        return DEPLOY == command || RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsUpload(JReleaserCommand command) {
        return UPLOAD == command || RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsRelease(JReleaserCommand command) {
        return RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsPrepare(JReleaserCommand command) {
        return PREPARE == command || PACKAGE == command || PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsPackage(JReleaserCommand command) {
        return PACKAGE == command || PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsPublish(JReleaserCommand command) {
        return PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsAnnounce(JReleaserCommand command) {
        return ANNOUNCE == command || FULL_RELEASE == command;
    }
}

