/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.packagers.Packagers;
import org.jreleaser.model.internal.packagers.RepositoryPackager;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.model.internal.packagers.SdkmanPackager;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class PackagersValidator {
    private PackagersValidator() {
    }

    public static void validatePackagers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            return;
        }
        context.getLogger().debug("packagers");
        JReleaserModel model = context.getModel();
        Packagers packagers = model.getPackagers();
        Project project = model.getProject();
        BaseReleaser<?, ?> gitService = model.getRelease().getReleaser();
        PackagersValidator.validatePackager(context, packagers.getAppImage(), packagers.getAppImage().getRepository());
        if (packagers.getAppImage().getScreenshots().isEmpty()) {
            packagers.getAppImage().setScreenshots(project.getScreenshots());
        }
        if (packagers.getAppImage().getIcons().isEmpty()) {
            packagers.getAppImage().setIcons(project.getIcons());
        }
        if (StringUtils.isBlank((String)packagers.getAppImage().getDeveloperId())) {
            packagers.getAppImage().setDeveloperId(gitService.getOwner());
        }
        if (StringUtils.isBlank((String)packagers.getAppImage().getDeveloperName())) {
            packagers.getAppImage().setDeveloperName(String.join((CharSequence)", ", project.getAuthors()));
        }
        PackagersValidator.validatePackager(context, packagers.getAsdf(), packagers.getAsdf().getRepository());
        PackagersValidator.validatePackager(context, packagers.getBrew(), packagers.getBrew().getRepository());
        PackagersValidator.validatePackager(context, packagers.getChocolatey(), packagers.getChocolatey().getRepository());
        PackagersValidator.validatePackager(context, packagers.getDocker(), packagers.getDocker().getPackagerRepository());
        if (!packagers.getDocker().getSpecs().isEmpty()) {
            errors.configuration(RB.$((String)"validation_packagers_docker_specs", (Object[])new Object[0]));
        }
        PackagersValidator.validatePackager(context, packagers.getFlatpak(), packagers.getFlatpak().getRepository());
        if (packagers.getFlatpak().getScreenshots().isEmpty()) {
            packagers.getFlatpak().setScreenshots(project.getScreenshots());
        }
        if (packagers.getFlatpak().getIcons().isEmpty()) {
            packagers.getFlatpak().setIcons(project.getIcons());
        }
        if (StringUtils.isBlank((String)packagers.getFlatpak().getDeveloperName())) {
            packagers.getFlatpak().setDeveloperName(String.join((CharSequence)", ", project.getAuthors()));
        }
        PackagersValidator.validatePackager(context, packagers.getGofish(), packagers.getGofish().getRepository());
        if (StringUtils.isBlank((String)packagers.getGofish().getRepository().getName())) {
            packagers.getGofish().getRepository().setName(gitService.getOwner() + "-fish-food");
        }
        packagers.getGofish().getRepository().setTapName(gitService.getOwner() + "-fish-food");
        PackagersValidator.validatePackager(context, packagers.getJbang(), packagers.getJbang().getRepository());
        PackagersValidator.validatePackager(context, packagers.getJib(), packagers.getJib().getPackagerRepository());
        if (!packagers.getJib().getSpecs().isEmpty()) {
            errors.configuration(RB.$((String)"validation_packagers_jib_specs", (Object[])new Object[0]));
        }
        PackagersValidator.validatePackager(context, packagers.getMacports(), packagers.getMacports().getRepository());
        if (packagers.getMacports().getMaintainers().isEmpty()) {
            packagers.getMacports().getMaintainers().addAll(project.getMaintainers());
        }
        PackagersValidator.validatePackager(context, packagers.getScoop(), packagers.getScoop().getRepository());
        if (StringUtils.isBlank((String)packagers.getScoop().getRepository().getName())) {
            packagers.getScoop().getRepository().setName("scoop-" + gitService.getOwner());
        }
        packagers.getScoop().getRepository().setTapName("scoop-" + gitService.getOwner());
        PackagersValidator.validatePackager(context, packagers.getSnap(), packagers.getSnap().getRepository());
        PackagersValidator.validatePackager(context, packagers.getSpec(), packagers.getSpec().getRepository());
        if (StringUtils.isBlank((String)packagers.getSpec().getRepository().getName())) {
            packagers.getSpec().getRepository().setName(gitService.getOwner() + "-spec");
        }
        packagers.getSpec().getRepository().setTapName(gitService.getOwner() + "-spec");
        PackagersValidator.validateSdkman(context, packagers.getSdkman());
        PackagersValidator.validatePackager(context, packagers.getWinget(), packagers.getWinget().getRepository());
    }

    private static void validateSdkman(JReleaserContext context, SdkmanPackager packager) {
        packager.resolveEnabled(context.getModel().getProject());
        Validator.validateTimeout(packager);
    }

    private static void validatePackager(JReleaserContext context, TemplatePackager<?> packager) {
        Validator.resolveActivatable(context, packager, "packagers." + packager.getType(), "NEVER");
        packager.resolveEnabled(context.getModel().getProject());
    }

    private static void validatePackager(JReleaserContext context, RepositoryPackager<?> packager, RepositoryTap tap) {
        PackagersValidator.validatePackager(context, packager);
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        Validator.validateCommitAuthor(packager, service);
        Validator.validateOwner(tap, service);
        packager.getRepositoryTap().resolveEnabled(context.getModel().getProject());
        tap.setUsername(Validator.checkProperty(context, tap.getBasename() + "." + service.getServiceName() + ".username", "<empty>", tap.getUsername(), service.getUsername()));
        tap.setToken(Validator.checkProperty(context, tap.getBasename() + "." + service.getServiceName() + ".token", "<empty>", tap.getToken(), service.getToken()));
        if (StringUtils.isBlank((String)tap.getTagName())) {
            tap.setTagName(service.getTagName());
        }
        if (StringUtils.isBlank((String)tap.getBranch())) {
            tap.setBranch("HEAD");
        }
        if (StringUtils.isBlank((String)tap.getBranchPush())) {
            tap.setBranchPush(tap.getBranch());
        }
    }
}

