/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.model.internal.hooks.JbangHook;
import org.jreleaser.model.internal.hooks.JbangHookProvider;

public final class NamedJbangHooks
extends AbstractActivatable<NamedJbangHooks>
implements Domain,
JbangHookProvider,
MatrixAware {
    private static final long serialVersionUID = 8884768091233057014L;
    private final List<JbangHook> before = new ArrayList<JbangHook>();
    private final List<JbangHook> success = new ArrayList<JbangHook>();
    private final List<JbangHook> failure = new ArrayList<JbangHook>();
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Matrix matrix = new Matrix();
    private String version;
    private String script;
    private String name;
    private String condition;
    private Boolean applyDefaultMatrix;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.NamedJbangHooks immutable = new org.jreleaser.model.api.hooks.NamedJbangHooks(){
        private static final long serialVersionUID = 6613588209546503679L;
        private List<? extends org.jreleaser.model.api.hooks.JbangHook> before;
        private List<? extends org.jreleaser.model.api.hooks.JbangHook> success;
        private List<? extends org.jreleaser.model.api.hooks.JbangHook> failure;

        public String getVersion() {
            return NamedJbangHooks.this.getVersion();
        }

        public String getScript() {
            return NamedJbangHooks.this.getScript();
        }

        public String getName() {
            return NamedJbangHooks.this.getName();
        }

        public String getCondition() {
            return NamedJbangHooks.this.getCondition();
        }

        public List<? extends org.jreleaser.model.api.hooks.JbangHook> getBefore() {
            if (null == this.before) {
                this.before = NamedJbangHooks.this.before.stream().map(JbangHook::asImmutable).collect(Collectors.toList());
            }
            return this.before;
        }

        public List<? extends org.jreleaser.model.api.hooks.JbangHook> getSuccess() {
            if (null == this.success) {
                this.success = NamedJbangHooks.this.success.stream().map(JbangHook::asImmutable).collect(Collectors.toList());
            }
            return this.success;
        }

        public List<? extends org.jreleaser.model.api.hooks.JbangHook> getFailure() {
            if (null == this.failure) {
                this.failure = NamedJbangHooks.this.failure.stream().map(JbangHook::asImmutable).collect(Collectors.toList());
            }
            return this.failure;
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(NamedJbangHooks.this.getEnvironment());
        }

        public boolean isApplyDefaultMatrix() {
            return NamedJbangHooks.this.isApplyDefaultMatrix();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return NamedJbangHooks.this.matrix.asImmutable();
        }

        public Active getActive() {
            return NamedJbangHooks.this.getActive();
        }

        public boolean isEnabled() {
            return NamedJbangHooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(NamedJbangHooks.this.asMap(full));
        }
    };

    public NamedJbangHooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.NamedJbangHooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(NamedJbangHooks source) {
        super.merge(source);
        this.version = this.merge(this.version, source.version);
        this.script = this.merge(this.script, source.script);
        this.name = this.merge(this.name, source.name);
        this.condition = this.merge(this.condition, source.condition);
        this.setBefore(this.merge(this.before, source.before));
        this.setSuccess(this.merge(this.success, source.success));
        this.setFailure(this.merge(this.failure, source.failure));
        this.setEnvironment(this.merge(this.environment, source.getEnvironment()));
        this.setMatrix(source.matrix);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || !this.before.isEmpty() || !this.success.isEmpty() || !this.failure.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public List<JbangHook> getBefore() {
        return this.before;
    }

    public void setBefore(List<JbangHook> before) {
        this.before.clear();
        this.before.addAll(before);
    }

    @Override
    public List<JbangHook> getSuccess() {
        return this.success;
    }

    public void setSuccess(List<JbangHook> success) {
        this.success.clear();
        this.success.addAll(success);
    }

    @Override
    public List<JbangHook> getFailure() {
        return this.failure;
    }

    public void setFailure(List<JbangHook> failure) {
        this.failure.clear();
        this.failure.addAll(failure);
    }

    public void addBefore(JbangHook hook) {
        if (null != hook) {
            this.before.add(hook);
        }
    }

    public void addSuccess(JbangHook hook) {
        if (null != hook) {
            this.success.add(hook);
        }
    }

    public void addFailure(JbangHook hook) {
        if (null != hook) {
            this.failure.add(hook);
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    @Override
    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    @Override
    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    @Override
    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("name", this.name);
        map.put("condition", this.condition);
        map.put("environment", this.environment);
        map.put("version", this.version);
        map.put("script", this.script);
        this.matrix.asMap(map);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (JbangHook hook : this.getBefore()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("before", m);
        m = new LinkedHashMap();
        i = 0;
        for (JbangHook hook : this.getSuccess()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("success", m);
        m = new LinkedHashMap();
        i = 0;
        for (JbangHook hook : this.getFailure()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("failure", m);
        return map;
    }
}

