/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.Matrix;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.api.hooks.Hook;
import org.jreleaser.model.api.hooks.ScriptHook;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.hooks.AbstractHook;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class ScriptHook
extends AbstractHook<ScriptHook> {
    private static final long serialVersionUID = -3434334171967497493L;
    private String run;
    private ScriptHook.Shell shell = ScriptHook.Shell.BASH;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.ScriptHook immutable = new org.jreleaser.model.api.hooks.ScriptHook(){
        private static final long serialVersionUID = -338908878151893273L;

        public String getRun() {
            return ScriptHook.this.run;
        }

        public ScriptHook.Shell getShell() {
            return ScriptHook.this.shell;
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(ScriptHook.this.getEnvironment());
        }

        public boolean isApplyDefaultMatrix() {
            return ScriptHook.this.isApplyDefaultMatrix();
        }

        public Matrix getMatrix() {
            return ScriptHook.this.matrix.asImmutable();
        }

        public Set<String> getPlatforms() {
            return Collections.unmodifiableSet(ScriptHook.this.getPlatforms());
        }

        public Hook.Filter getFilter() {
            return ScriptHook.this.getFilter().asImmutable();
        }

        public boolean isContinueOnError() {
            return ScriptHook.this.isContinueOnError();
        }

        public boolean isVerbose() {
            return ScriptHook.this.isVerbose();
        }

        public String getCondition() {
            return ScriptHook.this.getCondition();
        }

        public Active getActive() {
            return ScriptHook.this.getActive();
        }

        public boolean isEnabled() {
            return ScriptHook.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ScriptHook.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.hooks.ScriptHook asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ScriptHook source) {
        super.merge(source);
        this.run = this.merge(this.run, source.run);
        this.shell = this.merge(this.shell, source.shell);
    }

    public String getResolvedRun(JReleaserContext context, TemplateContext additionalContext, ExecutionEvent event) {
        TemplateContext props = context.fullProps().setAll(additionalContext);
        props.set("event", (Object)event);
        props.set("jreleaser", (Object)context.getModel().asImmutable());
        return Templates.resolveTemplate((String)this.run, (TemplateContext)props);
    }

    public String getRun() {
        return this.run;
    }

    public void setRun(String run) {
        this.run = run;
    }

    public ScriptHook.Shell getShell() {
        return this.shell;
    }

    public void setShell(ScriptHook.Shell shell) {
        this.shell = shell;
    }

    public void setShell(String shell) {
        this.setShell(ScriptHook.Shell.of((String)shell));
    }

    @Override
    public void asMap(boolean full, Map<String, Object> map) {
        map.put("shell", this.shell);
        map.put("run", this.run);
    }
}

