/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.DebAssembler;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class DebAssembler
extends AbstractAssembler<DebAssembler, org.jreleaser.model.api.assemble.DebAssembler> {
    private static final long serialVersionUID = 8479646443910628265L;
    private final Control control = new Control();
    private final Distribution.DistributionType distributionType = Distribution.DistributionType.NATIVE_PACKAGE;
    private String executable;
    private String installationPath;
    private String architecture;
    private String assemblerRef;
    @JsonIgnore
    private final org.jreleaser.model.api.assemble.DebAssembler immutable = new org.jreleaser.model.api.assemble.DebAssembler(){
        private static final long serialVersionUID = -3178284422300452517L;
        private Set<? extends Artifact> artifacts;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private List<? extends Glob> files;
        private Set<? extends Artifact> outputs;

        public String getExecutable() {
            return DebAssembler.this.executable;
        }

        public String getInstallationPath() {
            return DebAssembler.this.installationPath;
        }

        public String getArchitecture() {
            return DebAssembler.this.architecture;
        }

        public String getAssemblerRef() {
            return DebAssembler.this.assemblerRef;
        }

        public DebAssembler.Control getControl() {
            return DebAssembler.this.control.asImmutable();
        }

        public Platform getPlatform() {
            return DebAssembler.this.getPlatform().asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return DebAssembler.this.getDistributionType();
        }

        public String getType() {
            return DebAssembler.this.getType();
        }

        public Stereotype getStereotype() {
            return DebAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return DebAssembler.this.isExported();
        }

        public String getName() {
            return DebAssembler.this.getName();
        }

        public String getTemplateDirectory() {
            return DebAssembler.this.getTemplateDirectory();
        }

        public Set<String> getSkipTemplates() {
            return Collections.unmodifiableSet(DebAssembler.this.getSkipTemplates());
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = DebAssembler.this.getArtifacts().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = DebAssembler.this.getFileSets().stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public List<? extends Glob> getFiles() {
            if (null == this.files) {
                this.files = DebAssembler.this.getFiles().stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = DebAssembler.this.getOutputs().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return DebAssembler.this.getActive();
        }

        public boolean isEnabled() {
            return DebAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(DebAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return DebAssembler.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(DebAssembler.this.getExtraProperties());
        }
    };

    public DebAssembler() {
        super("deb");
    }

    @Override
    public org.jreleaser.model.api.assemble.DebAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(DebAssembler source) {
        super.merge(source);
        this.executable = this.merge(this.executable, source.executable);
        this.installationPath = this.merge(this.installationPath, source.installationPath);
        this.architecture = this.merge(this.architecture, source.architecture);
        this.assemblerRef = this.merge(this.assemblerRef, source.assemblerRef);
        this.setControl(source.control);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return this.distributionType;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    public void setInstallationPath(String installationPath) {
        this.installationPath = installationPath;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getAssemblerRef() {
        return this.assemblerRef;
    }

    public void setAssemblerRef(String assemblerRef) {
        this.assemblerRef = assemblerRef;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control.merge(control);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("installationPath", this.installationPath);
        props.put("architecture", this.architecture);
        props.put("assemblerRef", this.assemblerRef);
        props.put("executable", this.executable);
        props.put("control", this.control.asMap(full));
    }

    public String getResolvedInstallationPath(TemplateContext props) {
        TemplateContext newProps = new TemplateContext(props);
        newProps.set("packageName", (Object)this.control.getPackageName());
        newProps.set("packageVersion", (Object)this.control.getPackageVersion());
        newProps.set("packageRevision", (Object)this.control.getPackageRevision());
        return Templates.resolveTemplate((String)this.installationPath, (TemplateContext)newProps);
    }

    public static final class Control
    extends AbstractModelObject<Control>
    implements Domain {
        private static final long serialVersionUID = -8048356548178456591L;
        private final Set<String> depends = new LinkedHashSet<String>();
        private final Set<String> preDepends = new LinkedHashSet<String>();
        private final Set<String> recommends = new LinkedHashSet<String>();
        private final Set<String> suggests = new LinkedHashSet<String>();
        private final Set<String> enhances = new LinkedHashSet<String>();
        private final Set<String> breaks = new LinkedHashSet<String>();
        private final Set<String> conflicts = new LinkedHashSet<String>();
        private String packageName;
        private String packageVersion;
        private Integer packageRevision;
        private String maintainer;
        private String provides;
        private DebAssembler.Section section;
        private DebAssembler.Priority priority;
        private Boolean essential;
        private String description;
        private String homepage;
        private String builtUsing;
        @JsonIgnore
        private final DebAssembler.Control immutable = new DebAssembler.Control(){
            private static final long serialVersionUID = -2200047957145966911L;

            public String getPackageName() {
                return packageName;
            }

            public String getPackageVersion() {
                return packageVersion;
            }

            public Integer getPackageRevision() {
                return packageRevision;
            }

            public String getMaintainer() {
                return maintainer;
            }

            public String getProvides() {
                return provides;
            }

            public DebAssembler.Section getSection() {
                return section;
            }

            public DebAssembler.Priority getPriority() {
                return priority;
            }

            public boolean isEssential() {
                return this.isEssential();
            }

            public String getDescription() {
                return description;
            }

            public String getHomepage() {
                return homepage;
            }

            public String getBuiltUsing() {
                return builtUsing;
            }

            public Set<String> getDepends() {
                return Collections.unmodifiableSet(depends);
            }

            public Set<String> getPreDepends() {
                return Collections.unmodifiableSet(preDepends);
            }

            public Set<String> getRecommends() {
                return Collections.unmodifiableSet(recommends);
            }

            public Set<String> getSuggests() {
                return Collections.unmodifiableSet(suggests);
            }

            public Set<String> getEnhances() {
                return Collections.unmodifiableSet(enhances);
            }

            public Set<String> getBreaks() {
                return Collections.unmodifiableSet(breaks);
            }

            public Set<String> getConflicts() {
                return Collections.unmodifiableSet(conflicts);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public DebAssembler.Control asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Control source) {
            this.packageName = this.merge(this.packageName, source.packageName);
            this.packageVersion = this.merge(this.packageVersion, source.packageVersion);
            this.packageRevision = this.merge(this.packageRevision, source.packageRevision);
            this.maintainer = this.merge(this.maintainer, source.maintainer);
            this.provides = this.merge(this.provides, source.provides);
            this.section = this.merge(this.section, source.section);
            this.priority = this.merge(this.priority, source.priority);
            this.essential = this.merge(this.essential, source.essential);
            this.description = this.merge(this.description, source.description);
            this.homepage = this.merge(this.homepage, source.homepage);
            this.builtUsing = this.merge(this.builtUsing, source.builtUsing);
            this.setDepends(this.merge(this.depends, source.depends));
            this.setPreDepends(this.merge(this.preDepends, source.preDepends));
            this.setRecommends(this.merge(this.recommends, source.recommends));
            this.setSuggests(this.merge(this.suggests, source.suggests));
            this.setEnhances(this.merge(this.enhances, source.enhances));
            this.setBreaks(this.merge(this.breaks, source.breaks));
            this.setConflicts(this.merge(this.conflicts, source.conflicts));
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public Integer getPackageRevision() {
            return null != this.packageRevision ? this.packageRevision : 1;
        }

        public void setPackageRevision(Integer packageRevision) {
            this.packageRevision = packageRevision;
        }

        public String getMaintainer() {
            return this.maintainer;
        }

        public void setMaintainer(String maintainer) {
            this.maintainer = maintainer;
        }

        public String getProvides() {
            return this.provides;
        }

        public void setProvides(String provides) {
            this.provides = provides;
        }

        public DebAssembler.Section getSection() {
            return this.section;
        }

        public void setSection(DebAssembler.Section section) {
            this.section = section;
        }

        public void setSection(String section) {
            this.setSection(DebAssembler.Section.of((String)section));
        }

        public DebAssembler.Priority getPriority() {
            return this.priority;
        }

        public void setPriority(DebAssembler.Priority priority) {
            this.priority = priority;
        }

        public void setPriority(String priority) {
            this.setPriority(DebAssembler.Priority.of((String)priority));
        }

        public Boolean isEssential() {
            return null != this.essential && this.essential != false;
        }

        public Boolean isEssentialSet() {
            return null != this.essential;
        }

        public void setEssential(Boolean essential) {
            this.essential = essential;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getHomepage() {
            return this.homepage;
        }

        public void setHomepage(String homepage) {
            this.homepage = homepage;
        }

        public String getBuiltUsing() {
            return this.builtUsing;
        }

        public void setBuiltUsing(String builtUsing) {
            this.builtUsing = builtUsing;
        }

        public Set<String> getDepends() {
            return this.depends;
        }

        public void setDepends(Set<String> depends) {
            this.depends.clear();
            this.depends.addAll(depends);
        }

        public Set<String> getPreDepends() {
            return this.preDepends;
        }

        public void setPreDepends(Set<String> preDepends) {
            this.preDepends.clear();
            this.preDepends.addAll(preDepends);
        }

        public Set<String> getRecommends() {
            return this.recommends;
        }

        public void setRecommends(Set<String> recommends) {
            this.recommends.clear();
            this.recommends.addAll(recommends);
        }

        public Set<String> getSuggests() {
            return this.suggests;
        }

        public void setSuggests(Set<String> suggests) {
            this.suggests.clear();
            this.suggests.addAll(suggests);
        }

        public Set<String> getEnhances() {
            return this.enhances;
        }

        public void setEnhances(Set<String> enhances) {
            this.enhances.clear();
            this.enhances.addAll(enhances);
        }

        public Set<String> getBreaks() {
            return this.breaks;
        }

        public void setBreaks(Set<String> breaks) {
            this.breaks.clear();
            this.breaks.addAll(breaks);
        }

        public Set<String> getConflicts() {
            return this.conflicts;
        }

        public void setConflicts(Set<String> conflicts) {
            this.conflicts.clear();
            this.conflicts.addAll(conflicts);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("packageName", this.packageName);
            map.put("packageVersion", this.packageVersion);
            map.put("packageRevision", this.getPackageRevision());
            map.put("provides", this.provides);
            map.put("maintainer", this.maintainer);
            map.put("section", this.section);
            map.put("priority", this.priority);
            map.put("essential", this.isEssential());
            map.put("description", this.description);
            map.put("homepage", this.homepage);
            map.put("builtUsing", this.builtUsing);
            map.put("depends", this.depends);
            map.put("preDepends", this.preDepends);
            map.put("recommends", this.recommends);
            map.put("suggests", this.suggests);
            map.put("enhances", this.enhances);
            map.put("breaks", this.breaks);
            map.put("conflicts", this.conflicts);
            return map;
        }
    }
}

