/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.StringUtils;

public class PackageValidateJarProcessor
implements JarProcessor<Set<String>> {
    private static final String VERSIONED = "META-INF/versions/";
    private static final Set<String> RESERVED_KEYWORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "_");
    private final JarFileResolver jarFileResolver;

    public PackageValidateJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Set<String>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Set<String>>> set = new TreeSet<JarProcessor.JarFileResult<Set<String>>>();
        PackageTracker packageTracker = new PackageTracker();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            try {
                JarFile jarFile2 = jarFile;
                try {
                    jarFile.stream().map(ZipEntry::getName).filter(entryName -> entryName.endsWith(".class")).map(this::asPackage).distinct().filter(StringUtils::isNotBlank).filter(this::isInvalid).forEach(thePackage -> packageTracker.add(jarFile, (String)thePackage));
                }
                finally {
                    if (jarFile2 == null) continue;
                    jarFile2.close();
                }
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_OPENING_JAR", jarFile.getName()));
            }
        }
        for (Map.Entry entry : packageTracker.packages.entrySet()) {
            Set splitPackages = (Set)entry.getValue();
            if (splitPackages.isEmpty()) continue;
            set.add(JarProcessor.JarFileResult.of((JarFile)entry.getKey(), new TreeSet(splitPackages)));
        }
        return set;
    }

    private String asPackage(String name) {
        int i;
        if (name.startsWith(VERSIONED)) {
            name = name.substring(VERSIONED.length());
            int p = name.indexOf("/");
            name = name.substring(p + 1);
        }
        return (i = name.lastIndexOf(47)) != -1 ? name.substring(0, i).replace('/', '.') : "";
    }

    private boolean isInvalid(String thePackage) {
        for (String part : thePackage.split("\\.")) {
            if (this.isJavaIdentifier(part)) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaIdentifier(String str) {
        int cp;
        if (StringUtils.isBlank(str) || RESERVED_KEYWORDS.contains(str)) {
            return false;
        }
        int first = Character.codePointAt(str, 0);
        if (!Character.isJavaIdentifierStart(first)) {
            return false;
        }
        for (int i = Character.charCount(first); i < str.length(); i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    private static class PackageTracker {
        private final Map<JarFile, Set<String>> packages = new LinkedHashMap<JarFile, Set<String>>();

        private PackageTracker() {
        }

        private void add(JarFile jarFile, String thePackage) {
            if (StringUtils.isNotBlank(thePackage)) {
                this.packages.computeIfAbsent(jarFile, k -> new TreeSet()).add(thePackage);
            }
        }
    }
}

