/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildIdentifiedProgressDetails;
import org.gradle.initialization.LoadBuildBuildOperationType;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.jspecify.annotations.Nullable;

public class BuildOperationFiringSettingsPreparer
implements SettingsPreparer {
    private static final LoadBuildBuildOperationType.Result RESULT = new LoadBuildBuildOperationType.Result(){};
    private final SettingsPreparer delegate;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationProgressEventEmitter emitter;
    private final @Nullable PublicBuildPath fromBuild;

    public BuildOperationFiringSettingsPreparer(SettingsPreparer delegate, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter emitter, @Nullable PublicBuildPath fromBuild) {
        this.delegate = delegate;
        this.buildOperationRunner = buildOperationRunner;
        this.emitter = emitter;
        this.fromBuild = fromBuild;
    }

    @Override
    public void prepareSettings(final GradleInternal gradle) {
        this.emitter.emitNowForCurrent((Object)new BuildIdentifiedProgressDetails(){

            public String getBuildPath() {
                return gradle.getIdentityPath().toString();
            }
        });
        this.buildOperationRunner.run((RunnableBuildOperation)new LoadBuild(gradle));
    }

    private class LoadBuild
    implements RunnableBuildOperation {
        private final GradleInternal gradle;

        public LoadBuild(GradleInternal gradle) {
            this.gradle = gradle;
        }

        public void run(BuildOperationContext context) {
            this.doLoadBuild();
            context.setResult((Object)RESULT);
        }

        void doLoadBuild() {
            BuildOperationFiringSettingsPreparer.this.delegate.prepareSettings(this.gradle);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Load build")).details((Object)new LoadBuildBuildOperationType.Details(){

                public String getBuildPath() {
                    return LoadBuild.this.gradle.getIdentityPath().toString();
                }

                public String getIncludedBy() {
                    return BuildOperationFiringSettingsPreparer.this.fromBuild == null ? null : BuildOperationFiringSettingsPreparer.this.fromBuild.getBuildPath().toString();
                }
            });
        }
    }
}

