/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.InteractiveEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.OperationIdentifier;
import org.jspecify.annotations.Nullable;

public abstract class PromptOutputEvent
extends RenderableOutputEvent
implements InteractiveEvent {
    public PromptOutputEvent(long timestamp) {
        super(timestamp, "prompt", LogLevel.QUIET, null);
    }

    @Override
    public void render(StyledTextOutput output) {
        output.println();
        output.text((Object)this.getPrompt());
    }

    public abstract PromptResult<?> convert(String var1);

    public abstract String getPrompt();

    public String toString() {
        return "[" + this.getLogLevel() + "] [" + this.getCategory() + "] '" + this.getPrompt() + "'";
    }

    @Override
    public RenderableOutputEvent withBuildOperationId(OperationIdentifier buildOperationId) {
        throw new UnsupportedOperationException();
    }

    public static class PromptResult<T> {
        public final T response;
        public final String newPrompt;

        private PromptResult(@Nullable T response, @Nullable String newPrompt) {
            this.response = response;
            this.newPrompt = newPrompt;
        }

        public static <T> PromptResult<T> response(T response) {
            return new PromptResult<T>(response, null);
        }

        public static <T> PromptResult<T> newPrompt(String newPrompt) {
            return new PromptResult<Object>(null, newPrompt);
        }
    }
}

