/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;

public final class XQueryContextItemLocator {
    private XQueryContextItemLocator() {
    }

    public static final int[] findContextPositions(String xQuery) {
        int[] contextPositions = new int[100];
        int contextPositionsFound = 0;
        boolean insideXQuerySyntax = true;
        boolean insideSingleQuotes = false;
        boolean insideDoubleQuotes = false;
        boolean insideComment = false;
        int conditionBracketsTier = 0;
        for (int i = 0; i < xQuery.length(); ++i) {
            if (xQuery.charAt(i) == '\"' && !insideSingleQuotes && !insideComment) {
                boolean bl = insideDoubleQuotes = !insideDoubleQuotes;
                if (insideDoubleQuotes) {
                    insideXQuerySyntax = false;
                    continue;
                }
                insideXQuerySyntax = true;
                continue;
            }
            if (xQuery.charAt(i) == '\'' && !insideDoubleQuotes && !insideComment) {
                boolean bl = insideSingleQuotes = !insideSingleQuotes;
                if (insideSingleQuotes) {
                    insideXQuerySyntax = false;
                    continue;
                }
                insideXQuerySyntax = true;
                continue;
            }
            if (!(xQuery.charAt(i) != '[' || insideSingleQuotes || insideDoubleQuotes || insideComment)) {
                ++conditionBracketsTier;
                continue;
            }
            if (!(xQuery.charAt(i) != ']' || insideSingleQuotes || insideDoubleQuotes || conditionBracketsTier <= 0 || insideComment)) {
                --conditionBracketsTier;
                continue;
            }
            if (xQuery.charAt(i) == '{' && !insideXQuerySyntax && conditionBracketsTier == 0 && !insideComment) {
                insideXQuerySyntax = true;
                insideSingleQuotes = false;
                insideDoubleQuotes = false;
                continue;
            }
            if (xQuery.charAt(i) == '}' && insideXQuerySyntax && conditionBracketsTier == 0 && !insideComment) {
                insideXQuerySyntax = false;
                continue;
            }
            if (xQuery.charAt(i) == '/' && i != 0 && (Character.isWhitespace(xQuery.charAt(i - 1)) || xQuery.charAt(i - 1) == '(') && conditionBracketsTier == 0 && insideXQuerySyntax && !insideComment) {
                String previousWord;
                char nextChar = xQuery.charAt(i + 1);
                if (!XQueryContextItemLocator.isValidXPathFirstCharacter(nextChar) || XQueryContextItemLocator.isValidXPathPrefixWord(previousWord = XQueryContextItemLocator.getPreviousWord(xQuery, i))) continue;
                contextPositions[contextPositionsFound++] = i;
                continue;
            }
            if (xQuery.charAt(i) == '.' && (i == 0 || Character.isWhitespace(xQuery.charAt(i - 1)) || xQuery.charAt(i - 1) == '(') && conditionBracketsTier == 0 && insideXQuerySyntax && !insideComment) {
                contextPositions[contextPositionsFound++] = i;
                continue;
            }
            if (xQuery.charAt(i) == '/' && i == 0) {
                contextPositions[contextPositionsFound++] = i;
                continue;
            }
            if (xQuery.charAt(i) == '<' && i != xQuery.length() - 1 && Character.isLetter(xQuery.charAt(i + 1)) && conditionBracketsTier == 0 && !insideDoubleQuotes && !insideSingleQuotes && insideXQuerySyntax && !insideComment) {
                if (!XQueryContextItemLocator.validXMLElement(xQuery, i)) continue;
                insideXQuerySyntax = false;
                continue;
            }
            if (xQuery.charAt(i) == '(' && i != xQuery.length() - 1 && xQuery.charAt(i + 1) == ':' && conditionBracketsTier == 0 && !insideDoubleQuotes && !insideSingleQuotes && insideXQuerySyntax && !insideComment) {
                insideComment = true;
                continue;
            }
            if (xQuery.charAt(i) != ':' || i == xQuery.length() - 1 || xQuery.charAt(i + 1) != ')' || conditionBracketsTier != 0 || insideDoubleQuotes || insideSingleQuotes || !insideXQuerySyntax || !insideComment) continue;
            insideComment = false;
        }
        int[] compactArray = new int[contextPositionsFound];
        System.arraycopy(contextPositions, 0, compactArray, 0, contextPositionsFound);
        return compactArray;
    }

    private static final String getPreviousWord(String xQuery, int fromIndex) {
        int wordEndIndex = 0;
        for (int j = fromIndex - 1; j >= 0; --j) {
            if (Character.isWhitespace(xQuery.charAt(j))) continue;
            wordEndIndex = j + 1;
            break;
        }
        int wordStartIndex = 0;
        for (int j = wordEndIndex - 1; j >= 0; --j) {
            if (!Character.isWhitespace(xQuery.charAt(j))) continue;
            wordStartIndex = j + 1;
            break;
        }
        return xQuery.substring(wordStartIndex, wordEndIndex);
    }

    private static final boolean isValidXPathPrefixWord(String word) {
        return word.startsWith("$") || word.startsWith("collection") || word.startsWith("document") || word.startsWith("doc");
    }

    private static final boolean isValidXPathFirstCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '@' || c == '*' || c == '/';
    }

    private static final boolean validXMLElement(String string, int fromIndex) {
        if (string == null || string.length() < 2) {
            return false;
        }
        if (string.charAt(0) != '<') {
            return false;
        }
        try {
            StringReader reader = new StringReader(string.substring(fromIndex, string.length()));
            StreamTokenizer tokens = new StreamTokenizer(reader);
            tokens.resetSyntax();
            tokens.eolIsSignificant(false);
            tokens.slashSlashComments(false);
            tokens.slashStarComments(false);
            tokens.wordChars(97, 122);
            tokens.wordChars(65, 90);
            tokens.wordChars(48, 57);
            tokens.wordChars(45, 45);
            tokens.wordChars(95, 95);
            tokens.quoteChar(34);
            tokens.quoteChar(39);
            tokens.wordChars(60, 60);
            tokens.wordChars(62, 62);
            tokens.wordChars(61, 61);
            tokens.wordChars(58, 58);
            tokens.whitespaceChars(32, 32);
            tokens.whitespaceChars(9, 9);
            tokens.whitespaceChars(10, 10);
            tokens.wordChars(47, 47);
            boolean isFirsttoken = true;
            Vector v = new Vector();
            boolean isFirstToken = true;
            while (tokens.nextToken() != -1) {
                char c;
                if (isFirstToken) {
                    if (tokens.sval.startsWith("<")) {
                        if (tokens.sval.length() == 1) {
                            return false;
                        }
                        c = tokens.sval.charAt(1);
                        if (c >= '0' && c <= '9') {
                            return false;
                        }
                        isFirstToken = false;
                        continue;
                    }
                    return false;
                }
                if (tokens.sval == null) {
                    return false;
                }
                if (!tokens.sval.endsWith("=")) {
                    return false;
                }
                if (tokens.sval.length() == 1) {
                    return false;
                }
                c = tokens.sval.charAt(0);
                return c < '0' || c > '9';
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

