/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.codepoints;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.codepoints.UnicodeCategory;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Term;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class RangeSet
extends AbstractSet<Range>
implements Comparable<RangeSet> {
    public static final RangeSet EOI = RangeSet.builder().add(Range.EOI).build();
    private final long[] ranges;
    public static final RangeSet EMPTY = RangeSet.builder().build();

    private RangeSet(long[] ranges) {
        this.ranges = ranges;
    }

    public RangeSet complement() {
        return UnicodeCategory.ALPHABET.minus(this);
    }

    public RangeSet union(RangeSet rangeSet) {
        Builder builder = new Builder();
        for (long range : this.ranges) {
            builder.add(range);
        }
        for (long range : rangeSet.ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    public RangeSet intersection(RangeSet rangeSet) {
        Builder builder = new Builder();
        int lhsI = 0;
        long lhsR = lhsI < this.ranges.length ? this.ranges[lhsI++] : -1L;
        int lhsF = RangeSet.firstCodepoint(lhsR);
        int lhsL = RangeSet.lastCodepoint(lhsR);
        int rhsI = 0;
        long rhsR = rhsI < rangeSet.ranges.length ? rangeSet.ranges[rhsI++] : -1L;
        int rhsF = RangeSet.firstCodepoint(rhsR);
        int rhsL = RangeSet.lastCodepoint(rhsR);
        while (lhsF >= 0 && rhsF >= 0) {
            if (lhsF <= rhsL && lhsL >= rhsF) {
                int rangeF = Math.max(lhsF, rhsF);
                int rangeL = Math.min(lhsL, rhsL);
                builder.add(RangeSet.range(rangeF, rangeL));
                if (lhsL > rangeL) {
                    lhsF = rangeL;
                } else {
                    long l = lhsI < this.ranges.length ? this.ranges[lhsI++] : -1L;
                    lhsF = RangeSet.firstCodepoint(l);
                    lhsL = RangeSet.lastCodepoint(l);
                }
                if (rhsL > rangeL) {
                    rhsF = rangeL + 1;
                    continue;
                }
                long r = rhsI < rangeSet.ranges.length ? rangeSet.ranges[rhsI++] : -1L;
                rhsF = RangeSet.firstCodepoint(r);
                rhsL = RangeSet.lastCodepoint(r);
                continue;
            }
            if (lhsL < rhsL) {
                long l = lhsI < this.ranges.length ? this.ranges[lhsI++] : -1L;
                lhsF = RangeSet.firstCodepoint(l);
                lhsL = RangeSet.lastCodepoint(l);
                continue;
            }
            long r = rhsI < rangeSet.ranges.length ? rangeSet.ranges[rhsI++] : -1L;
            rhsF = RangeSet.firstCodepoint(r);
            rhsL = RangeSet.lastCodepoint(r);
        }
        return builder.build();
    }

    public RangeSet minus(RangeSet rangeSet) {
        int removeI = 0;
        long removeR = removeI < rangeSet.ranges.length ? rangeSet.ranges[removeI++] : -1L;
        int removeF = RangeSet.firstCodepoint(removeR);
        int removeL = RangeSet.lastCodepoint(removeR);
        int rangeI = 0;
        long rangeR = rangeI < this.ranges.length ? this.ranges[rangeI++] : -1L;
        int rangeF = RangeSet.firstCodepoint(rangeR);
        int rangeL = RangeSet.lastCodepoint(rangeR);
        Builder builder = new Builder();
        while (rangeF >= 0) {
            long r;
            if (removeF == -1 || rangeL < removeF) {
                builder.add(RangeSet.range(rangeF, rangeL));
                r = rangeI < this.ranges.length ? this.ranges[rangeI++] : -1L;
                rangeF = RangeSet.firstCodepoint(r);
                rangeL = RangeSet.lastCodepoint(r);
                continue;
            }
            if (rangeF > removeL) {
                r = removeI < rangeSet.ranges.length ? rangeSet.ranges[removeI++] : -1L;
                removeF = RangeSet.firstCodepoint(r);
                removeL = RangeSet.lastCodepoint(r);
                continue;
            }
            if (rangeF < removeF) {
                builder.add(rangeF, removeF - 1);
            }
            if (rangeL > removeL) {
                rangeF = removeL + 1;
                r = removeI < rangeSet.ranges.length ? rangeSet.ranges[removeI++] : -1L;
                removeF = RangeSet.firstCodepoint(r);
                removeL = RangeSet.lastCodepoint(r);
                continue;
            }
            r = rangeI < this.ranges.length ? this.ranges[rangeI++] : -1L;
            rangeF = RangeSet.firstCodepoint(r);
            rangeL = RangeSet.lastCodepoint(r);
        }
        return builder.build();
    }

    public boolean containsCodepoint(int codepoint) {
        int lo = 0;
        int hi = this.ranges.length - 1;
        while (lo <= hi) {
            int m = hi + lo >> 1;
            long range = this.ranges[m];
            if (RangeSet.firstCodepoint(range) > codepoint) {
                hi = m - 1;
                continue;
            }
            if (RangeSet.lastCodepoint(range) < codepoint) {
                lo = m + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    private static int firstCodepoint(long range) {
        return (int)(range >>> 32);
    }

    private static int lastCodepoint(long range) {
        return (int)(range & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long range(int firstCodepoint, int lastCodepoint) {
        return (long)firstCodepoint << 32 | (long)lastCodepoint;
    }

    public int charCount() {
        int charCount = 0;
        for (long range : this.ranges) {
            charCount += RangeSet.lastCodepoint(range) - RangeSet.firstCodepoint(range) + 1;
        }
        return charCount;
    }

    public boolean isSingleton() {
        if (this.ranges.length != 1) {
            return false;
        }
        long range = this.ranges[0];
        return RangeSet.firstCodepoint(range) == RangeSet.lastCodepoint(range);
    }

    @Override
    public String toString() {
        return this == EOI ? this.shortName() : this.rangesAsStream().map(Range::toString).collect(Collectors.joining("; ", "[", "]"));
    }

    private Stream<Range> rangesAsStream() {
        return LongStream.of(this.ranges).mapToObj(range -> new Range(RangeSet.firstCodepoint(range), RangeSet.lastCodepoint(range)));
    }

    public String toJava() {
        return this.rangesAsStream().map(Range::toJava).collect(Collectors.joining("", "builder()", ".build()"));
    }

    @Override
    public Iterator<Range> iterator() {
        return this.rangesAsStream().iterator();
    }

    @Override
    public int size() {
        return this.ranges.length;
    }

    @Override
    public boolean add(Range e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Range> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(RangeSet other) {
        return Arrays.compare(this.ranges, other.ranges);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeSet)) {
            return false;
        }
        return Arrays.equals(this.ranges, ((RangeSet)obj).ranges);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RangeSet of(Range ... ranges) {
        Builder builder = new Builder();
        for (Range range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    public Term toCharset(boolean isDeleted) {
        return new Charset(isDeleted, this);
    }

    public String shortName() {
        return this.ranges.length == 0 ? "[]" : Codepoint.toString(RangeSet.firstCodepoint(this.ranges[0])) + (this.charCount() == 1 ? "" : "...");
    }

    public static final class Builder {
        private long[] ranges = new long[16];
        private int size = 0;

        private Builder() {
        }

        public Builder add(int codepoint) {
            return this.add(codepoint, codepoint);
        }

        public Builder add(long range) {
            if (this.ranges.length == this.size) {
                this.ranges = Arrays.copyOf(this.ranges, this.size << 1);
            }
            this.ranges[this.size++] = range;
            return this;
        }

        public Builder add(int firstCodepoint, int lastCodepoint) {
            return this.add(RangeSet.range(firstCodepoint, lastCodepoint));
        }

        public Builder add(Range range) {
            return this.add(range.getFirstCodepoint(), range.getLastCodepoint());
        }

        public Builder add(Collection<Range> ranges) {
            for (Range range : ranges) {
                this.add(range);
            }
            return this;
        }

        public Builder add(RangeSet rangeSet) {
            for (long range : rangeSet.ranges) {
                this.add(range);
            }
            return this;
        }

        private boolean isNormalized() {
            for (int i = 1; i < this.size; ++i) {
                if (RangeSet.firstCodepoint(this.ranges[i]) > RangeSet.lastCodepoint(this.ranges[i - 1]) + 1) continue;
                return false;
            }
            return true;
        }

        public RangeSet build() {
            if (!this.isNormalized()) {
                Arrays.sort(this.ranges, 0, this.size);
                long range = this.ranges[0];
                int first = RangeSet.firstCodepoint(range);
                int last = RangeSet.lastCodepoint(range);
                int s = 0;
                for (int r = 1; r < this.size; ++r) {
                    range = this.ranges[r];
                    int f = RangeSet.firstCodepoint(range);
                    int l = RangeSet.lastCodepoint(range);
                    if (f > last + 1) {
                        this.ranges[s++] = RangeSet.range(first, last);
                        first = f;
                        last = l;
                        continue;
                    }
                    if (l <= last) continue;
                    last = l;
                }
                this.ranges[s++] = RangeSet.range(first, last);
                this.size = s;
            }
            RangeSet result = new RangeSet(Arrays.copyOf(this.ranges, this.size));
            this.ranges = null;
            return result;
        }
    }
}

