/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.basex.util.FTToken;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTSpan;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.IntList;

public final class WesternTokenizer
extends Tokenizer {
    private static final HashSet<Language> SUPPORTED = new HashSet();
    private final IntList sentPos = new IntList();
    private final IntList paraPos = new IntList();
    private final FTCase casesens;
    private final boolean diacritics;
    private final boolean wildcards;
    private byte[] text = Token.EMPTY;
    private int sentence;
    private int paragraph;
    private int punct;
    private int spos;
    private int epos;
    private int pos = -1;
    private int next;
    private boolean para;
    private boolean spec;

    public WesternTokenizer(FTOpt fto) {
        this.casesens = fto != null && fto.cs != null ? fto.cs : FTCase.INSENSITIVE;
        this.wildcards = fto != null && fto.is(FTFlag.WC);
        this.diacritics = fto != null && fto.is(FTFlag.DC);
    }

    @Override
    Collection<Language> languages() {
        return SUPPORTED;
    }

    @Override
    Tokenizer get(FTOpt f) {
        return new WesternTokenizer(f);
    }

    @Override
    public WesternTokenizer init(byte[] txt) {
        if (this.text != txt) {
            this.text = txt;
            this.sentPos.reset();
            this.paraPos.reset();
        }
        this.init();
        return this;
    }

    private void init() {
        this.sentence = 0;
        this.paragraph = 0;
        this.pos = -1;
        this.epos = 0;
        this.next = 0;
    }

    @Override
    public boolean hasNext() {
        int n = this.next;
        if (n <= 0 && (this.all ? this.moreAll() : this.more())) {
            this.next = ++n;
        }
        return n > 0;
    }

    @Override
    public FTSpan next() {
        return new FTSpan(this.nextToken(), this.pos, this.spec);
    }

    @Override
    public byte[] nextToken() {
        FTCase cs;
        if (--this.next < 0) {
            this.hasNext();
        }
        byte[] t = this.token();
        if (this.original) {
            return t;
        }
        boolean a = Token.ascii(t);
        if (!a && !this.diacritics) {
            t = FTToken.noDiacritics(t);
        }
        if ((cs = this.casesens) == FTCase.UPPER) {
            t = WesternTokenizer.upper(t, a);
        } else if (cs != FTCase.SENSITIVE) {
            t = WesternTokenizer.lower(t, a);
        }
        return t;
    }

    /*
     * Exception decompiling
     */
    private boolean more() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean moreAll() {
        int cp;
        int t;
        byte[] txt = this.text;
        int txtl = txt.length;
        int lp = t = this.epos;
        this.spos = t;
        boolean pa = false;
        boolean sp = false;
        while (t < txtl) {
            cp = Token.cp(txt, t);
            if (cp == 10) {
                pa = true;
            } else if (FTToken.lod(cp)) break;
            sp = true;
            t += Token.cl(txt, t);
        }
        this.para = pa;
        this.spec = sp;
        this.epos = t;
        if (lp < t) {
            return true;
        }
        while (t < txtl && FTToken.lod(cp = Token.cp(txt, t))) {
            t += Token.cl(txt, t);
        }
        this.epos = t;
        ++this.pos;
        return lp < t;
    }

    private byte[] token() {
        return Arrays.copyOfRange(this.text, this.spos, this.epos);
    }

    @Override
    int pos(int w, FTUnit u) {
        IntList il;
        if (u == FTUnit.WORDS) {
            return w;
        }
        IntList sPos = this.sentPos;
        IntList pPos = this.paraPos;
        IntList intList = il = u == FTUnit.SENTENCES ? sPos : pPos;
        if (sPos.isEmpty()) {
            this.init();
            while (this.more()) {
                sPos.add(this.sentence);
                pPos.add(this.paragraph);
            }
        }
        return il.get(w);
    }

    static byte[] upper(byte[] token, boolean ascii) {
        int tl = token.length;
        if (ascii) {
            for (int i = 0; i < tl; ++i) {
                token[i] = (byte)Token.uc(token[i]);
            }
            return token;
        }
        TokenBuilder tb = new TokenBuilder();
        Token.forEachCp(token, cp -> tb.add(Token.uc(cp)));
        return tb.finish();
    }

    static byte[] lower(byte[] token, boolean ascii) {
        int tl = token.length;
        if (ascii) {
            for (int i = 0; i < tl; ++i) {
                token[i] = (byte)Token.lc(token[i]);
            }
            return token;
        }
        TokenBuilder tb = new TokenBuilder();
        Token.forEachCp(token, cp -> tb.add(Token.lc(cp)));
        return tb.finish();
    }

    @Override
    int[][] info() {
        this.init();
        IntList[] il = new IntList[]{new IntList(), new IntList(), new IntList(), new IntList(), new IntList()};
        int lass = 0;
        int lasp = 0;
        int sl = 0;
        int pl = 0;
        while (this.more()) {
            byte[] n = this.token();
            int l = n.length;
            il[0].add(l);
            for (byte b : n) {
                il[3].add((int)b);
            }
            if (this.sentence != lass) {
                if (sl > 0) {
                    il[1].add(sl);
                    il[4].add(this.punct);
                }
                lass = this.sentence;
                sl = 0;
            }
            if (this.paragraph != lasp) {
                if (pl > 0) {
                    il[2].add(pl);
                }
                lasp = this.paragraph;
                pl = 0;
            }
            sl += l;
            pl += l;
        }
        if (this.sentence != lass && sl > 0) {
            il[1].add(sl);
            il[4].add(this.punct);
        }
        if (pl > 0) {
            il[2].add(pl);
        }
        il[1].add(sl + 1);
        return new int[][]{il[0].finish(), il[1].finish(), il[2].finish(), il[3].finish(), il[4].finish()};
    }

    @Override
    protected byte prec() {
        return 10;
    }

    @Override
    boolean paragraph() {
        return this.para;
    }

    public String toString() {
        return Util.className(this) + "[" + Token.string(this.text) + "]";
    }

    static {
        String[] nonw = new String[]{"ja", "ko", "th", "zh"};
        for (Language l : Language.ALL.values()) {
            if (Strings.eq(l.code(), nonw)) continue;
            SUPPORTED.add(l);
        }
    }
}

