/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.ListIterator;
import org.basex.core.jobs.Job;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.TreeSlice;
import org.basex.query.value.Value;
import org.basex.query.value.array.LeafNode;
import org.basex.query.value.array.PartialLeafNode;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.array.TreeArray;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Util;

public final class BigArray
extends TreeArray {
    final Value[] left;
    final FingerTree<Value, Value> middle;
    final Value[] right;

    BigArray(Value[] left, FingerTree<Value, Value> middle, Value[] right, Type type) {
        super(type);
        this.left = left;
        this.middle = middle;
        this.right = right;
        assert (left.length >= 4 && left.length <= 19 && right.length >= 4 && right.length <= 19);
    }

    BigArray(Value[] left, Value[] right, Type type) {
        this(left, FingerTree.empty(), right, type);
    }

    @Override
    public Value memberAt(long index) {
        int ll = this.left.length;
        if (index < (long)ll) {
            return this.left[(int)index];
        }
        long me = (long)ll + this.middle.size();
        if (index >= me) {
            return this.right[(int)(index - me)];
        }
        return this.middle.get(index - (long)ll);
    }

    @Override
    public long structSize() {
        return (long)this.left.length + this.middle.size() + (long)this.right.length;
    }

    @Override
    public XQArray putMember(long pos, Value value, Job job) {
        job.checkStop();
        ArrayType tp = this.union(value);
        long p = pos;
        int ll = this.left.length;
        if (p < (long)ll) {
            Value[] newLeft = (Value[])this.left.clone();
            newLeft[(int)p] = value;
            return new BigArray(newLeft, this.middle, this.right, tp);
        }
        long ms = this.middle.size();
        if ((p -= (long)ll) < ms) {
            return new BigArray(this.left, this.middle.set(p, value), this.right, tp);
        }
        Value[] newRight = (Value[])this.right.clone();
        newRight[(int)(p -= ms)] = value;
        return new BigArray(this.left, this.middle, newRight, tp);
    }

    @Override
    public XQArray insertMember(long pos, Value value, Job job) {
        job.checkStop();
        ArrayType tp = this.union(value);
        int ll = this.left.length;
        if (pos <= (long)ll) {
            int p = (int)pos;
            Value[] temp = BigArray.slice(this.left, 0, ll + 1);
            Array.copy(temp, p, ll - p, temp, p + 1);
            temp[p] = value;
            if (ll < 19) {
                return new BigArray(temp, this.middle, this.right, tp);
            }
            int m = (ll + 1) / 2;
            return new BigArray(BigArray.slice(temp, 0, m), this.middle.prepend(new LeafNode(BigArray.slice(temp, m, ll + 1))), this.right, tp);
        }
        long ms = this.middle.size();
        if (pos - (long)ll < ms) {
            return new BigArray(this.left, this.middle.insert(pos - (long)ll, value, job), this.right, tp);
        }
        int rl = this.right.length;
        int p = (int)(pos - (long)ll - ms);
        Value[] temp = BigArray.slice(this.right, 0, rl + 1);
        Array.copy(temp, p, rl - p, temp, p + 1);
        temp[p] = value;
        if (rl < 19) {
            return new BigArray(this.left, this.middle, temp, tp);
        }
        int m = (rl + 1) / 2;
        return new BigArray(this.left, this.middle.append(new LeafNode(BigArray.slice(temp, 0, m))), BigArray.slice(temp, m, rl + 1), tp);
    }

    @Override
    public XQArray removeMember(long pos, Job job) {
        job.checkStop();
        int ll = this.left.length;
        int rl = this.right.length;
        if (pos < (long)ll) {
            int p = (int)pos;
            if (ll > 4) {
                Value[] newLeft = new Value[ll - 1];
                Array.copy(this.left, p, newLeft);
                Array.copy(this.left, p + 1, newLeft.length - p, newLeft, p);
                return new BigArray(newLeft, this.middle, this.right, this.type);
            }
            if (this.middle.isEmpty()) {
                int n = ll - 1 + rl;
                Value[] vals = new Value[n];
                Array.copy(this.left, p, vals);
                Array.copy(this.left, p + 1, ll - 1 - p, vals, p);
                Array.copyFromStart(this.right, rl, vals, ll - 1);
                return this.fromMerged(vals);
            }
            Value[] head = ((LeafNode)this.middle.head()).values;
            int hl = head.length;
            int n = ll - 1 + hl;
            if (hl > 8) {
                int move = (hl - 8 + 1) / 2;
                Value[] newLeft = new Value[ll - 1 + move];
                Array.copy(this.left, p, newLeft);
                Array.copy(this.left, p + 1, ll - 1 - p, newLeft, p);
                Array.copyFromStart(head, move, newLeft, ll - 1);
                Value[] newHead = BigArray.slice(head, move, hl);
                return new BigArray(newLeft, this.middle.replaceHead(new LeafNode(newHead)), this.right, this.type);
            }
            Value[] newLeft = new Value[n];
            Array.copy(this.left, p, newLeft);
            Array.copy(this.left, p + 1, ll - 1 - p, newLeft, p);
            Array.copyFromStart(head, hl, newLeft, ll - 1);
            return new BigArray(newLeft, this.middle.tail(), this.right, this.type);
        }
        long ms = this.middle.size();
        long ro = (long)ll + ms;
        if (pos >= ro) {
            int p = (int)(pos - ro);
            if (rl > 4) {
                Value[] newRight = new Value[rl - 1];
                Array.copy(this.right, p, newRight);
                Array.copy(this.right, p + 1, rl - 1 - p, newRight, p);
                return new BigArray(this.left, this.middle, newRight, this.type);
            }
            if (this.middle.isEmpty()) {
                int n = ll + rl - 1;
                Value[] vals = new Value[n];
                Array.copy(this.left, ll, vals);
                Array.copyFromStart(this.right, p, vals, ll);
                Array.copy(this.right, p + 1, rl - 1 - p, vals, ll + p);
                return this.fromMerged(vals);
            }
            Value[] last = ((LeafNode)this.middle.foot()).values;
            int sl = last.length;
            int n = sl + rl - 1;
            if (sl > 8) {
                int move = (sl - 8 + 1) / 2;
                Value[] newLast = BigArray.slice(last, 0, sl - move);
                Value[] newRight = new Value[rl - 1 + move];
                Array.copyToStart(last, sl - move, move, newRight);
                Array.copyFromStart(this.right, p, newRight, move);
                Array.copy(this.right, p + 1, rl - 1 - p, newRight, move + p);
                return new BigArray(this.left, this.middle.replaceLast(new LeafNode(newLast)), newRight, this.type);
            }
            Value[] newRight = new Value[n];
            Array.copy(last, sl, newRight);
            Array.copyFromStart(this.right, p, newRight, sl);
            Array.copy(this.right, p + 1, rl - 1 - p, newRight, sl + p);
            return new BigArray(this.left, this.middle.trunk(), newRight, this.type);
        }
        TreeSlice<Value, Value> slice = this.middle.remove(pos - (long)ll, job);
        if (slice.isTree()) {
            return new BigArray(this.left, slice.getTree(), this.right, this.type);
        }
        Value[] mid = ((PartialLeafNode)slice.getPartial()).elems;
        int ml = mid.length;
        if (ll > rl) {
            int move = (ll - 4 + 1) / 2;
            Value[] newLeft = BigArray.slice(this.left, 0, ll - move);
            Value[] newMid = BigArray.slice(this.left, ll - move, ll + ml);
            Array.copyFromStart(mid, ml, newMid, move);
            return new BigArray(newLeft, FingerTree.singleton(new LeafNode(newMid)), this.right, this.type);
        }
        if (rl > 4) {
            int move = (rl - 4 + 1) / 2;
            Value[] newMid = BigArray.slice(mid, 0, ml + move);
            Array.copyFromStart(this.right, move, newMid, ml);
            Value[] newRight = BigArray.slice(this.right, move, rl);
            return new BigArray(this.left, FingerTree.singleton(new LeafNode(newMid)), newRight, this.type);
        }
        int hl = ml / 2;
        int mr = ml - hl;
        Value[] newLeft = BigArray.slice(this.left, 0, ll + hl);
        Array.copyFromStart(mid, hl, newLeft, ll);
        Value[] newRight = BigArray.slice(this.right, -mr, rl);
        Array.copyToStart(mid, hl, mr, newRight);
        return new BigArray(newLeft, newRight, this.type);
    }

    @Override
    protected XQArray subArr(long pos, long length, Job job) {
        Value[] newRight;
        FingerTree<Value, Value> newMiddle;
        FingerTree<Value, Value> mid1;
        Value[] newLeft;
        FingerTree<Value, Value> mid;
        int inRight;
        job.checkStop();
        int ll = this.left.length;
        int rl = this.right.length;
        long ms = this.middle.size();
        long end = pos + length;
        if (end <= (long)ll) {
            int p = (int)pos;
            int n = (int)length;
            if (length <= 7L) {
                return new SmallArray(BigArray.slice(this.left, p, p + n), this.type);
            }
            int mid2 = p + n / 2;
            return new BigArray(BigArray.slice(this.left, p, mid2), BigArray.slice(this.left, mid2, p + n), this.type);
        }
        long ro = (long)ll + ms;
        if (pos >= ro) {
            int p = (int)(pos - ro);
            int n = (int)length;
            if (length <= 7L) {
                return new SmallArray(BigArray.slice(this.right, p, p + n), this.type);
            }
            int mid3 = p + n / 2;
            return new BigArray(BigArray.slice(this.right, p, mid3), BigArray.slice(this.right, mid3, p + n), this.type);
        }
        int inLeft = pos < (long)ll ? (int)((long)ll - pos) : 0;
        int n = inRight = end > ro ? (int)(end - ro) : 0;
        if (inLeft >= 4 && inRight >= 4) {
            Value[] newLeft2 = inLeft == ll ? this.left : BigArray.slice(this.left, (int)pos, ll);
            Value[] newRight2 = inRight == rl ? this.right : BigArray.slice(this.right, 0, inRight);
            return new BigArray(newLeft2, this.middle, newRight2, this.type);
        }
        if (this.middle.isEmpty()) {
            Value[] out;
            if (inLeft == 0) {
                out = inRight == rl ? this.right : BigArray.slice(this.right, 0, inRight);
            } else if (inRight == 0) {
                out = inLeft == ll ? this.left : BigArray.slice(this.left, ll - inLeft, ll);
            } else {
                out = BigArray.slice(this.left, ll - inLeft, ll + inRight);
                Array.copyFromStart(this.right, inRight, out, inLeft);
            }
            return this.fromMerged(out);
        }
        long inMiddle = length - (long)inLeft - (long)inRight;
        if (inMiddle == ms) {
            mid = this.middle;
        } else {
            long off = pos < (long)ll ? 0L : pos - (long)ll;
            TreeSlice<Value, Value> slice = this.middle.slice(off, inMiddle);
            if (!slice.isTree()) {
                Value[] single = ((PartialLeafNode)slice.getPartial()).elems;
                int sl = single.length;
                if (inLeft > 0) {
                    Value[] out = BigArray.slice(this.left, (int)pos, ll + sl);
                    Array.copyFromStart(single, sl, out, inLeft);
                    return this.fromMerged(out);
                }
                if (inRight > 0) {
                    Value[] out = BigArray.slice(single, 0, sl + inRight);
                    Array.copyFromStart(this.right, inRight, out, sl);
                    return this.fromMerged(out);
                }
                return new SmallArray(single, this.type);
            }
            mid = slice.getTree();
        }
        int off = ll - inLeft;
        if (inLeft >= 4) {
            newLeft = inLeft == ll ? this.left : BigArray.slice(this.left, off, ll);
            mid1 = mid;
        } else {
            Value[] head = ((LeafNode)mid.head()).values;
            if (inLeft == 0) {
                newLeft = head;
            } else {
                newLeft = BigArray.slice(head, -inLeft, head.length);
                Array.copyToStart(this.left, off, inLeft, newLeft);
            }
            mid1 = mid.tail();
        }
        if (inRight >= 4) {
            newMiddle = mid1;
            newRight = inRight == rl ? this.right : BigArray.slice(this.right, 0, inRight);
        } else if (!mid1.isEmpty()) {
            Value[] last = ((LeafNode)mid1.foot()).values;
            int sl = last.length;
            newMiddle = mid1.trunk();
            if (inRight == 0) {
                newRight = last;
            } else {
                newRight = BigArray.slice(last, 0, sl + inRight);
                Array.copyFromStart(this.right, inRight, newRight, sl);
            }
        } else {
            if (inRight == 0) {
                return this.fromMerged(newLeft);
            }
            int nll = newLeft.length;
            int n2 = nll + inRight;
            Value[] out = BigArray.slice(newLeft, 0, n2);
            Array.copyFromStart(this.right, inRight, out, nll);
            return this.fromMerged(out);
        }
        return new BigArray(newLeft, newMiddle, newRight, this.type);
    }

    private XQArray fromMerged(Value[] merged) {
        int ml = merged.length;
        if (ml <= 7) {
            return new SmallArray(merged, this.type);
        }
        int mid = ml / 2;
        return new BigArray(BigArray.slice(merged, 0, mid), BigArray.slice(merged, mid, ml), this.type);
    }

    @Override
    public XQArray reverseArray(Job job) {
        int i;
        job.checkStop();
        int ll = this.left.length;
        int rl = this.right.length;
        Value[] newLeft = new Value[rl];
        Value[] newRight = new Value[ll];
        for (i = 0; i < rl; ++i) {
            newLeft[i] = this.right[rl - 1 - i];
        }
        for (i = 0; i < ll; ++i) {
            newRight[i] = this.left[ll - 1 - i];
        }
        return new BigArray(newLeft, this.middle.reverse(job), newRight, this.type);
    }

    @Override
    public ListIterator<Value> iterator(long start) {
        ListIterator<Value> sub;
        int startPos;
        final Value[] ls = this.left;
        final Value[] rs = this.right;
        final int ll = ls.length;
        final int rl = rs.length;
        final long ms = this.middle.size();
        if (start < (long)ll) {
            startPos = (int)start - ll;
            sub = this.middle.listIterator(0L);
        } else if (start - (long)ll < ms) {
            startPos = 0;
            sub = this.middle.listIterator(start - (long)ll);
        } else {
            startPos = (int)(start - (long)ll - ms) + 1;
            sub = this.middle.listIterator(ms);
        }
        return new ListIterator<Value>(){
            int pos;
            {
                this.pos = startPos;
            }

            @Override
            public int nextIndex() {
                return this.pos < 0 ? ll + this.pos : (this.pos > 0 ? (int)((long)ll + ms + (long)this.pos - 1L) : ll + sub.nextIndex());
            }

            @Override
            public boolean hasNext() {
                return this.pos <= rl;
            }

            @Override
            public Value next() {
                if (this.pos < 0) {
                    return ls[ll + this.pos++];
                }
                if (this.pos == 0) {
                    if (sub.hasNext()) {
                        return (Value)sub.next();
                    }
                    this.pos = 1;
                }
                return rs[this.pos++ - 1];
            }

            @Override
            public int previousIndex() {
                return this.pos < 0 ? ll + this.pos - 1 : (this.pos > 0 ? (int)((long)ll + ms + (long)this.pos - 2L) : ll + sub.previousIndex());
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > -ll;
            }

            @Override
            public Value previous() {
                if (this.pos > 0 && --this.pos > 0) {
                    return rs[this.pos - 1];
                }
                if (this.pos == 0) {
                    if (sub.hasPrevious()) {
                        return (Value)sub.previous();
                    }
                    this.pos = -1;
                    return ls[ll - 1];
                }
                return ls[ll + --this.pos];
            }

            @Override
            public void add(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void set(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }
}

