/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.CrossContextServletContext;
import org.eclipse.jetty.ee9.nested.Dispatcher;
import org.eclipse.jetty.ee9.nested.MultiPart;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.Response;
import org.eclipse.jetty.ee9.nested.ServletCoreRequest;
import org.eclipse.jetty.ee9.nested.ServletCoreResponse;
import org.eclipse.jetty.ee9.nested.ServletRequestHttpWrapper;
import org.eclipse.jetty.ee9.nested.ServletResponseHttpWrapper;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;

class CrossContextDispatcher
implements RequestDispatcher {
    public static final String ORIGINAL_URI = "org.eclipse.jetty.dispatch.originalURI";
    public static final String ORIGINAL_QUERY_STRING = "org.eclipse.jetty.dispatch.originalQueryString";
    public static final String ORIGINAL_SERVLET_MAPPING = "org.eclipse.jetty.dispatch.originalServletMapping";
    public static final String ORIGINAL_CONTEXT_PATH = "org.eclipse.jetty.dispatch.originalContextPath";
    private static final String FOREIGN_SERVLET_PACKAGE = "javax.servlet.";
    public static final Set<String> ATTRIBUTES = Set.of("jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.mapping", "jakarta.servlet.forward.context_path", "jakarta.servlet.forward.servlet_path", "jakarta.servlet.forward.query_string", "jakarta.servlet.forward.path_info", "jakarta.servlet.include.request_uri", "jakarta.servlet.include.mapping", "jakarta.servlet.include.context_path", "jakarta.servlet.include.servlet_path", "jakarta.servlet.include.query_string", "jakarta.servlet.include.path_info", "org.eclipse.jetty.CrossContextDispatch", "org.eclipse.jetty.dispatch.originalURI", "org.eclipse.jetty.dispatch.originalQueryString", "org.eclipse.jetty.dispatch.originalServletMapping", "org.eclipse.jetty.dispatch.originalContextPath", FormFields.class.getName());
    private final CrossContextServletContext _targetContext;
    private final HttpURI _uri;
    private final String _decodedPathInContext;

    CrossContextDispatcher(CrossContextServletContext targetContext, HttpURI uri, String decodedPathInContext) {
        this._targetContext = targetContext;
        this._uri = uri;
        this._decodedPathInContext = decodedPathInContext;
    }

    public void forward(ServletRequest servletRequest, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = servletRequest instanceof HttpServletRequest ? (HttpServletRequest)servletRequest : new ServletRequestHttpWrapper(servletRequest);
        HttpServletResponse httpServletResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest(servletRequest));
        Response baseResponse = baseRequest.getResponse();
        ContextHandler.CoreContextRequest coreContextRequest = baseRequest.getCoreRequest();
        org.eclipse.jetty.server.Response coreResponse = coreContextRequest.getHttpChannel().getCoreResponse();
        baseResponse.resetForForward();
        ContextHandler contextHandler = this._targetContext.getTargetContext().getContextHandler();
        if (contextHandler instanceof ContextHandler.CoreContextHandler) {
            ContextHandler.CoreContextHandler coreContextHandler = (ContextHandler.CoreContextHandler)contextHandler;
            new Dispatcher(coreContextHandler.getContextHandler(), this._uri, this._decodedPathInContext).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, DispatcherType.FORWARD);
            return;
        }
        ForwardRequest forwardRequest = new ForwardRequest(coreContextRequest, baseRequest, httpServletRequest);
        ServletCoreResponse servletCoreResponse = new ServletCoreResponse(forwardRequest, httpServletResponse, baseResponse, coreResponse, false);
        try (Blocker.Callback callback = Blocker.callback();){
            this._targetContext.getTargetContext().getContextHandler().handle((org.eclipse.jetty.server.Request)forwardRequest, (org.eclipse.jetty.server.Response)servletCoreResponse, (Callback)callback);
            callback.block();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (!baseRequest.isAsyncStarted() && !servletCoreResponse.hasLastWrite()) {
            Object closeable;
            try {
                closeable = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                closeable = response.getWriter();
            }
            IO.close((Closeable)closeable);
        }
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = servletRequest instanceof HttpServletRequest ? (HttpServletRequest)servletRequest : new ServletRequestHttpWrapper(servletRequest);
        HttpServletResponse httpServletResponse = servletResponse instanceof HttpServletResponse ? (HttpServletResponse)servletResponse : new ServletResponseHttpWrapper(servletResponse);
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest(servletRequest));
        Response baseResponse = baseRequest.getResponse();
        ContextHandler.CoreContextRequest coreContextRequest = baseRequest.getCoreRequest();
        org.eclipse.jetty.server.Response coreResponse = coreContextRequest.getHttpChannel().getCoreResponse();
        ContextHandler contextHandler = this._targetContext.getTargetContext().getContextHandler();
        if (contextHandler instanceof ContextHandler.CoreContextHandler) {
            ContextHandler.CoreContextHandler coreContextHandler = (ContextHandler.CoreContextHandler)contextHandler;
            new Dispatcher(coreContextHandler.getContextHandler(), this._uri, this._decodedPathInContext).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        IncludeRequest includeRequest = new IncludeRequest(coreContextRequest, baseRequest, httpServletRequest);
        IncludeResponse includeResponse = new IncludeResponse(includeRequest, httpServletResponse, baseResponse, coreResponse);
        try (Blocker.Callback callback = Blocker.callback();){
            this._targetContext.getTargetContext().getContextHandler().handle((org.eclipse.jetty.server.Request)includeRequest, (org.eclipse.jetty.server.Response)includeResponse, (Callback)callback);
            callback.block();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private class ForwardRequest
    extends ServletCoreRequest {
        private Request _baseRequest;
        private HttpURI _fullyQualifiedURI;

        public ForwardRequest(ContextHandler.CoreContextRequest coreContextRequest, Request request, final HttpServletRequest httpServletRequest) {
            super(coreContextRequest, httpServletRequest, (Attributes)new Attributes.Synthetic(CrossContextDispatcher.this, new ServletCoreRequest.ServletAttributes(httpServletRequest)){
                final /* synthetic */ CrossContextDispatcher this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                protected Object getSyntheticAttribute(String name) {
                    if (name == null) {
                        return null;
                    }
                    if (((String)name).startsWith(CrossContextDispatcher.FOREIGN_SERVLET_PACKAGE)) {
                        name = "jakarta.servlet." + ((String)name).substring(CrossContextDispatcher.FOREIGN_SERVLET_PACKAGE.length());
                    }
                    return switch (name) {
                        case "jakarta.servlet.forward.request_uri" -> httpServletRequest.getRequestURI();
                        case "jakarta.servlet.forward.servlet_path" -> httpServletRequest.getServletPath();
                        case "jakarta.servlet.forward.path_info" -> httpServletRequest.getPathInfo();
                        case "jakarta.servlet.forward.context_path" -> httpServletRequest.getContextPath();
                        case "jakarta.servlet.forward.mapping" -> httpServletRequest.getHttpServletMapping();
                        case "jakarta.servlet.forward.query_string" -> httpServletRequest.getQueryString();
                        case "jakarta.servlet.include.mapping" -> REMOVED;
                        case "jakarta.servlet.include.request_uri" -> REMOVED;
                        case "jakarta.servlet.include.context_path" -> REMOVED;
                        case "jakarta.servlet.include.query_string" -> REMOVED;
                        case "jakarta.servlet.include.servlet_path" -> REMOVED;
                        case "jakarta.servlet.include.path_info" -> REMOVED;
                        case "org.eclipse.jetty.CrossContextDispatch" -> DispatcherType.FORWARD.toString();
                        default -> {
                            if (FormFields.class.getName().equals(name)) {
                                Request baseRequest = Objects.requireNonNull(Request.getBaseRequest((ServletRequest)httpServletRequest));
                                yield baseRequest.peekParameters();
                            }
                            yield null;
                        }
                    };
                }

                protected Set<String> getSyntheticNameSet() {
                    return ATTRIBUTES;
                }
            });
            this._baseRequest = request;
            this._fullyQualifiedURI = HttpURI.build((String)request.getRootURL().toString()).pathQuery(CrossContextDispatcher.this._uri.getPathQuery()).asImmutable();
        }

        @Override
        public Object getAttribute(String name) {
            if (MultiPart.Parser.class.getName().equals(name)) {
                return this._baseRequest.getAttribute(name);
            }
            return super.getAttribute(name);
        }

        @Override
        public HttpURI getHttpURI() {
            return this._fullyQualifiedURI;
        }
    }

    private class IncludeRequest
    extends ServletCoreRequest {
        private Request _baseRequest;

        public IncludeRequest(ContextHandler.CoreContextRequest coreContextRequest, Request request, final HttpServletRequest httpServletRequest) {
            super(coreContextRequest, httpServletRequest, (Attributes)new Attributes.Synthetic(CrossContextDispatcher.this, new ServletCoreRequest.ServletAttributes(httpServletRequest)){
                final /* synthetic */ CrossContextDispatcher this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                public Object getAttribute(String name) {
                    if (((String)name).startsWith(CrossContextDispatcher.FOREIGN_SERVLET_PACKAGE)) {
                        name = "jakarta.servlet." + ((String)name).substring(CrossContextDispatcher.FOREIGN_SERVLET_PACKAGE.length());
                    }
                    return super.getAttribute((String)name);
                }

                protected Object getSyntheticAttribute(String name) {
                    if (name == null) {
                        return null;
                    }
                    return switch (name) {
                        case "jakarta.servlet.include.mapping" -> null;
                        case "jakarta.servlet.include.servlet_path" -> null;
                        case "jakarta.servlet.include.path_info" -> this.this$0._decodedPathInContext;
                        case "jakarta.servlet.include.request_uri" -> {
                            if (this.this$0._uri == null) {
                                yield null;
                            }
                            yield this.this$0._uri.getPath();
                        }
                        case "jakarta.servlet.include.context_path" -> this.this$0._targetContext.getContextPath();
                        case "jakarta.servlet.include.query_string" -> {
                            if (this.this$0._uri == null) {
                                yield null;
                            }
                            yield this.this$0._uri.getQuery();
                        }
                        case "org.eclipse.jetty.CrossContextDispatch" -> DispatcherType.INCLUDE.toString();
                        case CrossContextDispatcher.ORIGINAL_URI -> httpServletRequest.getRequestURI();
                        case CrossContextDispatcher.ORIGINAL_QUERY_STRING -> httpServletRequest.getQueryString();
                        case CrossContextDispatcher.ORIGINAL_SERVLET_MAPPING -> httpServletRequest.getHttpServletMapping();
                        case CrossContextDispatcher.ORIGINAL_CONTEXT_PATH -> httpServletRequest.getContextPath();
                        default -> httpServletRequest.getAttribute(name);
                    };
                }

                protected Set<String> getSyntheticNameSet() {
                    return ATTRIBUTES;
                }

                public Object setAttribute(String name, Object attribute) {
                    if (name == null) {
                        return null;
                    }
                    if (((String)name).startsWith(CrossContextDispatcher.FOREIGN_SERVLET_PACKAGE)) {
                        name = "jakarta.servlet." + ((String)name).substring(CrossContextDispatcher.FOREIGN_SERVLET_PACKAGE.length());
                    }
                    return super.setAttribute((String)name, attribute);
                }
            });
            this._baseRequest = request;
        }

        @Override
        public HttpURI getHttpURI() {
            return CrossContextDispatcher.this._uri;
        }

        @Override
        public Object getAttribute(String name) {
            if (MultiPart.Parser.class.getName().equals(name)) {
                return this._baseRequest.getAttribute(name);
            }
            return super.getAttribute(name);
        }
    }

    private class IncludeResponse
    extends ServletCoreResponse {
        public IncludeResponse(ServletCoreRequest servletCoreRequest, HttpServletResponse httpServletResponse, Response baseResponse, org.eclipse.jetty.server.Response coreResponse) {
            super(servletCoreRequest, httpServletResponse, baseResponse, coreResponse, true);
        }
    }
}

