/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.BookmarkList;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class BookmarkSelection
implements DownloadSelection {
    private Bounds currentArea;
    private BookmarkList bookmarks;
    private DownloadDialog parent;
    private final JMultilineLabel lblCurrentDownloadArea = new JMultilineLabel("");
    private final JosmTextArea bboxDisplay = new JosmTextArea();
    private final AddAction actAdd = new AddAction();

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        RemoveAction removeAction = new RemoveAction();
        this.bookmarks.addListSelectionListener(removeAction);
        pnl.add((Component)new JButton(removeAction), gc);
        gc.gridy = 1;
        RenameAction renameAction = new RenameAction();
        this.bookmarks.addListSelectionListener(renameAction);
        pnl.add((Component)new JButton(renameAction), gc);
        gc.gridy = 2;
        RefreshAction refreshAction = new RefreshAction();
        pnl.add((Component)new JButton(refreshAction), gc);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridy = 3;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildDownloadAreaAddPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.insets = new Insets(5, 5, 5, 5);
        pnl.add((Component)this.lblCurrentDownloadArea, gc);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.bboxDisplay.setEditable(false);
        this.bboxDisplay.setBackground(pnl.getBackground());
        this.bboxDisplay.addFocusListener(new BoundingBoxSelection.SelectAllOnFocusHandler(this.bboxDisplay));
        pnl.add((Component)this.bboxDisplay, gc);
        gc.anchor = 12;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 5);
        pnl.add((Component)new JButton(this.actAdd), gc);
        return pnl;
    }

    @Override
    public void addGui(DownloadDialog gui) {
        JPanel dlg = new JPanel(new GridBagLayout());
        if (gui != null) {
            gui.addDownloadAreaSelector(dlg, I18n.tr("Bookmarks", new Object[0]));
        }
        GridBagConstraints gc = new GridBagConstraints();
        this.bookmarks = new BookmarkList();
        this.bookmarks.getSelectionModel().addListSelectionListener(e -> {
            BookmarkList.Bookmark b = (BookmarkList.Bookmark)this.bookmarks.getSelectedValue();
            if (b != null && gui != null) {
                gui.boundingBoxChanged(b.getArea(), this);
            }
        });
        this.bookmarks.addMouseListener(new DoubleClickAdapter());
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        dlg.add((Component)this.buildDownloadAreaAddPanel(), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        dlg.add((Component)this.buildButtonPanel(), gc);
        gc.gridwidth = 1;
        gc.gridx = 1;
        gc.gridy = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        dlg.add((Component)new JScrollPane(this.bookmarks), gc);
        this.parent = gui;
    }

    protected void updateDownloadAreaLabel() {
        if (this.currentArea == null) {
            this.lblCurrentDownloadArea.setText(I18n.tr("<html>There is currently no download area selected.</html>", new Object[0]));
        } else {
            this.lblCurrentDownloadArea.setText(I18n.tr("<html><strong>Current download area</strong> (minlon, minlat, maxlon, maxlat): </html>", new Object[0]));
            this.bboxDisplay.setText(this.currentArea.toBBox().toStringCSV(","));
        }
    }

    @Override
    public void setDownloadArea(Bounds area) {
        if (area == null) {
            return;
        }
        this.currentArea = area;
        this.bookmarks.clearSelection();
        this.updateDownloadAreaLabel();
        this.actAdd.setEnabled(true);
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            this.putValue("Name", I18n.tr("Create bookmark", new Object[0]));
            new ImageProvider("dialogs", "bookmark-new").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Add a bookmark for the currently selected download area", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BookmarkSelection.this.currentArea == null) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Currently, there is no download area selected. Please select an area first.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            BookmarkList.Bookmark b = new BookmarkList.Bookmark();
            b.setName(JOptionPane.showInputDialog(MainApplication.getMainFrame(), I18n.tr("Please enter a name for the bookmarked download area.", new Object[0]), I18n.tr("Name of location", new Object[0]), 3));
            b.setArea(BookmarkSelection.this.currentArea);
            if (!Utils.isEmpty(b.getName())) {
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).addElement(b);
                BookmarkSelection.this.bookmarks.save();
            }
        }
    }

    class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveAction() {
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Remove the currently selected bookmarks", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List sels = BookmarkSelection.this.bookmarks.getSelectedValuesList();
            if (Utils.isEmpty(sels)) {
                return;
            }
            for (Object sel : sels) {
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).removeElement(sel);
            }
            BookmarkSelection.this.bookmarks.save();
        }

        protected final void updateEnabledState() {
            this.setEnabled(BookmarkSelection.this.bookmarks.getSelectedIndices().length > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class RenameAction
    extends AbstractAction
    implements ListSelectionListener {
        RenameAction() {
            new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Rename the currently selected bookmark", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List sels = BookmarkSelection.this.bookmarks.getSelectedValuesList();
            if (sels == null || sels.size() != 1) {
                return;
            }
            BookmarkList.Bookmark b = (BookmarkList.Bookmark)sels.get(0);
            Object value = JOptionPane.showInputDialog(MainApplication.getMainFrame(), I18n.tr("Please enter a name for the bookmarked download area.", new Object[0]), I18n.tr("Name of location", new Object[0]), 3, null, null, b.getName());
            if (value != null) {
                b.setName(value.toString());
                BookmarkSelection.this.bookmarks.save();
                BookmarkSelection.this.bookmarks.repaint();
            }
        }

        protected final void updateEnabledState() {
            this.setEnabled(BookmarkSelection.this.bookmarks.getSelectedIndices().length == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            new ImageProvider("dialogs/changeset", "downloadchangeset").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Download bookmarks for my {0} last changesets", BookmarkList.MAX_CHANGESET_BOOKMARKS.get()));
            this.setEnabled(!UserIdentityManager.getInstance().isAnonymous());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkSelection.this.bookmarks.refreshChangesetBookmarks();
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() != 2) {
                return;
            }
            int idx = BookmarkSelection.this.bookmarks.locationToIndex(e.getPoint());
            if (idx < 0 || idx >= BookmarkSelection.this.bookmarks.getModel().getSize()) {
                return;
            }
            BookmarkList.Bookmark b = (BookmarkList.Bookmark)BookmarkSelection.this.bookmarks.getModel().getElementAt(idx);
            if (b != null) {
                BookmarkSelection.this.parent.startDownload(b.getArea());
            }
        }
    }
}

