/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetQueryTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class BookmarkList
extends JList<Bookmark> {
    public static final IntegerProperty MAX_CHANGESET_BOOKMARKS = new IntegerProperty("bookmarks.changesets.max-entries", 15);

    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    public final void load() {
        UserInfo userInfo;
        int n;
        List<List<String>> args;
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.removeAllElements();
        UserIdentityManager im = UserIdentityManager.getInstance();
        if (im.isFullyIdentified()) {
            try {
                model.addElement(new HomeLocationBookmark());
            }
            catch (IllegalStateException e) {
                Logging.info(e.getMessage());
                Logging.trace(e);
            }
        }
        if ((args = Config.getPref().getListOfLists("bookmarks", null)) != null) {
            LinkedList<Bookmark> bookmarks = new LinkedList<Bookmark>();
            for (Collection collection : args) {
                try {
                    bookmarks.add(new Bookmark(collection));
                }
                catch (IllegalArgumentException e) {
                    Logging.log(Logging.LEVEL_ERROR, I18n.tr("Error reading bookmark entry: %s", e.getMessage()), e);
                }
            }
            Collections.sort(bookmarks);
            for (Bookmark bookmark : bookmarks) {
                model.addElement(bookmark);
            }
        }
        if ((n = MAX_CHANGESET_BOOKMARKS.get().intValue()) > 0 && !im.isAnonymous() && (userInfo = im.getUserInfo()) != null) {
            ChangesetCacheManager changesetCacheManager = ChangesetCacheManager.getInstance();
            int userId = userInfo.getId();
            int found = 0;
            for (int i = 0; i < changesetCacheManager.getModel().getRowCount() && found < n; ++i) {
                Changeset cs = changesetCacheManager.getModel().getValueAt(i, 0);
                if (cs.getUser().getId() != (long)userId || cs.getBounds() == null) continue;
                model.addElement(new ChangesetBookmark(cs));
                ++found;
            }
        }
    }

    public final void save() {
        LinkedList<List<String>> coll = new LinkedList<List<String>>();
        for (Object o : ((DefaultListModel)this.getModel()).toArray()) {
            if (o instanceof HomeLocationBookmark || o instanceof ChangesetBookmark) continue;
            String[] array = new String[5];
            Bookmark b = (Bookmark)o;
            array[0] = b.getName();
            Bounds area = b.getArea();
            array[1] = String.valueOf(area.getMinLat());
            array[2] = String.valueOf(area.getMinLon());
            array[3] = String.valueOf(area.getMaxLat());
            array[4] = String.valueOf(area.getMaxLon());
            coll.add(Arrays.asList(array));
        }
        Config.getPref().putListOfLists("bookmarks", coll);
    }

    public void refreshChangesetBookmarks() {
        int n = MAX_CHANGESET_BOOKMARKS.get();
        if (n > 0) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            for (int i = model.getSize() - 1; i >= 0; --i) {
                if (!(model.get(i) instanceof ChangesetBookmark)) continue;
                model.remove(i);
            }
            ChangesetQuery query = ChangesetQuery.forCurrentUser();
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetQueryTask task = new ChangesetQueryTask(this, query);
                ChangesetCacheManager.getInstance().runDownloadTask(task);
                MainApplication.worker.submit(() -> {
                    if (task.isCanceled() || task.isFailed()) {
                        return;
                    }
                    GuiHelper.runInEDT(() -> ((Set)task.getDownloadedData()).stream().filter(cs -> cs.getBounds() != null).sorted(Comparator.reverseOrder()).limit(n).forEachOrdered(cs -> model.addElement(new ChangesetBookmark((Changeset)cs))));
                });
            }
        }
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer<Bookmark> {
        BookmarkCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark b) {
            Bounds area = b.getArea();
            StringBuilder sb = new StringBuilder(128);
            if (area != null) {
                sb.append("<html>min[latitude,longitude]=<strong>[").append(area.getMinLat()).append(',').append(area.getMinLon()).append("]</strong><br>max[latitude,longitude]=<strong>[").append(area.getMaxLat()).append(',').append(area.getMaxLon()).append("]</strong></html>");
            }
            return sb.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Bookmark> list, Bookmark value, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderColor(isSelected);
            this.setIcon(value.getIcon());
            this.setText(value.getName());
            this.setToolTipText(this.buildToolTipText(value));
            return this;
        }
    }

    public static class HomeLocationBookmark
    extends Bookmark {
        public HomeLocationBookmark() {
            this.setName(I18n.tr("Home location", new Object[0]));
            this.setIcon(ImageProvider.get("help", "home", ImageProvider.ImageSizes.SMALLICON));
            UserInfo info = UserIdentityManager.getInstance().getUserInfo();
            if (info == null) {
                throw new IllegalStateException("User not identified");
            }
            LatLon home = info.getHome();
            if (home == null) {
                throw new IllegalStateException("User home location not set");
            }
            int zoom = info.getHomeZoom();
            if (zoom <= 3) {
                zoom = 15;
            }
            Projection mercator = Projections.getProjectionByCode("EPSG:3857");
            this.setArea(MapViewState.createDefaultState(430, 400).usingProjection(mercator).usingScale(Selector.GeneralSelector.level2scale(zoom) / 100.0).usingCenter(mercator.latlon2eastNorth(home)).getViewArea().getLatLonBoundsBox());
        }
    }

    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;
        private ImageIcon icon;

        public Bookmark(Collection<String> list) {
            ArrayList<String> array = new ArrayList<String>(list);
            if (array.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark", new Object[0]));
            }
            this.icon = Bookmark.getDefaultIcon();
            this.name = (String)array.get(0);
            this.area = new Bounds(Double.parseDouble((String)array.get(1)), Double.parseDouble((String)array.get(2)), Double.parseDouble((String)array.get(3)), Double.parseDouble((String)array.get(4)));
        }

        public Bookmark() {
            this(null, null);
        }

        public Bookmark(Bounds area) {
            this(null, area);
        }

        protected Bookmark(String name, Bounds area) {
            this.icon = Bookmark.getDefaultIcon();
            this.name = name;
            this.area = area;
        }

        static ImageIcon getDefaultIcon() {
            return ImageProvider.get("dialogs", "bookmark", ImageProvider.ImageSizes.SMALLICON);
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark b) {
            return this.name.toLowerCase(Locale.ENGLISH).compareTo(b.name.toLowerCase(Locale.ENGLISH));
        }

        public int hashCode() {
            return Objects.hash(this.name, this.area);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bookmark bookmark = (Bookmark)obj;
            return Objects.equals(this.name, bookmark.name) && Objects.equals(this.area, bookmark.area);
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setArea(Bounds area) {
            this.area = area;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }
    }

    public static class ChangesetBookmark
    extends Bookmark {
        public ChangesetBookmark(Changeset cs) {
            this.setName(String.format("%d - %tF - %s", cs.getId(), cs.getCreatedAt().atZone(ZoneId.systemDefault()), cs.getComment()));
            this.setIcon(ImageProvider.get("data", "changeset", ImageProvider.ImageSizes.SMALLICON));
            this.setArea(cs.getBounds());
        }
    }
}

