/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class RelationToChildReference {
    private final Relation parent;
    private final int position;
    private final String role;
    private final OsmPrimitive child;

    public static Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive child) {
        Set parents = child.referrers(Relation.class).collect(Collectors.toSet());
        return parents.stream().flatMap(parent1 -> IntStream.range(0, parent1.getMembersCount()).filter(i -> parent1.getMember(i).refersTo(child)).mapToObj(i -> new RelationToChildReference((Relation)parent1, i, parent1.getMember(i)))).collect(Collectors.toSet());
    }

    public static Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> children) {
        return children.stream().flatMap(child -> RelationToChildReference.getRelationToChildReferences(child).stream()).collect(Collectors.toSet());
    }

    public RelationToChildReference(Relation parent, int position, String role, OsmPrimitive child) {
        this.parent = parent;
        this.position = position;
        this.role = role;
        this.child = child;
    }

    public RelationToChildReference(Relation parent, int position, RelationMember member) {
        this(parent, position, member.getRole(), member.getMember());
    }

    public Relation getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitive getChild() {
        return this.child;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationToChildReference that = (RelationToChildReference)obj;
        return this.position == that.position && Objects.equals(this.parent, that.parent) && Objects.equals(this.role, that.role) && Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.position, this.role, this.child);
    }
}

