/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import org.eclipse.swt.graphics.Rectangle;

public final class LineClipper {
    private static final int DOWN = 8;
    private static final int UP = 4;
    private static final int RIGHT = 2;
    private static final int LEFT = 1;
    private static final int INSIDE = 0;

    private LineClipper() {
    }

    public static Rectangle clip(Rectangle bounds, int x0, int y0, int x1, int y1) {
        int maxLoops = 3;
        int quadrant0 = LineClipper.computeQuadrant(x0, y0, bounds);
        int quadrant1 = LineClipper.computeQuadrant(x1, y1, bounds);
        if (quadrant0 == 0 && quadrant1 == 0) {
            return new Rectangle(x0, y0, x1 - x0, y1 - y0);
        }
        if (LineClipper.guaranteedOut(quadrant0, quadrant1) || bounds.width == 0 || bounds.height == 0) {
            return null;
        }
        long deltaY = (long)y1 - (long)y0;
        long deltaX = (long)x1 - (long)x0;
        double slope = (double)deltaY / (double)deltaX;
        double antiSlope = (double)deltaX / (double)deltaY;
        int newX0 = x0;
        int newY0 = y0;
        int newX1 = x1;
        int newY1 = y1;
        int i = 0;
        while (i < maxLoops && quadrant0 != 0) {
            if (LineClipper.guaranteedOut(quadrant0, quadrant1)) {
                return null;
            }
            if ((quadrant0 & 4) != 0) {
                newX0 = (int)((double)newX0 + antiSlope * (double)(bounds.y + bounds.height - newY0));
                newY0 = bounds.height + bounds.y;
            } else if ((quadrant0 & 8) != 0) {
                newX0 = (int)((double)newX0 + antiSlope * (double)(bounds.y - newY0));
                newY0 = bounds.y;
            } else if ((quadrant0 & 2) != 0) {
                newY0 = (int)((double)newY0 + slope * (double)(bounds.x + bounds.width - newX0));
                newX0 = bounds.x + bounds.width;
            } else {
                newY0 = (int)((double)newY0 + slope * (double)(bounds.x - newX0));
                newX0 = bounds.x;
            }
            quadrant0 = LineClipper.computeQuadrant(newX0, newY0, bounds);
            ++i;
        }
        i = 0;
        while (i < maxLoops && quadrant1 != 0) {
            if (LineClipper.guaranteedOut(quadrant0, quadrant1)) {
                return null;
            }
            if ((quadrant1 & 4) != 0) {
                newX1 = (int)((double)newX1 + antiSlope * (double)(bounds.y + bounds.height - newY1));
                newY1 = bounds.height + bounds.y;
            } else if ((quadrant1 & 8) != 0) {
                newX1 = (int)((double)newX1 + antiSlope * (double)(bounds.y - newY1));
                newY1 = bounds.y;
            } else if ((quadrant1 & 2) != 0) {
                newY1 = (int)((double)newY1 + slope * (double)(bounds.x + bounds.width - newX1));
                newX1 = bounds.x + bounds.width;
            } else {
                newY1 = (int)((double)newY1 + slope * (double)(bounds.x - newX1));
                newX1 = bounds.x;
            }
            quadrant1 = LineClipper.computeQuadrant(newX1, newY1, bounds);
            ++i;
        }
        return LineClipper.guaranteedOut(quadrant0, quadrant1) ? null : new Rectangle(newX0, newY0, newX1 - newX0, newY1 - newY0);
    }

    private static boolean guaranteedOut(int quadrant0, int quadrant1) {
        return (quadrant0 & quadrant1) != 0;
    }

    private static int computeQuadrant(int x, int y, Rectangle bounds) {
        int retCode = 0;
        if (x < bounds.x) {
            retCode |= 1;
        } else if (x > bounds.x + bounds.width) {
            retCode |= 2;
        }
        if (y < bounds.y) {
            retCode |= 8;
        } else if (y > bounds.y + bounds.height) {
            retCode |= 4;
        }
        return retCode;
    }
}

