/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.encoding;

import java.nio.ByteBuffer;
import java.util.PrimitiveIterator;
import java.util.Random;
import org.eclipse.tracecompass.datastore.core.encoding.HTVarInt;
import org.junit.Assert;
import org.junit.Test;

public class HTVarIntTest {
    private static final int LOOP_COUNT = 65535;

    @Test
    public void readWriteLongTestUnsigned() {
        ByteBuffer bb = ByteBuffer.allocate(128);
        Random r = new Random();
        r.setSeed(0L);
        PrimitiveIterator.OfLong randomStream = r.longs(0L, Long.MAX_VALUE).iterator();
        int i = 1;
        while (i < 8) {
            int l = 0;
            while (l < 65535) {
                long value = randomStream.nextLong() >> i * 8;
                HTVarInt.writeLong((ByteBuffer)bb, (long)value);
                bb.position(0);
                Assert.assertEquals((String)(l + " " + Long.toHexString(value)), (long)value, (long)HTVarInt.readLong((ByteBuffer)bb));
                bb.position(0);
                ++l;
            }
            ++i;
        }
    }

    @Test
    public void readWriteLongTest() {
        ByteBuffer bb = ByteBuffer.allocate(128);
        Random r = new Random();
        r.setSeed(0L);
        int i = 1;
        while (i < 8) {
            int l = 0;
            while (l < 65535) {
                long value = r.nextLong() >> i * 8;
                HTVarInt.writeLong((ByteBuffer)bb, (long)value);
                bb.position(0);
                Assert.assertEquals((String)(l + " " + Long.toHexString(value)), (long)value, (long)HTVarInt.readLong((ByteBuffer)bb));
                bb.position(0);
                ++l;
            }
            ++i;
        }
    }
}

