/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.condition;

import org.eclipse.tracecompass.internal.datastore.core.condition.ContinuousTimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.junit.Assert;
import org.junit.Test;

public class ContinuousTimeRangeConditionTest {
    private static final long LOW = 0L;
    private static final long HIGH = 10L;
    private static final ContinuousTimeRangeCondition CONDITION = new ContinuousTimeRangeCondition(0L, 10L);

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor() {
        new ContinuousTimeRangeCondition(10L, 0L);
    }

    @Test
    public void testBounds() {
        long low = CONDITION.min();
        Assert.assertEquals((long)0L, (long)low);
        long high = CONDITION.max();
        Assert.assertEquals((long)10L, (long)high);
    }

    @Test
    public void testPredicate() {
        Assert.assertFalse((boolean)CONDITION.test(-5L));
        Assert.assertTrue((boolean)CONDITION.test(0L));
        Assert.assertTrue((boolean)CONDITION.test(5L));
        Assert.assertTrue((boolean)CONDITION.test(10L));
        Assert.assertFalse((boolean)CONDITION.test(15L));
    }

    @Test
    public void testIntersects() {
        Assert.assertFalse((boolean)CONDITION.intersects(Integer.MIN_VALUE, -1L));
        Assert.assertTrue((boolean)CONDITION.intersects(-5L, 5L));
        Assert.assertTrue((boolean)CONDITION.intersects(2L, 8L));
        Assert.assertTrue((boolean)CONDITION.intersects(5L, 15L));
        Assert.assertFalse((boolean)CONDITION.intersects(11L, Integer.MAX_VALUE));
    }

    @Test
    public void testSubCondition() {
        TimeRangeCondition sub = CONDITION.subCondition(-5L, 8L);
        Assert.assertNotNull((Object)sub);
        Assert.assertEquals(ContinuousTimeRangeCondition.class, sub.getClass());
        long low = sub.min();
        long high = sub.max();
        Assert.assertEquals((long)0L, (long)low);
        Assert.assertEquals((long)8L, (long)high);
        sub = CONDITION.subCondition(11L, 20L);
        Assert.assertNull((Object)sub);
        sub = CONDITION.subCondition(-10L, -1L);
        Assert.assertNull((Object)sub);
    }
}

