/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.ctf.core.utils.GenericReadOnlyListIterator;

public class SparseList<E>
implements List<E> {
    private final Map<Integer, @NonNull E> fInnerElements = new HashMap<Integer, E>();
    private int fSize = 0;

    public SparseList(List<E> events) {
        this.ensureSize(events.size());
        int i = 0;
        while (i < events.size()) {
            E element = events.get(i);
            if (element != null) {
                this.set(i, element);
            }
            ++i;
        }
    }

    public SparseList() {
    }

    @Override
    public int size() {
        return this.fSize;
    }

    @Override
    public boolean isEmpty() {
        return this.fSize == 0;
    }

    @Override
    public boolean contains(Object o) {
        return o == null ? this.size() > this.fInnerElements.size() : this.fInnerElements.containsValue(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new GenericReadOnlyListIterator(this, 0);
    }

    @Override
    public Object[] toArray() {
        int size = this.fInnerElements.size();
        Object[] retVal = new Object[size];
        Iterator<E> iterator = this.iterator();
        int i = 0;
        while (i < size) {
            Object next = null;
            while (iterator.hasNext() && next == null) {
                next = iterator.next();
            }
            retVal[i] = next;
            ++i;
        }
        return retVal;
    }

    @Override
    public <T> T[] toArray(T[] newArray) {
        Class<?> componentType = newArray.getClass().getComponentType();
        Object[] returnArray = newArray;
        int size = this.fInnerElements.size();
        if (returnArray.length < size) {
            returnArray = (Object[])Array.newInstance(componentType, size);
        }
        int i = size;
        while (i < returnArray.length) {
            returnArray[i] = null;
            ++i;
        }
        Iterator<E> iterator = this.iterator();
        int i2 = 0;
        while (i2 < size) {
            Object next = null;
            while (iterator.hasNext() && next == null) {
                next = iterator.next();
            }
            returnArray[i2] = next;
            ++i2;
        }
        return returnArray;
    }

    @Override
    public boolean add(E e) {
        if (e != null) {
            this.fInnerElements.put(this.fSize, e);
        }
        ++this.fSize;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Collection nonNullCollection = c;
        if (nonNullCollection.contains(null)) {
            if (!this.contains(null)) {
                return false;
            }
            nonNullCollection = c.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.fInnerElements.values().containsAll(nonNullCollection);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int key = this.fSize;
        this.fSize += c.size();
        for (E event : c) {
            this.set(key, event);
            ++key;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Tried to access index " + index + " Sparse list size " + this.fSize);
        }
        return this.fInnerElements.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Tried to add to index " + index + " Sparse list size " + this.fSize);
        }
        if (element != null) {
            return this.fInnerElements.put(index, element);
        }
        return this.fInnerElements.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o == null && this.contains(null)) {
            int i = 0;
            while (i < this.size()) {
                if (!this.fInnerElements.containsKey(i)) {
                    return i;
                }
                ++i;
            }
        }
        int first = Integer.MAX_VALUE;
        for (Map.Entry<Integer, E> entry : this.fInnerElements.entrySet()) {
            if (!Objects.equals(entry.getValue(), o)) continue;
            first = Math.min(entry.getKey(), first);
        }
        return first == Integer.MAX_VALUE ? -1 : first;
    }

    @Override
    public int lastIndexOf(Object o) {
        int last = -1;
        if (o == null && this.contains(null)) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (!this.fInnerElements.containsKey(i)) {
                    return i;
                }
                --i;
            }
        }
        for (Map.Entry<Integer, E> entry : this.fInnerElements.entrySet()) {
            if (!Objects.equals(entry.getValue(), o)) continue;
            last = Math.max(last, entry.getKey());
        }
        return last;
    }

    @Override
    public void clear() {
        this.fInnerElements.clear();
        this.fSize = 0;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.fSize, 16);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new GenericReadOnlyListIterator(this, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new GenericReadOnlyListIterator(this, index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.size()) {
            E element = this.get(i);
            if (element != null) {
                sb.append(i).append(':').append(String.valueOf(element));
                if (i < this.size() - 1) {
                    sb.append(',').append(' ');
                }
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public void ensureSize(int requestedSize) {
        this.fSize = Math.max(this.fSize, requestedSize);
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("No add(int, E) in " + this.getClass().getName());
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("No remove(int) in " + this.getClass().getName());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("No remove(Object) in " + this.getClass().getName());
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("No addAll(int, Collection<? extends E>) in " + this.getClass().getName());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("No removeAll(Collection<?>) in " + this.getClass().getName());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("No retainAll(Collection<?> in " + this.getClass().getName());
    }

    @Override
    public @NonNull List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("No subList(int, int) in " + this.getClass().getName());
    }
}

