/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.tests.stubs.segmentstore.StubSegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreDensityDataProviderTest {
    private static ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> fDataProvider;
    private static ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> fDataProviderNullSegments;
    private static final @NonNull TmfXmlTraceStub fTrace;
    private static final String ID = "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore";

    static {
        fTrace = new TmfXmlTraceStubNs();
    }

    @BeforeClass
    public static void init() throws TmfAnalysisException {
        StubSegmentStoreProvider fixture = SegmentStoreDensityDataProviderTest.getValidSegment((ITmfTrace)fTrace);
        fDataProvider = new SegmentStoreDensityDataProvider((ITmfTrace)fTrace, (ISegmentStoreProvider)fixture, ID);
        StubSegmentStoreProvider fixtureNull = SegmentStoreDensityDataProviderTest.getValidNullSegment((ITmfTrace)fTrace);
        fDataProviderNullSegments = new SegmentStoreDensityDataProvider((ITmfTrace)fTrace, (ISegmentStoreProvider)fixtureNull, ID);
    }

    @AfterClass
    public static void clean() {
        fTrace.dispose();
    }

    private static @NonNull StubSegmentStoreProvider getValidSegment(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        StubSegmentStoreProvider fixture = new StubSegmentStoreProvider(false);
        fixture.setTrace(trace);
        fixture.schedule();
        fixture.waitForCompletion();
        return fixture;
    }

    private static @NonNull StubSegmentStoreProvider getValidNullSegment(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        StubSegmentStoreProvider fixture = new StubSegmentStoreProvider(true);
        fixture.setTrace(trace);
        fixture.schedule();
        fixture.waitForCompletion();
        return fixture;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSuccessfulFetchXY() {
        @NonNull @NonNull TmfModelResponse treeResponse = fDataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, 100L, 100)), null);
        Assert.assertNotNull((Object)treeResponse);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        List itemIds = treeModel.getEntries().stream().map(TmfTreeDataModel::getId).collect(Collectors.toList());
        HashMap<String, List<Long>> fetchParameters = new HashMap<String, List<Long>>();
        fetchParameters.put("requested_timerange", Arrays.asList(1000L, 5000L, 100L));
        fetchParameters.put("requested_items", itemIds);
        @NonNull TmfModelResponse response = fDataProvider.fetchXY(fetchParameters, null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        ITmfXyModel responseModel = (ITmfXyModel)response.getModel();
        Assert.assertNotNull((Object)responseModel);
        Assert.assertNotNull((Object)responseModel.getSeriesData());
        if (!responseModel.getSeriesData().isEmpty()) {
            ISeriesModel seriesModel = (ISeriesModel)responseModel.getSeriesData().iterator().next();
            Assert.assertNotNull((Object)seriesModel);
            Assert.assertNotNull((Object)seriesModel.getData());
            Assert.assertEquals((long)100L, (long)seriesModel.getData().length);
            Assert.assertEquals((Object)ISeriesModel.DisplayType.BAR, (Object)seriesModel.getDisplayType());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFailedResponseNullFilter() {
        HashMap emptyParameters = new HashMap();
        @NonNull TmfModelResponse response = fDataProvider.fetchXY(emptyParameters, null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)ITmfResponse.Status.FAILED, (Object)response.getStatus());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCancelledResponseMonitor() {
        @NonNull @NonNull TmfModelResponse treeResponse = fDataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, 100L, 100)), null);
        Assert.assertNotNull((Object)treeResponse);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        List itemIds = treeModel.getEntries().stream().map(TmfTreeDataModel::getId).collect(Collectors.toList());
        HashMap<String, List<Long>> fetchParameters = new HashMap<String, List<Long>>();
        fetchParameters.put("requested_timerange", Arrays.asList(1000L, 5000L, 100L));
        fetchParameters.put("requested_items", itemIds);
        NullProgressMonitor cancelledMonitor = new NullProgressMonitor();
        cancelledMonitor.setCanceled(true);
        @NonNull TmfModelResponse response = fDataProvider.fetchXY(fetchParameters, (IProgressMonitor)cancelledMonitor);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)ITmfResponse.Status.CANCELLED, (Object)response.getStatus());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testNullSegmentsProvider() {
        @NonNull @NonNull TmfModelResponse treeResponse = fDataProviderNullSegments.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, 100L, 100)), null);
        Assert.assertNotNull((Object)treeResponse);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        List itemIds = treeModel.getEntries().stream().map(TmfTreeDataModel::getId).collect(Collectors.toList());
        HashMap<String, List<Long>> parameters = new HashMap<String, List<Long>>();
        parameters.put("requested_timerange", Arrays.asList(1000L, 5000L, 100L));
        parameters.put("requested_items", itemIds);
        @NonNull TmfModelResponse response = fDataProviderNullSegments.fetchXY(parameters, null);
        Assert.assertNotNull((Object)response);
        ITmfXyModel responseModel = (ITmfXyModel)response.getModel();
        if (responseModel != null && !responseModel.getSeriesData().isEmpty()) {
            ISeriesModel seriesModel = (ISeriesModel)responseModel.getSeriesData().iterator().next();
            Assert.assertNotNull((Object)seriesModel);
            Assert.assertNotNull((Object)seriesModel.getData());
            Assert.assertEquals((long)100L, (long)seriesModel.getData().length);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTree() {
        TimeQueryFilter timeQueryFilter = new TimeQueryFilter(0L, 100L, 100);
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)timeQueryFilter), null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
    }

    @Test
    public void testID() {
        String expectedId = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProvider:org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore";
        Assert.assertEquals((Object)expectedId, (Object)fDataProvider.getId());
    }
}

