/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem;

import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class ExperimentStateSystemModuleTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    public static final String MODULE_SS = "org.eclipse.linuxtools.tmf.core.tests.experiment";
    private TmfStateSystemAnalysisModule fModule;
    private TmfExperiment fExperiment;

    @Before
    public void setupTraces() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        TmfSignalManager.deregister((Object)trace);
        ITmfTrace trace2 = TmfTestTrace.A_TEST_10K2.getTrace();
        TmfSignalManager.deregister((Object)trace2);
        ITmfTrace[] traces = new ITmfTrace[]{trace, trace2};
        this.fExperiment = new TmfExperimentStub("Test", traces, 1000);
        this.fExperiment.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)this.fExperiment, null));
        this.fModule = (TmfStateSystemAnalysisModule)this.fExperiment.getAnalysisModule(MODULE_SS);
        Assert.assertNotNull((Object)this.fModule);
    }

    @After
    public void cleanupTraces() {
        this.fExperiment.dispose();
    }

    @Test
    public void testSsModule() {
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNull((Object)ss);
        this.fModule.schedule();
        if (this.fModule.waitForCompletion()) {
            ss = this.fModule.getStateSystem();
            Assert.assertNotNull((Object)ss);
            try {
                int quark = ss.getQuarkAbsolute(new String[]{"Traces"});
                ITmfStateInterval interval = ss.querySingleState(ss.getCurrentEndTime(), quark);
                Assert.assertEquals((long)2L, (long)interval.getStateValue().unboxInt());
            }
            catch (AttributeNotFoundException e) {
                Assert.fail((String)"The quark for number of traces does not exist");
            }
            catch (StateSystemDisposedException e) {
                Assert.fail((String)"Error: state system disposed");
            }
        } else {
            Assert.fail((String)"Module did not complete properly");
        }
    }

    @Test
    public void testInitialization() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        this.fModule.schedule();
        Assert.assertTrue((String)"Initialization succeeded", (boolean)this.fModule.waitForInitialization());
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }
}

