/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.stubs.backend;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.statesystem.core.tests.stubs.backend.HistoryTreeClassicStub;

public class HistoryTreeBackendStub
extends HistoryTreeBackend {
    private static HistoryTreeType HT_TYPE = HistoryTreeType.CLASSIC;

    public static void setTreeType(HistoryTreeType htType) {
        HT_TYPE = htType;
    }

    public HistoryTreeBackendStub(String ssid, File newStateFile, int providerVersion, long startTime, int blockSize, int maxChildren) throws IOException {
        super(ssid, newStateFile, providerVersion, startTime, blockSize, maxChildren);
    }

    public HistoryTreeBackendStub(String ssid, File existingStateFile, int providerVersion) throws IOException {
        super(ssid, existingStateFile, providerVersion);
    }

    protected IHistoryTree initializeSHT(HTConfig conf) throws IOException {
        switch (HT_TYPE) {
            case CLASSIC: {
                return new HistoryTreeClassicStub(conf);
            }
        }
        return new HistoryTreeClassicStub(conf);
    }

    protected IHistoryTree initializeSHT(File existingStateFile, int providerVersion) throws IOException {
        switch (HT_TYPE) {
            case CLASSIC: {
                return new HistoryTreeClassicStub(existingStateFile, providerVersion);
            }
        }
        return new HistoryTreeClassicStub(existingStateFile, providerVersion);
    }

    public HistoryTreeClassicStub getHistoryTree() {
        return (HistoryTreeClassicStub)super.getSHT();
    }

    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false, -1L);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals, long ts) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.getSHT().toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.getHistoryTree().debugPrintFullTree(writer, printIntervals, ts);
    }

    public static enum HistoryTreeType {
        CLASSIC;

    }
}

