/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics.StubSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.Assert;
import org.junit.Test;

public class AbstractStatsAnalysisTest {
    @Test
    public void testExecuteNoTrace() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        Assert.assertFalse((boolean)fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor()));
        fixture.dispose();
    }

    @Test
    public void testExecuteNoDepend() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        fixture.setTrace((ITmfTrace)trace);
        Assert.assertFalse((boolean)fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor()));
        trace.dispose();
        fixture.dispose();
    }

    @Test
    public void testExecute() throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        fixture.setTrace((ITmfTrace)trace);
        fixture.getDependentAnalyses();
        Assert.assertTrue((boolean)fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor()));
        trace.dispose();
        fixture.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTotalStats() throws TmfAnalysisException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats((ITmfTrace)trace);
        @NonNull IStatistics totalStats = fixture.getStatsTotal();
        Assert.assertNotNull((Object)totalStats);
        Assert.assertEquals((long)65535L, (long)totalStats.getNbElements());
        trace.dispose();
        fixture.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPerTypeStats() throws TmfAnalysisException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats((ITmfTrace)trace);
        @NonNull @NonNull Map perTypeStats = fixture.getStatsPerType();
        Assert.assertNotNull((Object)perTypeStats);
        Assert.assertEquals((long)2L, (long)perTypeStats.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"odd", (Object)"even"), perTypeStats.keySet());
        @NonNull IStatistics segmentStoreStatistics = (IStatistics)perTypeStats.get("even");
        Assert.assertNotNull((Object)segmentStoreStatistics);
        Assert.assertEquals((long)32768L, (long)segmentStoreStatistics.getNbElements());
        trace.dispose();
        fixture.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPartialStats() throws TmfAnalysisException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats((ITmfTrace)trace);
        @NonNull IStatistics totalStats = fixture.getStatsForRange(100L, 1100L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)totalStats);
        Assert.assertEquals((long)1051L, (long)totalStats.getNbElements());
        trace.dispose();
        fixture.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPartialPerTypeStats() throws TmfAnalysisException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats((ITmfTrace)trace);
        @NonNull @NonNull Map perTypeStats = fixture.getStatsPerTypeForRange(100L, 1100L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)perTypeStats);
        Assert.assertEquals((long)2L, (long)perTypeStats.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"odd", (Object)"even"), perTypeStats.keySet());
        @NonNull IStatistics segmentStoreStatistics = (IStatistics)perTypeStats.get("even");
        Assert.assertNotNull((Object)segmentStoreStatistics);
        Assert.assertEquals((long)526L, (long)segmentStoreStatistics.getNbElements());
        trace.dispose();
        fixture.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testPartialPerTypeStatsCancel() throws TmfAnalysisException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        StubSegmentStatisticsAnalysis fixture = AbstractStatsAnalysisTest.getValidSegmentStats((ITmfTrace)trace);
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        @NonNull @NonNull Map perTypeStats = fixture.getStatsPerTypeForRange(100L, 1100L, (IProgressMonitor)monitor);
        Assert.assertEquals(Collections.emptyMap(), (Object)perTypeStats);
        trace.dispose();
        fixture.dispose();
    }

    private static StubSegmentStatisticsAnalysis getValidSegmentStats(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        StubSegmentStatisticsAnalysis fixture = new StubSegmentStatisticsAnalysis();
        fixture.setTrace(trace);
        fixture.getDependentAnalyses();
        fixture.executeAnalysis((IProgressMonitor)new NullProgressMonitor());
        return fixture;
    }
}

