/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs.cpd;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.cpd.CustomizePerspectiveDialog;
import org.eclipse.ui.internal.dialogs.cpd.TreeManager;

class GrayOutUnavailableLabelProvider
extends TreeManager.TreeItemLabelProvider
implements IColorProvider {
    private Display display = PlatformUI.getWorkbench().getDisplay();
    private ViewerFilter filter;
    private Set<Image> toDispose;

    public GrayOutUnavailableLabelProvider(ViewerFilter filter) {
        this.filter = filter;
        this.toDispose = new HashSet<Image>();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof CustomizePerspectiveDialog.DisplayItem && !CustomizePerspectiveDialog.isEffectivelyAvailable((CustomizePerspectiveDialog.DisplayItem)element, this.filter)) {
            return this.display.getSystemColor(18);
        }
        if (element instanceof CustomizePerspectiveDialog.ActionSet && !((CustomizePerspectiveDialog.ActionSet)element).isActive()) {
            return this.display.getSystemColor(18);
        }
        return null;
    }

    @Override
    public Image getImage(Object element) {
        CustomizePerspectiveDialog.DisplayItem item;
        Image actual = super.getImage(element);
        if (element instanceof CustomizePerspectiveDialog.DisplayItem && actual != null && !CustomizePerspectiveDialog.isEffectivelyAvailable(item = (CustomizePerspectiveDialog.DisplayItem)element, this.filter)) {
            ImageDescriptor original = ImageDescriptor.createFromImage((Image)actual);
            ImageDescriptor disable = ImageDescriptor.createWithFlags((ImageDescriptor)original, (int)1);
            Image newImage = disable.createImage();
            this.toDispose.add(newImage);
            return newImage;
        }
        return actual;
    }

    public void dispose() {
        for (Image image : this.toDispose) {
            image.dispose();
        }
        this.toDispose.clear();
        super.dispose();
    }
}

