/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class CpuFrequencyHandler
extends KernelEventHandler {
    private static final String CPU_ID_FIELD = "cpu_id";
    private static final String CPU_STATE = "state";
    private static final long FREQUENCY_MULTIPLIER = 1000L;

    public CpuFrequencyHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        Integer cpuId = (Integer)content.getFieldValue(Integer.class, new String[]{CPU_ID_FIELD});
        Long cpuState = (Long)content.getFieldValue(Long.class, new String[]{CPU_STATE});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        if (cpuId == null || cpuState == null) {
            return;
        }
        cpuState = cpuState * 1000L;
        int cpuQuark = KernelEventHandlerUtils.getCurrentCPUNode(cpuId, ss);
        int quark = ss.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Frequency"});
        ss.modifyAttribute(timestamp, (Object)cpuState, quark);
        quark = ss.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Min frequency"});
        Object currentValue = ss.queryOngoing(quark);
        Long minVal = !(currentValue instanceof Long) ? cpuState : Long.min(cpuState, (Long)currentValue);
        ss.updateOngoingState((Object)minVal, quark);
        quark = ss.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Max frequency"});
        currentValue = ss.queryOngoing(quark);
        Long maxVal = !(currentValue instanceof Long) ? cpuState : Long.max(cpuState, (Long)currentValue);
        ss.updateOngoingState((Object)maxVal, quark);
    }
}

