/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.UniqueType;
import org.eclipse.core.runtime.CoreException;

class SignatureBuilder
implements ITypeMarshalBuffer {
    private static final short NULL_TYPE = 0;
    private static final short UNSTORABLE_TYPE = 29;
    private final StringBuilder fBuffer = new StringBuilder();

    public String toString() {
        return this.fBuffer.toString();
    }

    public char[] getSignature() {
        return CharArrayUtils.extractChars(this.fBuffer);
    }

    @Override
    public void marshalBinding(IBinding binding) throws CoreException {
        if (binding instanceof ISerializableType) {
            ((ISerializableType)((Object)binding)).marshal(this);
        } else if (binding == null) {
            this.putShort((short)0);
        } else {
            this.appendSeparator();
            if (binding instanceof ICPPBinding) {
                if (binding instanceof ICPPTemplateParameter) {
                    ICPPTemplateParameter param = (ICPPTemplateParameter)binding;
                    this.fBuffer.append(param.isParameterPack() ? (char)'*' : '#');
                    this.fBuffer.append(param.getParameterID());
                } else {
                    this.fBuffer.append(ASTTypeUtil.getQualifiedName((ICPPBinding)binding));
                }
            } else {
                this.fBuffer.append(binding.getNameCharArray());
            }
        }
    }

    @Override
    public void marshalType(IType type) throws CoreException {
        if (type instanceof ISerializableType) {
            ((ISerializableType)((Object)type)).marshal(this);
        } else if (type == null) {
            this.putShort((short)0);
        } else if (type instanceof IBinding) {
            this.marshalBinding((IBinding)((Object)type));
        } else if (type instanceof UniqueType) {
            this.appendSeparator();
            this.fBuffer.append("Unique(@");
            this.fBuffer.append(Integer.toHexString(System.identityHashCode(type)));
            this.fBuffer.append(')');
        } else {
            assert (false) : "Cannot serialize " + ASTTypeUtil.getType(type) + " (" + type.getClass().getName() + ")";
            this.putShort((short)29);
        }
    }

    @Override
    public void marshalEvaluation(ICPPEvaluation eval, boolean includeValues) throws CoreException {
        if (eval == null) {
            this.putShort((short)0);
        } else {
            eval.marshal(this, includeValues);
        }
    }

    @Override
    public void marshalExecution(ICPPExecution exec, boolean includeValue) throws CoreException {
        if (exec == null) {
            this.putShort((short)0);
        } else {
            exec.marshal(this, includeValue);
        }
    }

    @Override
    public void marshalValue(IValue value) throws CoreException {
        if (value != null) {
            value.marshal(this);
        } else {
            this.putShort((short)0);
        }
    }

    @Override
    public void marshalTemplateArgument(ICPPTemplateArgument arg) throws CoreException {
        if (arg.isNonTypeValue()) {
            this.putShort((short)10);
            arg.getNonTypeEvaluation().marshal(this, true);
        } else {
            this.marshalType(arg.getTypeValue());
        }
    }

    @Override
    public void putByte(byte value) {
        this.appendSeparator();
        this.fBuffer.append(value);
    }

    @Override
    public void putFixedInt(int value) {
        this.appendSeparator();
        this.fBuffer.append(value);
    }

    @Override
    public void putShort(short value) {
        this.appendSeparator();
        this.fBuffer.append(value);
    }

    @Override
    public void putInt(int value) {
        this.appendSeparator();
        this.fBuffer.append(value);
    }

    @Override
    public void putLong(long value) {
        this.appendSeparator();
        this.fBuffer.append(value);
    }

    @Override
    public void putCharArray(char[] chars) {
        this.appendSeparator();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.fBuffer.append(c);
            ++n2;
        }
    }

    private void appendSeparator() {
        if (this.fBuffer.length() != 0) {
            this.fBuffer.append(' ');
        }
    }

    @Override
    public IBinding unmarshalBinding() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IType unmarshalType() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPEvaluation unmarshalEvaluation() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPExecution unmarshalExecution() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IValue unmarshalValue() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPTemplateArgument unmarshalTemplateArgument() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getByte() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CoreException unmarshallingError() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFixedInt() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public char[] getCharArray() throws CoreException {
        throw new UnsupportedOperationException();
    }
}

