/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

public final class EnumDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private static final int CACHE_SIZE = 4096;
    private final Multimap<Pair, String> fEnumMap = LinkedHashMultimap.create();
    private final IntegerDeclaration fContainerType;
    private Pair fLastAdded = new Pair(-1L, -1L);
    private @Nullable String[] fCache = new String[4096];

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.fContainerType = containerType;
    }

    public EnumDeclaration(IntegerDeclaration containerType, Map<Pair, String> enumTree) {
        this.fContainerType = containerType;
        enumTree.entrySet().forEach(entry -> {
            boolean bl = this.fEnumMap.put((Object)((Pair)entry.getKey()), (Object)((String)entry.getValue()));
        });
    }

    public IntegerDeclaration getContainerType() {
        return this.fContainerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public int getMaximumSize() {
        return this.fContainerType.getMaximumSize();
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fContainerType.isByteOrderSet();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fContainerType.getByteOrder();
    }

    @Override
    public EnumDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IntegerDefinition value = this.getContainerType().createDefinition(definitionScope, fieldName, input);
        return new EnumDefinition(this, definitionScope, fieldName, value);
    }

    public boolean add(long low, long high, @Nullable String label) {
        if (high < low) {
            return false;
        }
        if (low < 0L || low >= 4095L || high < 0L || high >= 4095L) {
            this.fCache = null;
        }
        int i = (int)low;
        while ((long)i <= high) {
            if (this.fCache == null) break;
            if (this.fCache[i] != null) {
                this.fCache = null;
                break;
            }
            this.fCache[i] = label;
            ++i;
        }
        Pair key = new Pair(low, high);
        this.fEnumMap.put((Object)key, (Object)label);
        this.fLastAdded = key;
        return true;
    }

    public boolean add(@Nullable String label) {
        return this.add(this.fLastAdded.fSecond + 1L, this.fLastAdded.fSecond + 1L, label);
    }

    public @Nullable String query(long value) {
        if (this.fCache != null) {
            if (value < 0L || value >= 4096L) {
                return null;
            }
            return this.fCache[(int)value];
        }
        ArrayList strValues = new ArrayList();
        this.fEnumMap.forEach((k, v) -> {
            if (value >= k.getFirst() && value <= k.getSecond()) {
                strValues.add(v);
            }
        });
        if (!strValues.isEmpty()) {
            return strValues.size() == 1 ? (String)strValues.get(0) : ((Object)strValues).toString();
        }
        ArrayList<String> flagsSet = new ArrayList<String>();
        int i = 0;
        while (i < 64) {
            Long bitValue = 1L << i;
            if ((bitValue & value) != 0L) {
                Pair bitPair = new Pair(bitValue, bitValue);
                Collection flagValues = this.fEnumMap.get((Object)bitPair);
                if (flagValues.isEmpty()) {
                    return null;
                }
                flagsSet.add(flagValues.size() == 1 ? (String)flagValues.iterator().next() : flagValues.toString());
            }
            ++i;
        }
        return flagsSet.isEmpty() ? null : String.join((CharSequence)" | ", flagsSet);
    }

    public Map<Pair, String> getLookupTable() {
        LinkedHashMap<Pair, String> table = new LinkedHashMap<Pair, String>();
        this.fEnumMap.asMap().forEach((k, v) -> table.put((Pair)k, v.size() == 1 ? (String)v.iterator().next() : v.toString()));
        return table;
    }

    public Set<String> getLabels() {
        return ImmutableSet.copyOf((Collection)this.fEnumMap.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] enum[");
        for (String label : this.getLabels()) {
            sb.append("label:").append(label).append(' ');
        }
        sb.append("type:").append(this.fContainerType.toString());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fContainerType, this.fEnumMap);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.equals(other.fContainerType)) {
            return false;
        }
        return Iterables.elementsEqual((Iterable)this.fEnumMap.entries(), (Iterable)other.fEnumMap.entries());
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.isBinaryEquivalent((IDeclaration)other.fContainerType)) {
            return false;
        }
        return Iterables.elementsEqual((Iterable)this.fEnumMap.entries(), (Iterable)other.fEnumMap.entries());
    }

    public static class Pair {
        private final long fFirst;
        private final long fSecond;

        private Pair(long first, long second) {
            this.fFirst = first;
            this.fSecond = second;
        }

        public long getFirst() {
            return this.fFirst;
        }

        public long getSecond() {
            return this.fSecond;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.fFirst == other.fFirst && this.fSecond == other.fSecond;
        }

        public int hashCode() {
            return Objects.hash(this.fFirst, this.fSecond);
        }

        public String toString() {
            return Arrays.toString(new long[]{this.fFirst, this.fSecond});
        }
    }
}

