/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Gid;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PubSubObject;

public class Ros2SubscriptionObject
extends Ros2PubSubObject {
    public static final byte CUSTOM_TYPE_ID = 62;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory ROS2_SUBSCRIPTION_OBJECT_VALUE_FACTORY = b -> Ros2SubscriptionObject.read(b);
    private final @NonNull HostProcessPointer fSubscription;
    private final @NonNull HostProcessPointer fCallback;
    private final int fSerializedValueSize;

    public Ros2SubscriptionObject(@NonNull Ros2ObjectHandle subscriptionHandle, @NonNull Ros2ObjectHandle rmwSubscriptionHandle, @NonNull String topicName, @NonNull Ros2ObjectHandle nodeHandle, @NonNull Gid gid, @NonNull HostProcessPointer ddsReader, @NonNull HostProcessPointer subscription, @NonNull HostProcessPointer callback) {
        super(subscriptionHandle, rmwSubscriptionHandle, topicName, nodeHandle, gid, ddsReader);
        this.fSubscription = subscription;
        this.fCallback = callback;
        int size = 0;
        size += super.getSerializedValueSize();
        size += this.fSubscription.getSerializedValueSize();
        this.fSerializedValueSize = size += this.fCallback.getSerializedValueSize();
    }

    public @NonNull HostProcessPointer getSubscription() {
        return this.fSubscription;
    }

    public @NonNull HostProcessPointer getCallback() {
        return this.fCallback;
    }

    public @NonNull HostProcessPointer getDdsReader() {
        return super.getDdsHandle();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fSubscription, this.fCallback, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2SubscriptionObject o = (Ros2SubscriptionObject)((Object)obj);
        return o.fSubscription.equals((Object)this.fSubscription) && o.fCallback.equals((Object)this.fCallback);
    }

    @Override
    public String toString() {
        return String.format("Ros2SubscriptionObject: %s, subscription=[%s], callback=[%s]", super.toString(), this.fSubscription.toString(), this.fCallback.toString());
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)62;
    }

    @Override
    protected void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        this.fSubscription.serializeValue(buffer);
        this.fCallback.serializeValue(buffer);
    }

    @Override
    protected int getSerializedValueSize() {
        return this.fSerializedValueSize;
    }

    public static @NonNull Ros2SubscriptionObject read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle subscriptionHandle = Ros2ObjectHandle.read(buffer);
        Ros2ObjectHandle rmwPublisherHandle = Ros2ObjectHandle.read(buffer);
        String topicName = buffer.getString();
        Ros2ObjectHandle nodeHandle = Ros2ObjectHandle.read(buffer);
        Gid gid = Gid.read(buffer);
        HostProcessPointer ddsReader = HostProcessPointer.read(buffer);
        HostProcessPointer subscription = HostProcessPointer.read(buffer);
        HostProcessPointer callback = HostProcessPointer.read(buffer);
        return new Ros2SubscriptionObject(subscriptionHandle, rmwPublisherHandle, topicName, nodeHandle, gid, ddsReader, subscription, callback);
    }
}

