/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.titan.log.viewer.actions.OpenMSCViewMenuAction;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IActionDelegate;

public class OpenMSCViewAction
extends Action
implements IActionDelegate,
ISelectionChangedListener {
    private static final String NAME = Messages.getString("OpenMSCViewMenuAction.0");
    private IStructuredSelection selection;
    private LogFileMetaData logFileMetaData;
    private int recordToSelect = -1;

    public OpenMSCViewAction() {
        super(NAME);
    }

    public void run(IAction action) {
        this.run(this.selection);
    }

    public void run(IStructuredSelection selection) {
        OpenMSCViewMenuAction menuAction = new OpenMSCViewMenuAction();
        menuAction.setFirstRow(this.recordToSelect);
        menuAction.run(selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            this.setEnabled(false);
            return;
        }
        this.selection = (IStructuredSelection)selection;
        if (this.selection.size() != 1 || !(this.selection.getFirstElement() instanceof TestCase)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(null, event.getSelection());
    }

    public void setFirstRow(int recordNumber) {
        this.recordToSelect = recordNumber;
    }
}

