/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IfInsteadAltguard
extends BaseModuleCodeSmellSpotter {
    private static final String MIGHT_ALTGUARD = "Consider whether the condition could be transformed to an alt guard";

    public IfInsteadAltguard() {
        super(CodeSmellType.IF_INSTEAD_ALTGUARD);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Statement firstStatement;
        AltGuard ag;
        StatementBlock statements;
        if (node instanceof AltGuard && (statements = (ag = (AltGuard)node).getStatementBlock()) != null && !statements.isEmpty() && (firstStatement = statements.getStatementByIndex(0)) instanceof If_Statement) {
            Value condition = ((If_Clause)((If_Statement)firstStatement).getIfClauses().getClauses().get(0)).getExpression();
            Location reportAt = condition != null ? condition.getLocation() : firstStatement.getLocation();
            problems.report(reportAt, MIGHT_ALTGUARD);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(AltGuard.class);
        return ret;
    }
}

