/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class ConvertToEnum
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MSG_SELECT = "Select should be used with enumerations. Branch coverage can not be calculated on {0} types.";
    private static final String ERROR_MSG_CASE = "Select cases should be described by enumeration items.";
    private final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public ConvertToEnum() {
        super(CodeSmellType.CONVERT_TO_ENUM);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        SelectCases scs;
        IType governor;
        if (!(node instanceof SelectCase_Statement)) {
            return;
        }
        SelectCase_Statement s = (SelectCase_Statement)node;
        Value v = s.getExpression();
        if (v == null || v.getIsErroneous(this.timestamp)) {
            return;
        }
        IType.Type_type type = v.getExpressionReturntype(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (!type.equals((Object)IType.Type_type.TYPE_TTCN3_ENUMERATED) && (governor = v.getExpressionGovernor(this.timestamp, Expected_Value_type.EXPECTED_TEMPLATE)) != null && !governor.getIsErroneous(this.timestamp)) {
            problems.report(v.getLocation(), MessageFormat.format(ERROR_MSG_SELECT, governor.getTypename()));
        }
        if ((scs = s.getSelectCases()) == null || scs.getSelectCaseArray() == null) {
            return;
        }
        for (SelectCase sc : scs.getSelectCaseArray()) {
            if (sc.hasElse()) continue;
            CaseVisitor visitor = new CaseVisitor(problems);
            sc.accept((ASTVisitor)visitor);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(SelectCase_Statement.class);
        return ret;
    }

    private final class CaseVisitor
    extends ASTVisitor {
        private final BaseCodeSmellSpotter.Problems problems;

        public CaseVisitor(BaseCodeSmellSpotter.Problems problems) {
            this.problems = problems;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof SelectCase) {
                return 3;
            }
            if (node instanceof TemplateInstances) {
                return 3;
            }
            if (node instanceof TemplateInstance) {
                TemplateInstance ti = (TemplateInstance)node;
                IType.Type_type type = ti.getExpressionReturntype(ConvertToEnum.this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (!type.equals((Object)IType.Type_type.TYPE_TTCN3_ENUMERATED)) {
                    this.problems.report(ti.getLocation(), ConvertToEnum.ERROR_MSG_CASE);
                }
                return 1;
            }
            return 1;
        }
    }
}

