/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.menus;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.gui.common.CustomVisualizationViewer;
import org.eclipse.titanium.graph.gui.dialogs.InfoWindow;
import org.eclipse.titanium.graph.gui.menus.NodePopupMenu;
import org.eclipse.titanium.graph.visualization.MeasureableGraphHandler;

public class MeasureableNodePopupMenu
extends NodePopupMenu {
    private static final long serialVersionUID = 1L;
    protected JMenuItem showInfo = new JMenuItem("Show Info Window");
    protected InfoWindow infwind;

    public MeasureableNodePopupMenu(final MeasureableGraphHandler handler, final Shell parent) {
        super(handler);
        this.showInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomVisualizationViewer actVisualisator = handler.getVisualizator();
                if (actVisualisator == null) {
                    return;
                }
                Layout tmpLayout = actVisualisator.getGraphLayout();
                if (tmpLayout == null) {
                    return;
                }
                Graph g = actVisualisator.getGraphLayout().getGraph();
                actVisualisator.getPickedVertexState().clear();
                actVisualisator.getPickedVertexState().pick((Object)MeasureableNodePopupMenu.this.node, true);
                actVisualisator.getPickedEdgeState().clear();
                for (EdgeDescriptor edge : g.getIncidentEdges((Object)MeasureableNodePopupMenu.this.node)) {
                    actVisualisator.getPickedEdgeState().pick((Object)edge, true);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MeasureableNodePopupMenu.this.infwind != null) {
                            MeasureableNodePopupMenu.this.infwind.dispose();
                        }
                        MeasureableNodePopupMenu.this.infwind = new InfoWindow(MeasureableNodePopupMenu.this.node, handler.getChosenMetric(), parent);
                    }
                });
            }
        });
        this.add(this.showInfo);
    }

    public void enableInfoWindow(boolean value) {
        this.showInfo.setEnabled(value);
    }
}

