/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TITANFlagsOptionsData {
    private static final String EMPTY = "";
    private static final String FALSE = String.valueOf(false);
    public static final String DISABLE_ATTRIBUTE_VALIDATION_PROPERTY = "disableAttributeValidation";
    public static final String DISABLE_BER_PROPERTY = "disableBER";
    public static final String DISABLE_RAW_PROPERTY = "disableRAW";
    public static final String DISABLE_TEXT_PROPERTY = "disableTEXT";
    public static final String DISABLE_XER_PROPERTY = "disableXER";
    public static final String DISABLE_JSON_PROPERTY = "disableJSON";
    public static final String DISABLE_OER_PROPERTY = "disableOER";
    public static final String FORCE_XER_IN_ASN1_PROPERTY = "forceXERinASN.1";
    public static final String DEFAULT_AS_OMIT_PROPERTY = "defaultasOmit";
    public static final String FORCE_OLD_FUNC_OUT_PAR_PROPERTY = "forceOldFuncOutParHandling";
    public static final String GCC_MESSAGE_FORMAT_PROPERTY = "gccMessageFormat";
    public static final String LINE_NUMBERS_ONLY_IN_MESSAGES_PROPERTY = "lineNumbersOnlyInMessages";
    public static final String INCLUDE_SOURCEINFO_PROPERTY = "includeSourceInfo";
    public static final String ADD_SOURCELINEINFO_PROPERTY = "addSourceLineInfo";
    public static final String SUPPRESS_WARNINGS_PROPERTY = "suppressWarnings";
    public static final String ALLOW_OMIT_IN_VALUELIST_TEMPLATE_PROPERTY = "omitInValueList";
    public static final String WARNINGS_FOR_BAD_VARIANTS_PROPERTY = "warningsForBadVariants";
    public static final String IGNORE_UNTAGGED_ON_TOP_LEVEL_UNION_PROPERTY = "ignoreUntaggedOnTopLevelUnion";
    public static final String ACTIVATE_DEBUGGER_PROPERTY = "activateDebugger";
    public static final String QUIETLY_PROPERTY = "quietly";
    public static final String ENABLE_LEGACY_ENCODING_PROPERTY = "enableLegacyEncoding";
    public static final String DISABLE_USER_INFORMATION_PROPERTY = "disableUserInformation";
    public static final String ENABLE_REALTIME = "enableRealtimeTesting";
    public static final String DISABLE_SUBTYPE_CHECKING_PROPERTY = "disableSubtypeChecking";
    public static final String FORCE_GEN_SEOF = "forceGenSeof";
    public static final String ENABLE_OOP = "enableOOP";
    public static final String[] PROPERTIES = new String[]{"disableAttributeValidation", "disableBER", "disableRAW", "disableTEXT", "disableXER", "disableJSON", "disableOER", "forceXERinASN.1", "defaultasOmit", "forceOldFuncOutParHandling", "gccMessageFormat", "lineNumbersOnlyInMessages", "includeSourceInfo", "addSourceLineInfo", "suppressWarnings", "omitInValueList", "warningsForBadVariants", "ignoreUntaggedOnTopLevelUnion", "activateDebugger", "quietly", "enableLegacyEncoding", "disableUserInformation", "enableRealtimeTesting", "disableSubtypeChecking", "forceGenSeof", "enableOOP"};
    public static final String[] TAGS = PROPERTIES;
    public static final String[] DEFAULT_VALUES = new String[]{FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE};

    private TITANFlagsOptionsData() {
    }

    public static String getTITANFlags(IProject project, boolean useRuntime2) {
        StringBuilder builder = new StringBuilder(30);
        if (useRuntime2) {
            builder.append('R');
        }
        TITANFlagsOptionsData.append(builder, project, DISABLE_BER_PROPERTY, "b");
        TITANFlagsOptionsData.append(builder, project, DISABLE_RAW_PROPERTY, "r");
        TITANFlagsOptionsData.append(builder, project, DISABLE_TEXT_PROPERTY, "x");
        TITANFlagsOptionsData.append(builder, project, DISABLE_XER_PROPERTY, "X");
        TITANFlagsOptionsData.append(builder, project, DISABLE_JSON_PROPERTY, "j");
        TITANFlagsOptionsData.append(builder, project, DISABLE_OER_PROPERTY, "O");
        TITANFlagsOptionsData.append(builder, project, FORCE_XER_IN_ASN1_PROPERTY, "a");
        TITANFlagsOptionsData.append(builder, project, DEFAULT_AS_OMIT_PROPERTY, "d");
        TITANFlagsOptionsData.append(builder, project, FORCE_OLD_FUNC_OUT_PAR_PROPERTY, "Y");
        TITANFlagsOptionsData.append(builder, project, GCC_MESSAGE_FORMAT_PROPERTY, "g");
        TITANFlagsOptionsData.append(builder, project, LINE_NUMBERS_ONLY_IN_MESSAGES_PROPERTY, "i");
        TITANFlagsOptionsData.append(builder, project, INCLUDE_SOURCEINFO_PROPERTY, "l");
        TITANFlagsOptionsData.append(builder, project, ADD_SOURCELINEINFO_PROPERTY, "L");
        TITANFlagsOptionsData.append(builder, project, SUPPRESS_WARNINGS_PROPERTY, "w");
        TITANFlagsOptionsData.append(builder, project, QUIETLY_PROPERTY, "q");
        TITANFlagsOptionsData.append(builder, project, DISABLE_SUBTYPE_CHECKING_PROPERTY, "y");
        TITANFlagsOptionsData.append(builder, project, DISABLE_ATTRIBUTE_VALIDATION_PROPERTY, "0");
        TITANFlagsOptionsData.append(builder, project, ALLOW_OMIT_IN_VALUELIST_TEMPLATE_PROPERTY, "M");
        TITANFlagsOptionsData.append(builder, project, WARNINGS_FOR_BAD_VARIANTS_PROPERTY, "E");
        TITANFlagsOptionsData.append(builder, project, IGNORE_UNTAGGED_ON_TOP_LEVEL_UNION_PROPERTY, "N");
        TITANFlagsOptionsData.append(builder, project, ENABLE_LEGACY_ENCODING_PROPERTY, "e");
        TITANFlagsOptionsData.append(builder, project, DISABLE_USER_INFORMATION_PROPERTY, "D");
        TITANFlagsOptionsData.append(builder, project, ENABLE_REALTIME, "I");
        TITANFlagsOptionsData.append(builder, project, FORCE_GEN_SEOF, "F");
        TITANFlagsOptionsData.append(builder, project, ENABLE_OOP, "k");
        TITANFlagsOptionsData.append(builder, project, ACTIVATE_DEBUGGER_PROPERTY, "n");
        if (builder.length() > 0) {
            builder.insert(0, '-');
        }
        return builder.toString();
    }

    public static String getTITANFlagComments(IProject project, boolean useRuntime2) {
        StringBuilder builder = new StringBuilder();
        if (useRuntime2) {
            builder.append("function test runtime");
        } else {
            builder.append("load test runtime");
        }
        TITANFlagsOptionsData.append(builder, project, DISABLE_BER_PROPERTY, " + disable BER");
        TITANFlagsOptionsData.append(builder, project, DISABLE_RAW_PROPERTY, " + disable RAW");
        TITANFlagsOptionsData.append(builder, project, DISABLE_TEXT_PROPERTY, " + disable TEXT");
        TITANFlagsOptionsData.append(builder, project, DISABLE_XER_PROPERTY, " + disable XER");
        TITANFlagsOptionsData.append(builder, project, DISABLE_JSON_PROPERTY, " + disable JSON");
        TITANFlagsOptionsData.append(builder, project, DISABLE_OER_PROPERTY, " + disable OER");
        TITANFlagsOptionsData.append(builder, project, FORCE_XER_IN_ASN1_PROPERTY, " + enable basic XER in ASN.1");
        TITANFlagsOptionsData.append(builder, project, DEFAULT_AS_OMIT_PROPERTY, " + treat default fields as omit");
        TITANFlagsOptionsData.append(builder, project, FORCE_OLD_FUNC_OUT_PAR_PROPERTY, " + enforce legacy behaviour for \"out\" parameters");
        TITANFlagsOptionsData.append(builder, project, GCC_MESSAGE_FORMAT_PROPERTY, " + emulate GCC error/warning message format");
        TITANFlagsOptionsData.append(builder, project, LINE_NUMBERS_ONLY_IN_MESSAGES_PROPERTY, " + line numbers only in messages");
        TITANFlagsOptionsData.append(builder, project, INCLUDE_SOURCEINFO_PROPERTY, " + include source info");
        TITANFlagsOptionsData.append(builder, project, ADD_SOURCELINEINFO_PROPERTY, " + add source line info for logging");
        TITANFlagsOptionsData.append(builder, project, SUPPRESS_WARNINGS_PROPERTY, " + suppress warnings");
        TITANFlagsOptionsData.append(builder, project, QUIETLY_PROPERTY, " + suppress all messages");
        TITANFlagsOptionsData.append(builder, project, DISABLE_SUBTYPE_CHECKING_PROPERTY, " + disable subtype checking");
        TITANFlagsOptionsData.append(builder, project, DISABLE_ATTRIBUTE_VALIDATION_PROPERTY, " + disable attribute validation");
        TITANFlagsOptionsData.append(builder, project, ALLOW_OMIT_IN_VALUELIST_TEMPLATE_PROPERTY, " + allow omit in template value lists");
        TITANFlagsOptionsData.append(builder, project, WARNINGS_FOR_BAD_VARIANTS_PROPERTY, " + warnings for unrecognized encodings");
        TITANFlagsOptionsData.append(builder, project, IGNORE_UNTAGGED_ON_TOP_LEVEL_UNION_PROPERTY, " + ignore UNTAGGED encoding instruction on top level unions");
        TITANFlagsOptionsData.append(builder, project, ENABLE_LEGACY_ENCODING_PROPERTY, " + enable legacy encoding");
        TITANFlagsOptionsData.append(builder, project, DISABLE_USER_INFORMATION_PROPERTY, " + disable user information and timestamp in header");
        TITANFlagsOptionsData.append(builder, project, ENABLE_REALTIME, " + enable realtime testing feature");
        TITANFlagsOptionsData.append(builder, project, FORCE_GEN_SEOF, " + force generation of setofs");
        TITANFlagsOptionsData.append(builder, project, ENABLE_OOP, " + enable OOP");
        TITANFlagsOptionsData.append(builder, project, ACTIVATE_DEBUGGER_PROPERTY, " + activate debugger");
        return builder.toString();
    }

    public static void removeTITANAttributes(IProject project) {
        for (String property : PROPERTIES) {
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", property), null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            String name = resourceList.item(i).getNodeName();
            for (int j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                newValues[j] = resourceList.item(i).getTextContent();
            }
        }
        for (i = 0; i < TAGS.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        for (int i = 0; i < TAGS.length; ++i) {
            try {
                String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]));
                if (temp == null || DEFAULT_VALUES[i].equals(temp)) continue;
                Element element = document.createElement(TAGS[i]);
                makefileSettings.appendChild(element);
                element.appendChild(document.createTextNode(temp));
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        if (source != null) {
            NodeList resourceList = source.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String name = resourceList.item(i).getNodeName();
                for (int j = 0; j < TAGS.length; ++j) {
                    if (!TAGS[j].equals(name)) continue;
                    newValues[j] = resourceList.item(i).getTextContent();
                }
            }
        }
        for (int i = 0; i < TAGS.length; ++i) {
            String temp = newValues[i];
            if (temp == null || !saveDefaultValues && DEFAULT_VALUES[i].equals(temp)) continue;
            Element node = document.createElement(TAGS[i]);
            node.appendChild(document.createTextNode(temp));
            makefileSettings.appendChild(node);
        }
    }

    private static final boolean getPropertyValue(IProject project, String property) {
        try {
            return Boolean.parseBoolean(project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", property)));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting Titan flags of `" + project.getName() + "'"), (Throwable)e);
            return false;
        }
    }

    private static final StringBuilder append(StringBuilder sb, IProject project, String property, String flag) {
        return sb.append(TITANFlagsOptionsData.getPropertyValue(project, property) ? flag : EMPTY);
    }
}

