/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.DocumentTracker;
import org.eclipse.titan.designer.editors.IDocumentGetter;
import org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner;

public class AstWordRule
extends WordRule {
    private static boolean isSemanticHighlightingEnabled;
    private static boolean isBracketColoringEnabled;
    private StringBuilder fBuffer = new StringBuilder();

    public AstWordRule(IWordDetector detector) {
        super(detector);
    }

    public AstWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        boolean isEof = false;
        int c = scanner.read();
        boolean isBracket = this.isBracket(c);
        if (c != -1 && (this.fDetector.isWordStart((char)c) || isBracket) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            IToken token;
            this.fBuffer.setLength(0);
            if (isBracket) {
                this.fBuffer.append((char)c);
            } else {
                do {
                    this.fBuffer.append((char)c);
                } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
                scanner.unread();
                if (c == -1) {
                    isEof = true;
                }
            }
            String buffer = this.fBuffer.toString();
            if (isSemanticHighlightingEnabled && !isBracket || isBracketColoringEnabled && isBracket) {
                Location peekLocation;
                IDocumentGetter codeScanner = (IDocumentGetter)scanner;
                Module module = DocumentTracker.get(codeScanner.getDocument());
                IToken decoration = null;
                if (module != null) {
                    String filename = module.getLocation().getFile().getFullPath().toOSString();
                    decoration = AstSyntaxHighlightTokens.getSyntaxToken(filename, codeScanner.getTokenOffset());
                } else if (scanner instanceof CodeScanner && (peekLocation = ((CodeScanner)scanner).getPeekLocation()) != null) {
                    Location calcLocation = new Location(peekLocation);
                    calcLocation.setOffset(calcLocation.getOffset() + ((CodeScanner)scanner).getTokenOffset());
                    decoration = AstSyntaxHighlightTokens.getSyntaxToken(calcLocation);
                }
                if (decoration != null) {
                    return decoration;
                }
            }
            if ((token = (IToken)this.fWords.get(buffer)) != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return isEof ? Token.UNDEFINED : this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean isBracket(int c) {
        switch (c) {
            case 40: 
            case 41: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    static {
        IPreferencesService prefs = Platform.getPreferencesService();
        isSemanticHighlightingEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableSemanticHighlighting", false, null);
        isBracketColoringEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.bracketColoringEnabled", false, null);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(event -> {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.enableSemanticHighlighting".equals(property) || "org.eclipse.titan.designer.bracketColoringEnabled".equals(property)) {
                isSemanticHighlightingEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableSemanticHighlighting", false, null);
                isBracketColoringEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.bracketColoringEnabled", false, null);
            }
        });
    }
}

