/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.designer.AST.Location;

public final class ProductIdentityHelper {
    private static final Pattern PRODUCT_PATTERN1 = Pattern.compile("^([A-Z]{3,5}[ ][0-9]{3}[ ][0-9]{2,4})/([0-9]+)[ ](R.+)$");
    private static final Matcher PRODUCT_PATTERN1_MATCHER = PRODUCT_PATTERN1.matcher("");
    private static final Pattern PRODUCT_PATTERN2 = Pattern.compile("^([0-9]+)/([A-Z]{3,5}[ ][0-9]{3}[ ][0-9]{2,4})[ ](R.+)$");
    private static final Matcher PRODUCT_PATTERN2_MATCHER = PRODUCT_PATTERN2.matcher("");
    private static final Pattern PRODUCT_PATTERN3 = Pattern.compile("^([A-Z]{3,5}[ ][0-9]{3}[ ][0-9]{2,4})[ ](R.+)$");
    private static final Matcher PRODUCT_PATTERN3_MATCHER = PRODUCT_PATTERN3.matcher("");
    private static final Pattern PRODUCT_PATTERN4 = Pattern.compile("^(R.+)$");
    private static final Matcher PRODUCT_PATTERN4_MATCHER = PRODUCT_PATTERN4.matcher("");
    private static final Pattern PRODUCT_PATTERN5 = Pattern.compile("^([0-9]+.[0-9]+.[0-9]+)");
    private static final Matcher PRODUCT_PATTERN5_MATCHER = PRODUCT_PATTERN5.matcher("");
    private static final Pattern RNUMBER_PATTERN1 = Pattern.compile("^R([0-9]+)([A-Z]+)([0-9]+)$");
    private static final Matcher RNUMBER_PATTERN1_MATCHER = RNUMBER_PATTERN1.matcher("");
    private static final Pattern RNUMBER_PATTERN2 = Pattern.compile("^R([0-9]+)([A-Z]+)$");
    private static final Matcher RNUMBER_PATTERN2_MATCHER = RNUMBER_PATTERN2.matcher("");
    private static final Pattern RNUMBER_PATTERN3 = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+)");
    private static final Matcher RNUMBER_PATTERN3_MATCHER = RNUMBER_PATTERN3.matcher("");
    private static final String DEFAULT_SEMANTIC_ERROR_MESSAGE = "Wrong format for product version information: The accepted formats resemble CRL 113 200/1 R9A or 7/CAX 105 7730 R2A or 7.2.1";

    private ProductIdentityHelper() {
    }

    public static synchronized ProductIdentity getProductIdentity(String versionString, Location location) {
        String rNumber;
        if (versionString == null) {
            return null;
        }
        if (versionString.contains("RnXnn")) {
            return new ProductIdentity();
        }
        String productNumber = null;
        String productNumberSuffix = null;
        if (PRODUCT_PATTERN1_MATCHER.reset(versionString).matches()) {
            productNumber = PRODUCT_PATTERN1_MATCHER.group(1);
            productNumberSuffix = PRODUCT_PATTERN1_MATCHER.group(2);
            rNumber = PRODUCT_PATTERN1_MATCHER.group(3);
        } else if (PRODUCT_PATTERN2_MATCHER.reset(versionString).matches()) {
            productNumberSuffix = PRODUCT_PATTERN2_MATCHER.group(1);
            productNumber = PRODUCT_PATTERN2_MATCHER.group(2);
            rNumber = PRODUCT_PATTERN2_MATCHER.group(3);
        } else if (PRODUCT_PATTERN3_MATCHER.reset(versionString).matches()) {
            productNumber = PRODUCT_PATTERN3_MATCHER.group(1);
            rNumber = PRODUCT_PATTERN3_MATCHER.group(2);
        } else if (PRODUCT_PATTERN4_MATCHER.reset(versionString).matches()) {
            rNumber = PRODUCT_PATTERN4_MATCHER.group(1);
        } else if (PRODUCT_PATTERN5_MATCHER.reset(versionString).matches()) {
            productNumber = "";
            rNumber = PRODUCT_PATTERN5_MATCHER.group(1);
        } else {
            ProductIdentityHelper.reportDefaultSemanticError(location);
            return null;
        }
        boolean isNumber = false;
        String revisionDigit = null;
        String revisionLetter = null;
        String verificationStep = null;
        if (RNUMBER_PATTERN1_MATCHER.reset(rNumber).matches()) {
            revisionDigit = RNUMBER_PATTERN1_MATCHER.group(1);
            revisionLetter = RNUMBER_PATTERN1_MATCHER.group(2);
            verificationStep = RNUMBER_PATTERN1_MATCHER.group(3);
        } else if (RNUMBER_PATTERN2_MATCHER.reset(rNumber).matches()) {
            revisionDigit = RNUMBER_PATTERN2_MATCHER.group(1);
            revisionLetter = RNUMBER_PATTERN2_MATCHER.group(2);
        } else if (RNUMBER_PATTERN3_MATCHER.reset(rNumber).matches()) {
            productNumberSuffix = RNUMBER_PATTERN3_MATCHER.group(1);
            revisionDigit = RNUMBER_PATTERN3_MATCHER.group(2);
            revisionLetter = RNUMBER_PATTERN3_MATCHER.group(3);
            isNumber = true;
        } else {
            ProductIdentityHelper.reportSemanticError(location, "Wrong format for version information: The accepted formats resemble R2D02 or R2D or 7.2.1");
            return null;
        }
        int majorVersion = 0;
        if (productNumberSuffix != null) {
            try {
                BigInteger temp = new BigInteger(productNumberSuffix);
                if (temp.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                    ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("The major version number {0} is unexpectedly large, right now we can not handle such large numbers", temp));
                    return null;
                }
                majorVersion = temp.intValue();
            }
            catch (NumberFormatException e) {
                ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("Wrong format for version information: the major version must be a number instead of {0}", productNumberSuffix));
                return null;
            }
        }
        int minorVersion = 0;
        try {
            BigInteger temp = new BigInteger(revisionDigit);
            if (temp.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("The minor version number {0} is unexpectedly large, right now we can not handle such large numbers", temp));
                return null;
            }
            minorVersion = temp.intValue();
        }
        catch (NumberFormatException e) {
            ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("Wrong format for version information: the minor version must be a number instead of {0}", revisionDigit));
            return null;
        }
        int patchVersion = 0;
        if (isNumber) {
            BigInteger temp = new BigInteger(revisionLetter);
            if (temp.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("The patch version number {0} is unexpectedly large, right now we can not handle such large numbers", temp));
                return null;
            }
            patchVersion = temp.intValue();
        } else {
            if (revisionLetter.length() > 2) {
                ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("More than one letter is not allowed as patch version: {0}", revisionLetter));
                return null;
            }
            char c = revisionLetter.charAt(0);
            patchVersion = revisionLetter.codePointAt(0) - "A".codePointAt(0);
            switch (c) {
                case 'I': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'W': {
                    ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("Letter {0} is not allowed as patch version", Character.valueOf(c)));
                }
            }
        }
        int buildVersion = 0;
        if (verificationStep != null) {
            try {
                BigInteger temp = new BigInteger(verificationStep);
                if (temp.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                    ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("The build version number {0} is unexpectedly large, right now we can not handle such large numbers", temp));
                    return null;
                }
                buildVersion = temp.intValue();
            }
            catch (NumberFormatException e) {
                ProductIdentityHelper.reportSemanticError(location, MessageFormat.format("Wrong format for version information: the build version must be a number instead of {0}", verificationStep));
                return null;
            }
        }
        if ("CNL 113 300".equals(productNumber) && majorVersion == 0) {
            majorVersion = 1;
        }
        return ProductIdentity.getProductIdentity((String)productNumber, (int)majorVersion, (int)minorVersion, (int)patchVersion, (int)buildVersion);
    }

    private static void reportDefaultSemanticError(Location location) {
        ProductIdentityHelper.reportSemanticError(location, DEFAULT_SEMANTIC_ERROR_MESSAGE);
    }

    private static void reportSemanticError(Location location, String reason) {
        if (location == null) {
            return;
        }
        location.reportSemanticError(reason);
    }
}

