/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.application;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.core.TITANJavaBuilder;
import org.eclipse.titan.designer.core.ant.AntLaunchConfigGenerator;
import org.eclipse.titan.designer.core.ant.AntScriptGenerator;
import org.eclipse.titan.designer.core.ant.CliScriptGenerator;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;

public final class InvokeBuild
implements IApplication {
    public void addJarBuilder(IProject project, String pathToJar) throws CoreException {
        URI resolvedPath;
        String temp = pathToJar;
        URI path = URIUtil.toURI((String)temp);
        if (path.equals(resolvedPath = TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString()))) {
            temp = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)temp);
        }
        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"), temp);
        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultJavaTarget"), MakefileCreationData.DefaultJavaTarget.EXECUTABLE.toString());
        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartShScript"), String.valueOf(true));
        if (AntScriptGenerator.generateAndStoreBuildXML(project, false)) {
            AntLaunchConfigGenerator.createAntLaunchConfiguration(project);
            AntLaunchConfigGenerator.addAntBuilder(project);
            AntLaunchConfigGenerator.setAntBuilderEnabled(project, true);
            CliScriptGenerator.generateAndStoreScripts(project);
            project.refreshLocal(1, null);
        }
    }

    private Integer closeWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
            return EXIT_OK;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            return -1;
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        IProject[] projects;
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length % 2 != 1) {
            System.out.println("This application takes as parameter the name of the project it should build.\nOptionally JAR output can be specified by the `-jar path_to_jar' option.");
            return this.closeWorkspace();
        }
        String projectName = null;
        String pathToJar = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-jar") && i < args.length - 1) {
                pathToJar = args[++i];
                continue;
            }
            projectName = args[i];
        }
        if (!StringUtils.isNullOrEmpty(pathToJar) && !PathUtil.isValidFilePath(pathToJar)) {
            System.out.println("The path `" + pathToJar + "' is not valid.");
            return this.closeWorkspace();
        }
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (project == null || !project.getName().equals(projectName)) continue;
            try {
                project.refreshLocal(2, null);
                if (TITANJavaBuilder.isBuilderEnabled(project)) {
                    this.addJarBuilder(project, pathToJar);
                }
                project.build(6, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)"Unknown error", (Throwable)e);
            }
            return this.closeWorkspace();
        }
        System.out.println("The project with name `" + projectName + "' could not be found.");
        return this.closeWorkspace();
    }

    public void stop() {
    }
}

