/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class CharString_Pattern_Template
extends TTCN3Template {
    private final PatternString patternstring;
    private TTCN3Template converted = null;

    public CharString_Pattern_Template() {
        this.patternstring = new PatternString(PatternString.PatternType.CHARSTRING_PATTERN);
        this.patternstring.setFullNameParent(this);
    }

    public CharString_Pattern_Template(PatternString ps) {
        this.patternstring = ps;
        if (this.patternstring != null) {
            this.patternstring.setFullNameParent(this);
        }
    }

    public PatternString getPatternstring() {
        return this.patternstring;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.CSTR_PATTERN;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous character string pattern";
        }
        return "character string pattern";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("pattern \"");
        builder.append(this.patternstring.getFullString());
        builder.append('\"');
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.patternstring != null) {
            this.patternstring.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        this.patternstring.setCodeSection(codeSection);
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    public boolean patternContainsAnyornoneSymbol() {
        return true;
    }

    public int getMinLengthOfPattern() {
        return 0;
    }

    @Override
    public TTCN3Template setTemplatetype(CompilationTimeStamp timestamp, ITTCN3Template.Template_type newType) {
        switch (newType) {
            case USTR_PATTERN: {
                this.converted = new UnivCharString_Pattern_Template(this.patternstring);
                this.converted.copyGeneralProperties(this);
                break;
            }
            default: {
                return super.setTemplatetype(timestamp, newType);
            }
        }
        return this.converted;
    }

    @Override
    public TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.converted == null || this.converted.getIsErroneous(timestamp)) {
            return this;
        }
        return this.converted.getTemplateReferencedLast(timestamp, referenceChain);
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (this.converted != null) {
            return this.converted.getExpressionReturntype(timestamp, expectedValue);
        }
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an charstring pattern");
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_CHARSTRING.equals((Object)typeType) || IType.Type_type.TYPE_UCHARSTRING.equals((Object)typeType)) {
            boolean hasAnyOrNone = this.patternContainsAnyornoneSymbol();
            this.lengthRestriction.checkNofElements(timestamp, this.getMinLengthOfPattern(), hasAnyOrNone, false, hasAnyOrNone, this);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.patternstring != null) {
            this.patternstring.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.patternstring == null || this.patternstring.accept(v);
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.converted != null) {
            return this.converted.hasSingleExpression();
        }
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        return false;
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        if (this.converted != null) {
            this.converted.generateCodeInit(aData, source, name);
            return;
        }
        StringBuilder preamble = new StringBuilder();
        String patternString = this.patternstring.create_charstring_literals(aData, this.myScope.getModuleScopeGen(), preamble);
        source.append((CharSequence)preamble);
        source.append(MessageFormat.format("{0}.operator_assign(new {1});\n", name, patternString));
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        if (this.converted != null) {
            return this.converted.getSingleExpression(aData, castIsNeeded);
        }
        StringBuilder result = new StringBuilder();
        if (castIsNeeded && (this.lengthRestriction != null || this.isIfpresent)) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing string pattern template `" + this.getFullName() + "''"));
            return result;
        }
        if (this.myGovernor == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing string pattern template `" + this.getFullName() + "''"));
            return result;
        }
        StringBuilder preamble = new StringBuilder();
        String patternString = this.patternstring.create_charstring_literals(aData, this.myScope.getModuleScopeGen(), preamble);
        result.append((CharSequence)preamble);
        result.append(MessageFormat.format("new {0}", patternString));
        return result;
    }

    public void generateCodeStrPattern(JavaGenData aData, StringBuilder source) {
        source.append(this.patternstring.create_charstring_literals(aData, this.myScope.getModuleScopeGen(), source));
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.converted != null) {
            this.converted.setMyDefinition(definition);
        }
    }
}

