/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureExceptions;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Raise_Statement
extends Statement {
    private static final String RAISEONPORT = "Procedure-based operation `raise'' is not applicable to a message-based port of type `{0}''";
    private static final String SIGNATURENOTPRESENT = "Signature `{0}'' is not present on the incoming list of port type `{1}''";
    private static final String NOINCOMINGSIGNATURES = "Port type `{0}'' does not have any incoming signatures";
    private static final String SIGNATUREWITHOUTEXCEPTIONS = "Signature `{0}'' does not have exceptions";
    private static final String UNKNOWNEXCEPTIONTYPE = "Cannot determine the type of the exception";
    private static final String TYPENOTONEXCEPTIONLIST = "Type `{0}'' is not present on the exception list of signature `{1}''";
    private static final String AMBIGUOUSEXCEPTION = "Type of the exception is ambiguous: `{0}'' is compatible with more than one exception type of signature `{1}''";
    private static final String SIGNATUREEXCEPTION = "The type of raise parameter is signature `{0}'', which cannot be an exception type";
    private static final String PORTEXCEPTION = "The type of raise parameter is port type `{0}'', which cannot be an exception type";
    private static final String DEFAULTEXCEPTION = "The type of raise parameter is the `default'' type, which cannot be an exception type";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".signature";
    private static final String FULLNAMEPART3 = ".sendparameter";
    private static final String FULLNAMEPART4 = ".to";
    private static final String FULLNAMEPART5 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "raise";
    private final Reference portReference;
    private final Reference signatureReference;
    private final TemplateInstance parameter;
    private final IValue toClause;
    private final Reference redirectTimestamp;

    public Raise_Statement(Reference portReference, Reference signatureReference, TemplateInstance parameter, IValue toClause, Reference redirectTimestamp) {
        this.portReference = portReference;
        this.signatureReference = signatureReference;
        this.parameter = parameter;
        this.toClause = toClause;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (signatureReference != null) {
            signatureReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (toClause != null) {
            toClause.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_RAISE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.signatureReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART5);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.signatureReference != null) {
            this.signatureReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.toClause != null) {
            this.toClause.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.signatureReference != null) {
            this.signatureReference.setCodeSection(codeSection);
        }
        if (this.parameter != null) {
            this.parameter.setCodeSection(codeSection);
        }
        if (this.toClause != null) {
            this.toClause.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Type portType = Port_Utility.checkPortReference(timestamp, this, this.portReference, false);
        IType signature = Port_Utility.checkSignatureReference(timestamp, this.signatureReference);
        if (portType != null) {
            PortTypeBody portTypeBody = portType.getPortBody();
            TypeSet inSignatures = portTypeBody.getInSignatures();
            if (PortTypeBody.OperationModes.OP_Message.equals((Object)portTypeBody.getOperationMode())) {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(RAISEONPORT, portType.getTypename()));
            } else if (inSignatures != null) {
                if (signature != null) {
                    if (!inSignatures.hasType(timestamp, signature)) {
                        this.portReference.getLocation().reportSemanticError(MessageFormat.format(SIGNATURENOTPRESENT, signature.getTypename(), portType.getTypename()));
                    }
                } else if (inSignatures.getNofTypes() == 1) {
                    signature = inSignatures.getTypeByIndex(0).getTypeRefdLast(timestamp);
                }
            } else {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(NOINCOMINGSIGNATURES, portType.getTypename()));
            }
        }
        IType exception = null;
        boolean exceptionDetermined = false;
        if (signature != null) {
            SignatureExceptions exceptions = ((Signature_Type)signature).getSignatureExceptions();
            if (exceptions == null) {
                this.signatureReference.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREWITHOUTEXCEPTIONS, signature.getTypename()));
            } else {
                if (exceptions.getNofExceptions() == 1) {
                    exception = exceptions.getExceptionByIndex(0);
                } else {
                    exception = Port_Utility.getOutgoingType(timestamp, this.parameter);
                    if (exception == null) {
                        this.parameter.getLocation().reportSemanticError(UNKNOWNEXCEPTIONTYPE);
                    } else {
                        int nofCompatibleTypes = exceptions.getNofCompatibleExceptions(timestamp, exception);
                        if (nofCompatibleTypes == 0) {
                            this.parameter.getLocation().reportSemanticError(MessageFormat.format(TYPENOTONEXCEPTIONLIST, exception.getTypename(), signature.getTypename()));
                        } else if (nofCompatibleTypes > 1) {
                            this.parameter.getLocation().reportSemanticError(MessageFormat.format(AMBIGUOUSEXCEPTION, exception.getTypename(), signature.getTypename()));
                        }
                    }
                }
                exceptionDetermined = true;
            }
        }
        if (!exceptionDetermined) {
            exception = Port_Utility.getOutgoingType(timestamp, this.parameter);
        }
        if (exception != null) {
            this.parameter.check(timestamp, exception);
            exception = exception.getTypeRefdLast(timestamp);
            switch (exception.getTypetype()) {
                case TYPE_SIGNATURE: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREEXCEPTION, exception.getTypename()));
                    break;
                }
                case TYPE_PORT: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(PORTEXCEPTION, exception.getTypename()));
                    break;
                }
                case TYPE_DEFAULT: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(DEFAULTEXCEPTION, exception.getTypename()));
                    break;
                }
            }
        }
        this.parameter.getTemplateBody().checkSpecificValue(timestamp, false);
        Port_Utility.checkToClause(timestamp, this, portType, this.toClause);
        Port_Utility.checkTimestampRedirect(timestamp, portType, this.redirectTimestamp);
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.toClause != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(162);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.signatureReference != null) {
            this.signatureReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.signatureReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.toClause instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.toClause)).updateSyntax(reparser, false);
            reparser.updateLocation(this.toClause.getLocation());
        } else if (this.toClause != null) {
            throw new ReParseException();
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.signatureReference != null) {
            this.signatureReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.toClause != null) {
            this.toClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.signatureReference != null && !this.signatureReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.toClause != null && !this.toClause.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.portReference.generateCode(aData, expression);
        expression.expression.append(".raise( new ");
        this.signatureReference.generateCode(aData, expression);
        expression.expression.append("_exception(");
        TTCN3Template templateBody = this.parameter.getTemplateBody();
        if (this.parameter.getDerivedReference() == null && ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)templateBody.getTemplatetype())) {
            IValue value = ((SpecificValue_Template)templateBody).getSpecificValue();
            value.generateCodeExpressionMandatory(aData, expression, true);
        } else {
            this.parameter.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        }
        expression.expression.append(')');
        if (this.toClause != null) {
            expression.expression.append(", ");
            this.toClause.generateCodeExpression(aData, expression, true);
        }
        expression.expression.append(", ");
        if (this.redirectTimestamp == null) {
            expression.expression.append("null");
        } else {
            this.redirectTimestamp.generateCode(aData, expression);
        }
        expression.expression.append(" )");
        expression.mergeExpression(source);
    }
}

