/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ClassTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;
import org.eclipse.ui.IEditorPart;

public final class Def_Const
extends Definition {
    private static final String FULLNAMEPART = ".<type>";
    public static final String PORTNOTALLOWED = "Constant can not be defined for port type `{0}''";
    public static final String SIGNATURENOTALLOWED = "Constant can not be defined for signature type `{0}''";
    public static final String CLASSNOTALLOWED = "Constant cannot be defined for class type `{0}''";
    public static final String CONTAINSCLASS = "Constant cannot be defined for type `{0}'', which contains a class";
    public static final String TRAITMEMBERS = "Trait class type `{0}'' cannot have constant members";
    private static final String KIND = "constant ";
    private final Type type;
    private Value value;

    public Def_Const(Identifier identifier, Type type, Value value) {
        super(identifier);
        this.type = type;
        this.value = value;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_CONST_DEF, this);
            type.setFullNameParent(this);
        }
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_CONST;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    public IValue getValue() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.value;
    }

    @Override
    public IValue getSetting(CompilationTimeStamp timestamp) {
        return this.getValue();
    }

    @Override
    public String getAssignmentName() {
        return "constant";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "constant.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.removeSyntaxDecoration();
        this.isUsed = false;
        if (!(this.getMyScope() instanceof ClassTypeBody)) {
            if (this.getMyScope() instanceof ComponentTypeBody) {
                NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionComponentConstant", this.identifier, this);
            } else if (this.isLocal()) {
                NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalConstant", this.identifier, this);
            } else {
                NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGlobalConstant", this.identifier, this);
            }
        }
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.type == null) {
            return;
        }
        this.type.setGenName("_T_", this.getGenName());
        this.type.check(timestamp);
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, true);
            this.withAttributesPath.checkAttributes(timestamp, this.type.getTypeRefdLast(timestamp).getTypetype());
        }
        if (this.value == null) {
            if (!(this.getMyScope() instanceof ClassTypeBody)) {
                this.location.reportSemanticError("Constant must be initialized");
            }
            return;
        }
        this.value.setMyGovernor(this.type);
        IValue temporalValue = this.type.checkThisValueRef(timestamp, this.value);
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, lastType.getFullName()));
                break;
            }
            case TYPE_SIGNATURE: {
                this.location.reportSemanticError(MessageFormat.format(SIGNATURENOTALLOWED, lastType.getFullName()));
                break;
            }
            case TYPE_CLASS: {
                this.location.reportSemanticError(MessageFormat.format(CLASSNOTALLOWED, lastType.getTypename()));
                break;
            }
            default: {
                if (lastType.containsClass(timestamp)) {
                    this.location.reportSemanticError(MessageFormat.format(CONTAINSCLASS, lastType.getTypename()));
                    break;
                }
                if (!this.myScope.isClassScope() || !this.myScope.getScopeClass().isTrait()) break;
                this.location.reportSemanticError(MessageFormat.format(TRAITMEMBERS, this.myScope.getScopeClass().getTypename()));
            }
        }
        this.type.checkThisValue(timestamp, temporalValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, true, false, true, this.hasImplicitOmitAttribute(timestamp), false));
        this.checkErroneousAttributes(timestamp);
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        chain.add(this);
        temporalValue.checkRecursions(timestamp, chain);
        chain.release();
        this.value.setGenNameRecursive(this.getGenName());
        this.value.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
        AstSyntaxHighlightTokens.addSyntaxDecoration(this.getIdentifier().getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Constant);
    }

    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_CONST.semanticallyEquals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a constant, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Const otherConstant = (Def_Const)definition;
        if (!this.type.isIdentical(timestamp, otherConstant.type)) {
            String message = MessageFormat.format("Local constant `{0}'' has type `{1}'', but the constant inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.type.getTypename(), otherConstant.getMyScope().getFullName(), otherConstant.type.getTypename());
            this.type.getLocation().reportSemanticError(message);
            return false;
        }
        if (!this.value.checkEquality(timestamp, otherConstant.value)) {
            String message = MessageFormat.format("Local constant `{0}'' and the constant inherited from component type `{1}'' have different values", this.identifier.getDisplayName(), otherConstant.getMyScope().getFullName());
            this.value.getLocation().reportSemanticError(message);
            return false;
        }
        return true;
    }

    @Override
    public void postCheck() {
        super.postCheck();
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder(KIND);
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() >= index + 1 && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        result.add(291);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.value != null) {
                if (enveloped) {
                    this.value.updateSyntax(reparser, false);
                    reparser.updateLocation(this.value.getLocation());
                } else if (reparser.envelopsDamage(this.value.getLocation())) {
                    reparser.extendDamagedRegion(this.value.getLocation().getOffset(), this.value.getLocation().getEndOffset());
                    int result = this.reparse(reparser);
                    if (result == 0) {
                        enveloped = true;
                        this.value.setFullNameParent(this);
                        this.value.setMyScope(this.getMyScope());
                    } else {
                        throw new ReParseException();
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_ExpressionContext root = parser.pr_Expression();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                Value newValue = root.value;
                Ttcn3Reparser.Pr_EndOfFileContext rootEof = parser.pr_EndOfFile();
                ParserUtilities.logParseTree((ParseTree)rootEof, parser);
                if (parser.isErrorListEmpty() && newValue != null) {
                    Def_Const.this.value = newValue;
                }
            }
        });
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        if (this.type == null || this.value == null) {
            return;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.value.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        StringBuilder globalVariable = new StringBuilder();
        String typeGeneratedName = this.type.getGenNameValue(aData, globalVariable);
        if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
            Array_Type arrayType = (Array_Type)this.type;
            StringBuilder temp_sb = aData.getCodeForType(arrayType.getGenNameOwn());
            arrayType.generateCodeValue(aData, temp_sb);
            arrayType.generateCodeTemplate(aData, temp_sb);
        }
        globalVariable.append(MessageFormat.format("\tpublic static final {0} {1} = new {0}();\n", typeGeneratedName, genName));
        this.getLocation().update_location_object(aData, aData.getPreInit());
        if (this.value.getValuetype() == IValue.Value_type.EXPRESSION_VALUE) {
            last.generateCodeInit(aData, aData.getPreInit(), genName);
        } else if (this.value.getLastTimeBuilt() == null || this.value.getLastTimeBuilt().isLess(aData.getBuildTimstamp())) {
            this.value.generateCodeInit(aData, aData.getPreInit(), genName);
        }
        aData.addGlobalVariable(typeGeneratedName, globalVariable.toString());
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenName();
        if (this.type == null || this.value == null) {
            return;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.value.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        String typeGeneratedName = this.type.getGenNameValue(aData, source);
        if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
            Array_Type arrayType = (Array_Type)this.type;
            StringBuilder sb = aData.getCodeForType(arrayType.getGenNameOwn());
            arrayType.generateCodeValue(aData, sb);
            arrayType.generateCodeTemplate(aData, sb);
        }
        if (last.canGenerateSingleExpression()) {
            if (last.returnsNative() || this.type.getTypetypeTtcn3() != last.getExpressionReturntype(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE)) {
                source.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", typeGeneratedName, genName, last.generateSingleExpression(aData)));
            } else {
                source.append(MessageFormat.format("final {0} {1} = {2};\n", typeGeneratedName, genName, last.generateSingleExpression(aData)));
            }
        } else {
            source.append(MessageFormat.format("final {0} {1} = new {0}();\n", typeGeneratedName, genName));
            last.generateCodeInit(aData, source, genName);
        }
    }

    @Override
    public void generateCodeInitComp(JavaGenData aData, StringBuilder initComp, Definition definition) {
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        Type assType = this.getType(this.getLastTimeChecked());
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addStyledText(KIND, 1);
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.getFullNameForDocComment(), 1);
        this.hoverContent.closeHeader();
        this.hoverContent.addTagWithText("Value:", this.getValue() != null ? this.getValue().createStringRepresentation() : "unknown");
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addMembersContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

