/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Getter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PortScope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Setter;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.ui.IEditorPart;

public abstract class Scope
implements INamedNode,
IIdentifierContainer,
IVisitableNode,
ICommentable {
    private static final String RUNSONREQUIRED = "A definition without `runs on'' clause cannot {0} {1}, which runs on component type `{2}''";
    private static final String RUNSONREQUIRED2 = "A definition without `runs on'' clause cannot {0} a value of {1} type `{2}'', which runs on component type `{3}''";
    private static final String RUNSONMISSMATCH = "Runs on clause mismatch: A definition that runs on component type `{0}'' cannot {1} {2}, which runs on `{3}''";
    private static final String RUNSONMISSMATCH2 = "Runs on clause mismatch: A definition that runs on component type `{0}'' cannot {1} a value of {2} type `{3}'', which runs on `{4}''";
    protected Scope parentScope = null;
    protected List<Location> subScopeLocations;
    protected List<Scope> subScopes;
    protected Scope parentScopeGen;
    protected String scopeName = "";
    private String scopeMacroName = "";
    private WeakReference<INamedNode> nameParent;
    private DocumentComment documentComment = null;
    protected Ttcn3HoverContent hoverContent = null;

    public Location getCommentLocation() {
        return null;
    }

    public void setScopeName(String name) {
        this.scopeName = name;
    }

    public String getScopeName() {
        StringBuilder builder = new StringBuilder();
        if (this.parentScope != null) {
            builder.append(this.parentScope.getScopeName());
        }
        if (this.scopeName != null && !this.scopeName.isEmpty()) {
            if (builder.length() == 0) {
                builder.append(this.scopeName);
            } else {
                builder.append('.');
                builder.append(this.scopeName);
            }
        }
        return builder.toString();
    }

    public final void setScopeMacroName(String name) {
        this.scopeMacroName = name;
    }

    public final String getScopeMacroName() {
        if (this.scopeMacroName != null && !this.scopeMacroName.isEmpty()) {
            return this.scopeMacroName;
        }
        if (this.parentScope != null) {
            return this.parentScope.getScopeMacroName();
        }
        return "unknown scope";
    }

    @Override
    public String getFullName() {
        return this.getFullName(null).toString();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        if (this.nameParent == null) {
            return new StringBuilder();
        }
        INamedNode tempParent = (INamedNode)this.nameParent.get();
        if (tempParent == null || tempParent == this) {
            return new StringBuilder();
        }
        return tempParent.getFullName(this);
    }

    @Override
    public final void setFullNameParent(INamedNode nameParent) {
        this.nameParent = new WeakReference<INamedNode>(nameParent);
    }

    @Override
    public INamedNode getNameParent() {
        if (this.nameParent == null) {
            return null;
        }
        return (INamedNode)this.nameParent.get();
    }

    public final void setParentScope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public final Scope getParentScope() {
        return this.parentScope;
    }

    public final void setParentScopeGen(Scope parentScope) {
        this.parentScopeGen = parentScope;
    }

    public StatementBlock getStatementBlockScope() {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getStatementBlockScope();
    }

    public Module getModuleScope() {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getModuleScope();
    }

    public Module getModuleScopeGen() {
        if (this.parentScopeGen != null) {
            return this.parentScopeGen.getModuleScopeGen();
        }
        if (this.parentScope != null) {
            return this.parentScope.getModuleScopeGen();
        }
        return null;
    }

    public ControlPart getControlPart() {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getControlPart();
    }

    public RunsOnScope getScopeRunsOn() {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getScopeRunsOn();
    }

    public PortScope getScopePort() {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getScopePort();
    }

    public Component_Type getMtcSystemComponentType(CompilationTimeStamp timestamp, boolean isSystem) {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getMtcSystemComponentType(timestamp, isSystem);
    }

    public Assignments getAssignmentsScope() {
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getAssignmentsScope();
    }

    public void checkRunsOnScope(CompilationTimeStamp timestamp, Assignment assignment, ILocateableNode errorLocation, String operation) {
        Component_Type referencedComponent;
        switch (assignment.getAssignmentType()) {
            case A_ALTSTEP: {
                referencedComponent = ((Def_Altstep)assignment).getRunsOnType(timestamp);
                break;
            }
            case A_FUNCTION: 
            case A_FUNCTION_RVAL: 
            case A_FUNCTION_RTEMP: {
                referencedComponent = ((Def_Function)assignment).getRunsOnType(timestamp);
                break;
            }
            case A_TESTCASE: {
                referencedComponent = ((Def_Testcase)assignment).getRunsOnType(timestamp);
                break;
            }
            default: {
                return;
            }
        }
        if (referencedComponent == null) {
            return;
        }
        RunsOnScope runsOnScope = this.getScopeRunsOn();
        if (runsOnScope == null) {
            errorLocation.getLocation().reportSemanticError(MessageFormat.format(RUNSONREQUIRED, operation, assignment.getDescription(), referencedComponent.getTypename()));
        } else {
            Component_Type localType = runsOnScope.getComponentType();
            if (!referencedComponent.isCompatible(timestamp, localType, null, null, null)) {
                errorLocation.getLocation().reportSemanticError(MessageFormat.format(RUNSONMISSMATCH, localType.getTypename(), operation, assignment.getDescription(), referencedComponent.getTypename()));
            }
        }
    }

    public void checkRunsOnScope(CompilationTimeStamp timestamp, IType type, ILocateableNode errorLocation, String operation) {
        String typename;
        Component_Type referencedComponent;
        if (type == null) {
            return;
        }
        switch (type.getTypetype()) {
            case TYPE_FUNCTION: {
                referencedComponent = ((Function_Type)type).getRunsOnType(timestamp);
                typename = "function";
                break;
            }
            case TYPE_ALTSTEP: {
                referencedComponent = ((Altstep_Type)type).getRunsOnType(timestamp);
                typename = "altstep";
                break;
            }
            default: {
                return;
            }
        }
        if (referencedComponent == null) {
            return;
        }
        RunsOnScope runsOnScope = this.getScopeRunsOn();
        if (runsOnScope == null) {
            errorLocation.getLocation().reportSemanticError(MessageFormat.format(RUNSONREQUIRED2, operation, typename, type.getTypename(), referencedComponent.getTypename()));
        } else {
            Component_Type localType = runsOnScope.getComponentType();
            if (!referencedComponent.isCompatible(timestamp, localType, null, null, null)) {
                errorLocation.getLocation().reportSemanticError(MessageFormat.format(RUNSONMISSMATCH2, localType.getTypename(), operation, typename, type.getTypename(), referencedComponent.getTypename()));
            }
        }
    }

    public void checkMTCScope(CompilationTimeStamp timestamp, Component_Type mtcComponentType, ILocateableNode errorLocation, String description, boolean inControlPart) {
        if (mtcComponentType == null) {
            return;
        }
        if (inControlPart) {
            errorLocation.getLocation().reportSemanticError("Function with mtc or system clause is not allowed in control part.");
            return;
        }
        Component_Type componentType = this.getMtcSystemComponentType(timestamp, false);
        if (componentType != null && !mtcComponentType.isCompatibleByPort(timestamp, componentType)) {
            errorLocation.getLocation().reportSemanticError(MessageFormat.format("Mtc clause mismatch: A definition that runs on component type `{0}'' cannot {1}, which mtc clause is `{2}''", componentType.getTypename(), description, mtcComponentType.getTypename()));
        }
    }

    public void checkSystemScope(CompilationTimeStamp timestamp, Component_Type systemComponentType, ILocateableNode errorLocation, String description, boolean inControlPart) {
        if (systemComponentType == null) {
            return;
        }
        if (inControlPart) {
            errorLocation.getLocation().reportSemanticError("Function with mtc or system clause is not allowed in control part.");
            return;
        }
        Component_Type componentType = this.getMtcSystemComponentType(timestamp, false);
        if (componentType != null && !systemComponentType.isCompatibleByPort(timestamp, componentType)) {
            errorLocation.getLocation().reportSemanticError(MessageFormat.format("Mtc clause mismatch: A definition that runs on component type `{0}'' cannot {1}, which mtc clause is `{2}''", componentType.getTypename(), description, systemComponentType.getTypename()));
        }
    }

    public Scope getSmallestEnclosingScope(int offset) {
        if (this.subScopes == null) {
            return this;
        }
        int size = this.subScopeLocations.size();
        for (int i = 0; i < size; ++i) {
            Location location = this.subScopeLocations.get(i);
            if (location.getOffset() >= offset || offset >= location.getEndOffset()) continue;
            return this.subScopes.get(i).getSmallestEnclosingScope(offset);
        }
        return this;
    }

    public void addSubScope(Location location, Scope scope) {
        if (NULL_Location.INSTANCE.equals(location)) {
            return;
        }
        if (this.subScopes == null) {
            this.subScopes = new ArrayList<Scope>(1);
            this.subScopes.add(scope);
            this.subScopeLocations = new ArrayList<Location>(1);
            this.subScopeLocations.add(location);
            return;
        }
        int index = this.subScopeLocations.size() - 1;
        if (index == -1) {
            this.subScopeLocations.add(location);
            this.subScopes.add(scope);
            return;
        }
        for (Scope ss : this.subScopes) {
            if (scope != ss) continue;
            return;
        }
        Location subScope = this.subScopeLocations.get(index);
        while (index > 0 && (subScope.getEndOffset() > location.getOffset() || subScope.getEndOffset() == -1)) {
            subScope = this.subScopeLocations.get(--index);
        }
        this.subScopeLocations.add(index, location);
        this.subScopes.add(index, scope);
    }

    public void remove() {
        if (this.subScopeLocations != null) {
            this.subScopeLocations.clear();
            this.subScopeLocations = null;
        }
        if (this.subScopes != null) {
            this.subScopes.clear();
            this.subScopes = null;
        }
        if (this.parentScope != null) {
            int index = this.parentScope.subScopes.indexOf(this);
            this.parentScope.subScopes.remove(index);
            this.parentScope.subScopeLocations.remove(index);
        }
    }

    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.parentScope != null) {
            return this.parentScope.hasAssignmentWithId(timestamp, identifier);
        }
        return false;
    }

    public boolean isValidModuleId(Identifier identifier) {
        if (this.parentScope != null) {
            return this.parentScope.isValidModuleId(identifier);
        }
        return false;
    }

    public abstract Assignment getAssBySRef(CompilationTimeStamp var1, Reference var2);

    public abstract Assignment getAssBySRef(CompilationTimeStamp var1, Reference var2, IReferenceChain var3);

    public void addProposal(ProposalCollector propCollector) {
        propCollector.sortTillMarked();
        propCollector.markPosition();
        if (this.parentScope != null) {
            this.parentScope.addProposal(propCollector);
        }
    }

    public void addSkeletonProposal(ProposalCollector propCollector) {
    }

    public void addKeywordProposal(ProposalCollector propCollector) {
    }

    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (this.parentScope != null) {
            this.parentScope.addDeclaration(declarationCollector);
        }
    }

    public abstract Assignment getEnclosingAssignment(int var1);

    @Override
    public abstract void findReferences(ReferenceFinder var1, List<ReferenceFinder.Hit> var2);

    public String getSubScopeAndLocInfo() {
        if (this.subScopeLocations == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.subScopeLocations.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.subScopes.get(i).getClass().getName()).append(": LOC=[").append(this.subScopeLocations.get(i).getOffset()).append('-').append(this.subScopeLocations.get(i).getEndOffset()).append(']');
        }
        return sb.toString();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        Scope s = this;
        boolean first = true;
        while (s != null) {
            if (first) {
                sb.append("scope: ");
            } else {
                sb.append("\n    -> ");
            }
            sb.append('[').append(s.scopeName).append("]*[").append(s.getFullName()).append("]*[").append(s.getClass().getName()).append("] SUBSCOPES: ").append(s.getSubScopeAndLocInfo());
            s = s.parentScope;
            first = false;
        }
        return sb.toString();
    }

    public String getParentInfo() {
        StringBuilder sb = new StringBuilder();
        Scope s = this;
        boolean first = true;
        while (s != null) {
            if (!first) {
                sb.append(" -> ");
            }
            sb.append('[').append(s.getClass().getSimpleName()).append("] ").append(s.getFullName());
            s = s.parentScope;
            first = false;
        }
        return sb.toString();
    }

    public boolean isChildOf(Scope s) {
        for (Scope tempScope = this.getParentScope(); tempScope != null; tempScope = tempScope.getParentScope()) {
            if (tempScope != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public DocumentComment getDocumentComment() {
        return this.documentComment;
    }

    @Override
    public boolean hasDocumentComment() {
        return this.documentComment != null;
    }

    @Override
    public DocumentComment parseDocumentComment() {
        if (this.documentComment != null) {
            this.documentComment.parseComment();
        }
        return this.documentComment;
    }

    @Override
    public void setDocumentComment(DocumentComment docComment) {
        this.documentComment = docComment;
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        return null;
    }

    public Class_Type getScopeClass() {
        if (this.parentScope != null) {
            return this.parentScope.getScopeClass();
        }
        return null;
    }

    public boolean isClassScope() {
        return false;
    }

    public boolean isInSetterScope() {
        if (this.parentScope != null) {
            return this.parentScope.isInSetterScope();
        }
        return false;
    }

    public boolean isInGetterScope() {
        if (this.parentScope != null) {
            return this.parentScope.isInGetterScope();
        }
        return false;
    }

    public Setter getScopeSetter() {
        if (this.parentScope != null) {
            return this.parentScope.getScopeSetter();
        }
        return null;
    }

    public Getter getScopeGetter() {
        if (this.parentScope != null) {
            return this.parentScope.getScopeGetter();
        }
        return null;
    }

    public Assignment getScopeBreadcrumbDefinition() {
        return null;
    }
}

