/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.LazyFuzzyParamData;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class PortReference
extends Reference {
    private static final String NOPORTWITHNAME = "Component type `{0}'' does not have a port with name `{1}''";
    private Component_Type componentType;

    public PortReference(Reference reference) {
        super(null, reference.getSubreferences());
    }

    public void setComponent(Component_Type componentType) {
        this.componentType = componentType;
    }

    public void setSubreferencesScope(Scope scope) {
        this.subReferences.trimToSize();
        for (int i = 0; i < this.subReferences.size(); ++i) {
            ((ISubReference)this.subReferences.get(i)).setMyScope(scope);
        }
    }

    @Override
    public Reference newInstance() {
        ErrorReporter.INTERNAL_ERROR((String)"Port referencies should not be cloned");
        return null;
    }

    @Override
    public Assignment getRefdAssignment(CompilationTimeStamp timestamp, boolean checkParameterList) {
        if (this.myScope == null || this.componentType == null) {
            return null;
        }
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.referredAssignment;
        }
        super.getRefdAssignment(timestamp, checkParameterList);
        Identifier portIdentifier = this.getId();
        ComponentTypeBody componentBody = this.componentType.getComponentBody();
        if (!componentBody.hasLocalAssignmentWithId(portIdentifier)) {
            this.getLocation().reportSemanticError(MessageFormat.format(NOPORTWITHNAME, this.componentType.getTypename(), portIdentifier.getDisplayName()));
            this.setIsErroneous(true);
            this.referredAssignment = null;
            this.lastTimeChecked = timestamp;
            return null;
        }
        this.referredAssignment = componentBody.getLocalAssignmentById(portIdentifier);
        if (this.referredAssignment != null) {
            String referingModuleName;
            this.referredAssignment.check(timestamp);
            this.referredAssignment.setUsed();
            if (this.referredAssignment instanceof Definition && !((Definition)this.referredAssignment).referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
                ((Definition)this.referredAssignment).referingHere.add(referingModuleName);
            }
        }
        this.lastTimeChecked = timestamp;
        return this.referredAssignment;
    }

    @Override
    public void generateCode(JavaGenData aData, ExpressionStruct expression) {
        FormalParameterList formalParameterList;
        IType referedGovernor;
        boolean isTemplate;
        if (this.referredAssignment == null) {
            return;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                isTemplate = false;
                referedGovernor = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
                break;
            }
            case A_MODULEPAR_TEMPLATE: 
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                isTemplate = true;
                referedGovernor = this.referredAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
                break;
            }
            default: {
                isTemplate = false;
                referedGovernor = null;
            }
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION_RVAL: 
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Function)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: {
                formalParameterList = ((Def_Extfunction)this.referredAssignment).getFormalParameterList();
                break;
            }
            case A_TEMPLATE: {
                formalParameterList = ((Def_Template)this.referredAssignment).getFormalParameterList();
                break;
            }
            default: {
                formalParameterList = null;
            }
        }
        if (this.subReferences.get(0) instanceof ParameterisedSubReference) {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
            expression.expression.append("( ");
            ParameterisedSubReference temp = (ParameterisedSubReference)this.subReferences.get(0);
            temp.getActualParameters().generateCodeAlias(aData, expression, formalParameterList);
            expression.expression.append(" )");
        } else if (formalParameterList != null) {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
            expression.expression.append("( ");
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                if (i > 0) {
                    expression.expression.append(", ");
                }
                formalParameterList.getParameterByIndex(i).getDefaultValue().generateCode(aData, expression, formalParameterList.getParameterByIndex(i));
            }
            expression.expression.append(" )");
        } else if (LazyFuzzyParamData.inLazyOrFuzzy()) {
            expression.expression.append(LazyFuzzyParamData.addReferenceGenname(aData, expression.expression, this.referredAssignment));
        } else {
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, null));
        }
        if (this.referredAssignment.getMyScope() instanceof ComponentTypeBody) {
            switch (this.referredAssignment.getAssignmentType()) {
                case A_VAR: 
                case A_VAR_TEMPLATE: 
                case A_PORT: 
                case A_TIMER: {
                    expression.expression.append(".get()");
                    break;
                }
            }
        }
        PortReference.generateCode(aData, expression, this.subReferences, 1, isTemplate, false, referedGovernor);
    }
}

