/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.semicolon;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.semicolon.SemicolonVisitor;

public class ChangeCreator {
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null || !(module instanceof TTCN3Module)) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        TTCN3Module tModule = (TTCN3Module)module;
        try {
            MultiTextEdit resultEdit = this.semicolonEdit(tModule, toVisit);
            if (!resultEdit.hasChildren()) {
                return null;
            }
            tfc.setEdit((TextEdit)resultEdit);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while ...", (Throwable)e);
        }
        catch (CoreException e) {
            ErrorReporter.logError((String)"AddSemicolonRefactoring/CreateChange.createFileChange(): CoreException while calculating edit locations. ");
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return tfc;
    }

    private MultiTextEdit semicolonEdit(TTCN3Module module, IFile toVisit) throws BadLocationException, CoreException {
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> locations = new HashSet<Integer>();
        SemicolonVisitor visit = new SemicolonVisitor();
        module.accept((ASTVisitor)visit);
        Set<Location> list = visit.getLocations();
        for (Location node : list) {
            int offset = node.getOffset();
            int endoffset = node.getEndOffset();
            if (locations.contains(endoffset)) continue;
            try {
                InputStream is = toVisit.getContents();
                InputStreamReader isr = new InputStreamReader(is, toVisit.getCharset());
                int lenght = endoffset - offset;
                if (lenght <= 0) continue;
                char[] content = new char[lenght];
                isr.skip(offset);
                isr.read(content);
                if (content[lenght - 1] == ';' || content[lenght - 1] == ',' || content[lenght - 1] == '{' || content[lenght - 1] == '}') continue;
                char a = (char)isr.read();
                while (!Character.isAlphabetic(a) && !Character.isDigit(a) && a != ';' && a != ',' && a != '{' && a != '}' && a != ')') {
                    if (a == '/') {
                        while (a == '/') {
                            char b = (char)isr.read();
                            if (b == '/') {
                                while (b != '\n') {
                                    b = (char)isr.read();
                                }
                            } else if (b == '*') {
                                while (a != '*' || b != '/') {
                                    a = b;
                                    b = (char)isr.read();
                                }
                            }
                            a = (char)isr.read();
                        }
                        continue;
                    }
                    a = (char)isr.read();
                }
                if (a == ';' || a == ',' || a == '{' || a == ')') continue;
                locations.add(endoffset);
                edit.addChild((TextEdit)new InsertEdit(endoffset, ";"));
            }
            catch (IOException e) {
                ErrorReporter.logError((String)"AddSemicolonRefactoring.ChangeCreator: Error while reading source project.");
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            catch (CoreException ce) {
                ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (CoreException) for file: " + toVisit.getName()));
                return null;
            }
        }
        return edit;
    }
}

